/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.cli_ng;

import java.io.File;
import java.io.IOException;
import tingeltangel.cli_ng.CLI;
import tingeltangel.cli_ng.CliCmd;
import tingeltangel.core.Book;
import tingeltangel.tools.FileEnvironment;

class LoadBook
extends CliCmd {
    LoadBook() {
    }

    @Override
    public String getName() {
        return "load-book";
    }

    @Override
    public String getDescription() {
        return "load-book <mid>";
    }

    @Override
    public int execute(String[] args) {
        try {
            int mid;
            if (args.length != 1) {
                return this.error("falsche Anzahl von Parametern");
            }
            try {
                mid = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                return this.error("keine Zahl (1-9999) als Parameter angegeben");
            }
            if (mid < 1 || mid > 9999) {
                return this.error("ung\u00fcltige MID angegeben (1-9999)");
            }
            String _mid = Integer.toString(mid);
            while (_mid.length() < 5) {
                _mid = "0" + _mid;
            }
            if (!new File(FileEnvironment.getBooksDirectory(), _mid).exists()) {
                return this.error("Dieses Buch existiert nicht");
            }
            Book book = CLI.getBook();
            book.clear();
            book.setID(mid);
            Book.loadXML(FileEnvironment.getXML(mid), book, null);
            book.resetChangeMade();
        }
        catch (IOException ex) {
            return this.error("das Buch konnte nicht geladen werden", ex);
        }
        return this.ok();
    }
}

