/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.Vector;
import javax.print.CancelablePrintJob;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.HashPrintJobAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintJobAttribute;
import javax.print.attribute.PrintJobAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.DocumentName;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobOriginatingUserName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterState;
import javax.print.attribute.standard.PrinterStateReason;
import javax.print.attribute.standard.PrinterStateReasons;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.event.PrintJobAttributeListener;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;
import sun.awt.windows.WPrinterJob;
import sun.print.ImagePrinter;
import sun.print.PrintJobAttributeException;
import sun.print.PrintJobFlavorException;
import sun.print.Win32PrintService;

public class Win32PrintJob
implements CancelablePrintJob {
    private transient Vector jobListeners;
    private transient Vector attrListeners;
    private transient Vector listenedAttributeSets;
    private Win32PrintService service;
    private boolean fidelity;
    private boolean printing = false;
    private boolean printReturned = false;
    private PrintRequestAttributeSet reqAttrSet = null;
    private PrintJobAttributeSet jobAttrSet = null;
    private PrinterJob job;
    private Doc doc;
    private String mDestination = null;
    private InputStream instream = null;
    private Reader reader = null;
    private String jobName = "Java Printing";
    private int copies = 0;
    private MediaSizeName mediaName = null;
    private MediaSize mediaSize = null;
    private OrientationRequested orient = null;
    private long hPrintJob;
    private static final int PRINTBUFFERLEN = 8192;

    Win32PrintJob(Win32PrintService service) {
        this.service = service;
    }

    @Override
    public PrintService getPrintService() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrintJobAttributeSet getAttributes() {
        Win32PrintJob win32PrintJob = this;
        synchronized (win32PrintJob) {
            if (this.jobAttrSet == null) {
                HashPrintJobAttributeSet jobSet = new HashPrintJobAttributeSet();
                return AttributeSetUtilities.unmodifiableView(jobSet);
            }
            return this.jobAttrSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPrintJobListener(PrintJobListener listener) {
        Win32PrintJob win32PrintJob = this;
        synchronized (win32PrintJob) {
            if (listener == null) {
                return;
            }
            if (this.jobListeners == null) {
                this.jobListeners = new Vector();
            }
            this.jobListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePrintJobListener(PrintJobListener listener) {
        Win32PrintJob win32PrintJob = this;
        synchronized (win32PrintJob) {
            if (listener == null || this.jobListeners == null) {
                return;
            }
            this.jobListeners.remove(listener);
            if (this.jobListeners.isEmpty()) {
                this.jobListeners = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDataStreams() {
        if (this.doc == null) {
            return;
        }
        Object data = null;
        try {
            data = this.doc.getPrintData();
        }
        catch (IOException e) {
            return;
        }
        if (this.instream != null) {
            try {
                this.instream.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.instream = null;
            }
        } else if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.reader = null;
            }
        } else if (data instanceof InputStream) {
            try {
                ((InputStream)data).close();
            }
            catch (IOException iOException) {}
        } else if (data instanceof Reader) {
            try {
                ((Reader)data).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEvent(int reason) {
        switch (reason) {
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: {
                this.closeDataStreams();
            }
        }
        Win32PrintJob win32PrintJob = this;
        synchronized (win32PrintJob) {
            if (this.jobListeners != null) {
                PrintJobEvent event = new PrintJobEvent(this, reason);
                block13: for (int i = 0; i < this.jobListeners.size(); ++i) {
                    PrintJobListener listener = (PrintJobListener)this.jobListeners.elementAt(i);
                    switch (reason) {
                        case 102: {
                            listener.printJobCompleted(event);
                            continue block13;
                        }
                        case 101: {
                            listener.printJobCanceled(event);
                            continue block13;
                        }
                        case 103: {
                            listener.printJobFailed(event);
                            continue block13;
                        }
                        case 106: {
                            listener.printDataTransferCompleted(event);
                            continue block13;
                        }
                        case 105: {
                            listener.printJobNoMoreEvents(event);
                            continue block13;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPrintJobAttributeListener(PrintJobAttributeListener listener, PrintJobAttributeSet attributes) {
        Win32PrintJob win32PrintJob = this;
        synchronized (win32PrintJob) {
            if (listener == null) {
                return;
            }
            if (this.attrListeners == null) {
                this.attrListeners = new Vector();
                this.listenedAttributeSets = new Vector();
            }
            this.attrListeners.add(listener);
            if (attributes == null) {
                attributes = new HashPrintJobAttributeSet();
            }
            this.listenedAttributeSets.add(attributes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePrintJobAttributeListener(PrintJobAttributeListener listener) {
        Win32PrintJob win32PrintJob = this;
        synchronized (win32PrintJob) {
            if (listener == null || this.attrListeners == null) {
                return;
            }
            int index = this.attrListeners.indexOf(listener);
            if (index == -1) {
                return;
            }
            this.attrListeners.remove(index);
            this.listenedAttributeSets.remove(index);
            if (this.attrListeners.isEmpty()) {
                this.attrListeners = null;
                this.listenedAttributeSets = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(Doc doc, PrintRequestAttributeSet attributes) throws PrintException {
        Object data;
        PrinterStateReasons prnStateReasons;
        Win32PrintJob win32PrintJob = this;
        synchronized (win32PrintJob) {
            if (this.printing) {
                throw new PrintException("already printing");
            }
            this.printing = true;
        }
        PrinterState prnState = this.service.getAttribute(PrinterState.class);
        if (prnState == PrinterState.STOPPED && (prnStateReasons = this.service.getAttribute(PrinterStateReasons.class)) != null && prnStateReasons.containsKey(PrinterStateReason.SHUTDOWN)) {
            throw new PrintException("PrintService is no longer available.");
        }
        if (this.service.getAttribute(PrinterIsAcceptingJobs.class) == PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS) {
            throw new PrintException("Printer is not accepting job.");
        }
        this.doc = doc;
        DocFlavor flavor = doc.getDocFlavor();
        try {
            data = doc.getPrintData();
        }
        catch (IOException e) {
            this.notifyEvent(103);
            throw new PrintException("can't get print data: " + e.toString());
        }
        if (data == null) {
            throw new PrintException("Null print data.");
        }
        if (flavor == null || !this.service.isDocFlavorSupported(flavor)) {
            this.notifyEvent(103);
            throw new PrintJobFlavorException("invalid flavor", flavor);
        }
        this.initializeAttributeSets(doc, attributes);
        this.getAttributeValues(flavor);
        String repClassName = flavor.getRepresentationClassName();
        if (flavor.equals(DocFlavor.INPUT_STREAM.GIF) || flavor.equals(DocFlavor.INPUT_STREAM.JPEG) || flavor.equals(DocFlavor.INPUT_STREAM.PNG) || flavor.equals(DocFlavor.BYTE_ARRAY.GIF) || flavor.equals(DocFlavor.BYTE_ARRAY.JPEG) || flavor.equals(DocFlavor.BYTE_ARRAY.PNG)) {
            try {
                this.instream = doc.getStreamForBytes();
                if (this.instream == null) {
                    this.notifyEvent(103);
                    throw new PrintException("No stream for data");
                }
                this.printableJob(new ImagePrinter(this.instream));
                this.service.wakeNotifier();
                return;
            }
            catch (ClassCastException cce) {
                this.notifyEvent(103);
                throw new PrintException(cce);
            }
            catch (IOException ioe) {
                this.notifyEvent(103);
                throw new PrintException(ioe);
            }
        }
        if (flavor.equals(DocFlavor.URL.GIF) || flavor.equals(DocFlavor.URL.JPEG) || flavor.equals(DocFlavor.URL.PNG)) {
            try {
                this.printableJob(new ImagePrinter((URL)data));
                this.service.wakeNotifier();
                return;
            }
            catch (ClassCastException cce) {
                this.notifyEvent(103);
                throw new PrintException(cce);
            }
        }
        if (repClassName.equals("java.awt.print.Pageable")) {
            try {
                this.pageableJob((Pageable)doc.getPrintData());
                this.service.wakeNotifier();
                return;
            }
            catch (ClassCastException cce) {
                this.notifyEvent(103);
                throw new PrintException(cce);
            }
            catch (IOException ioe) {
                this.notifyEvent(103);
                throw new PrintException(ioe);
            }
        }
        if (repClassName.equals("java.awt.print.Printable")) {
            try {
                this.printableJob((Printable)doc.getPrintData());
                this.service.wakeNotifier();
                return;
            }
            catch (ClassCastException cce) {
                this.notifyEvent(103);
                throw new PrintException(cce);
            }
            catch (IOException ioe) {
                this.notifyEvent(103);
                throw new PrintException(ioe);
            }
        }
        if (repClassName.equals("[B") || repClassName.equals("java.io.InputStream") || repClassName.equals("java.net.URL")) {
            if (repClassName.equals("java.net.URL")) {
                URL url = (URL)data;
                try {
                    this.instream = url.openStream();
                }
                catch (IOException e) {
                    this.notifyEvent(103);
                    throw new PrintException(e.toString());
                }
            }
            try {
                this.instream = doc.getStreamForBytes();
            }
            catch (IOException ioe) {
                this.notifyEvent(103);
                throw new PrintException(ioe.toString());
            }
            if (this.instream == null) {
                this.notifyEvent(103);
                throw new PrintException("No stream for data");
            }
            if (this.mDestination != null) {
                try {
                    int cread;
                    FileOutputStream fos = new FileOutputStream(this.mDestination);
                    byte[] buffer = new byte[1024];
                    while ((cread = this.instream.read(buffer, 0, buffer.length)) >= 0) {
                        fos.write(buffer, 0, cread);
                    }
                    fos.flush();
                    fos.close();
                }
                catch (FileNotFoundException fnfe) {
                    this.notifyEvent(103);
                    throw new PrintException(fnfe.toString());
                }
                catch (IOException ioe) {
                    this.notifyEvent(103);
                    throw new PrintException(ioe.toString());
                }
                this.notifyEvent(106);
                this.notifyEvent(102);
                this.service.wakeNotifier();
                return;
            }
            if (!this.startPrintRawData(this.service.getName(), this.jobName)) {
                this.notifyEvent(103);
                throw new PrintException("Print job failed to start.");
            }
            BufferedInputStream bin = new BufferedInputStream(this.instream);
            int bread = 0;
            try {
                byte[] buffer = new byte[8192];
                while ((bread = bin.read(buffer, 0, 8192)) >= 0) {
                    if (this.printRawData(buffer, bread)) continue;
                    bin.close();
                    this.notifyEvent(103);
                    throw new PrintException("Problem while spooling data");
                }
                bin.close();
                if (!this.endPrintRawData()) {
                    this.notifyEvent(103);
                    throw new PrintException("Print job failed to close properly.");
                }
                this.notifyEvent(106);
            }
            catch (IOException e) {
                this.notifyEvent(103);
                throw new PrintException(e.toString());
            }
            finally {
                this.notifyEvent(105);
            }
        }
        this.notifyEvent(103);
        throw new PrintException("unrecognized class: " + repClassName);
        this.service.wakeNotifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printableJob(Printable printable) throws PrintException {
        try {
            Object media;
            Win32PrintJob win32PrintJob = this;
            synchronized (win32PrintJob) {
                if (this.job != null) {
                    throw new PrintException("already printing");
                }
                this.job = new WPrinterJob();
            }
            PrintService svc = this.getPrintService();
            this.job.setPrintService(svc);
            if (this.copies == 0) {
                Copies c = (Copies)svc.getDefaultAttributeValue(Copies.class);
                this.copies = c.getValue();
            }
            if (this.mediaName == null && (media = svc.getDefaultAttributeValue(Media.class)) instanceof MediaSizeName) {
                this.mediaName = (MediaSizeName)media;
                this.mediaSize = MediaSize.getMediaSizeForName(this.mediaName);
            }
            if (this.orient == null) {
                this.orient = (OrientationRequested)svc.getDefaultAttributeValue(OrientationRequested.class);
            }
            this.job.setCopies(this.copies);
            this.job.setJobName(this.jobName);
            PageFormat pf = new PageFormat();
            if (this.mediaSize != null) {
                Paper p = new Paper();
                p.setSize((double)this.mediaSize.getX(25400) * 72.0, (double)this.mediaSize.getY(25400) * 72.0);
                p.setImageableArea(72.0, 72.0, p.getWidth() - 144.0, p.getHeight() - 144.0);
                pf.setPaper(p);
            }
            if (this.orient == OrientationRequested.REVERSE_LANDSCAPE) {
                pf.setOrientation(2);
            } else if (this.orient == OrientationRequested.LANDSCAPE) {
                pf.setOrientation(0);
            }
            this.job.setPrintable(printable, pf);
            this.job.print(this.reqAttrSet);
            this.notifyEvent(106);
            return;
        }
        catch (PrinterException pe) {
            this.notifyEvent(103);
            throw new PrintException(pe);
        }
        finally {
            this.printReturned = true;
            this.notifyEvent(105);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pageableJob(Pageable pageable) throws PrintException {
        try {
            Win32PrintJob win32PrintJob = this;
            synchronized (win32PrintJob) {
                if (this.job != null) {
                    throw new PrintException("already printing");
                }
                this.job = new WPrinterJob();
            }
            PrintService svc = this.getPrintService();
            this.job.setPrintService(svc);
            if (this.copies == 0) {
                Copies c = (Copies)svc.getDefaultAttributeValue(Copies.class);
                this.copies = c.getValue();
            }
            this.job.setCopies(this.copies);
            this.job.setJobName(this.jobName);
            this.job.setPageable(pageable);
            this.job.print(this.reqAttrSet);
            this.notifyEvent(106);
            return;
        }
        catch (PrinterException pe) {
            this.notifyEvent(103);
            throw new PrintException(pe);
        }
        finally {
            this.printReturned = true;
            this.notifyEvent(105);
        }
    }

    private synchronized void initializeAttributeSets(Doc doc, PrintRequestAttributeSet reqSet) {
        DocAttributeSet docSet;
        Attribute[] attrs;
        this.reqAttrSet = new HashPrintRequestAttributeSet();
        this.jobAttrSet = new HashPrintJobAttributeSet();
        if (reqSet != null) {
            this.reqAttrSet.addAll(reqSet);
            attrs = reqSet.toArray();
            for (int i = 0; i < attrs.length; ++i) {
                if (!(attrs[i] instanceof PrintJobAttribute)) continue;
                this.jobAttrSet.add(attrs[i]);
            }
        }
        if ((docSet = doc.getAttributes()) != null) {
            attrs = docSet.toArray();
            for (int i = 0; i < attrs.length; ++i) {
                if (attrs[i] instanceof PrintRequestAttribute) {
                    this.reqAttrSet.add(attrs[i]);
                }
                if (!(attrs[i] instanceof PrintJobAttribute)) continue;
                this.jobAttrSet.add(attrs[i]);
            }
        }
        String userName = "";
        try {
            userName = System.getProperty("user.name");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (userName == null || userName.equals("")) {
            RequestingUserName ruName = (RequestingUserName)reqSet.get(RequestingUserName.class);
            if (ruName != null) {
                this.jobAttrSet.add(new JobOriginatingUserName(ruName.getValue(), ruName.getLocale()));
            } else {
                this.jobAttrSet.add(new JobOriginatingUserName("", null));
            }
        } else {
            this.jobAttrSet.add(new JobOriginatingUserName(userName, null));
        }
        if (this.jobAttrSet.get(JobName.class) == null) {
            JobName jobName;
            if (docSet != null && docSet.get(DocumentName.class) != null) {
                DocumentName docName = (DocumentName)docSet.get(DocumentName.class);
                jobName = new JobName(docName.getValue(), docName.getLocale());
                this.jobAttrSet.add(jobName);
            } else {
                String str = "JPS Job:" + doc;
                try {
                    Object printData = doc.getPrintData();
                    if (printData instanceof URL) {
                        str = ((URL)doc.getPrintData()).toString();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                jobName = new JobName(str, null);
                this.jobAttrSet.add(jobName);
            }
        }
        this.jobAttrSet = AttributeSetUtilities.unmodifiableView(this.jobAttrSet);
    }

    private void getAttributeValues(DocFlavor flavor) throws PrintException {
        this.fidelity = this.reqAttrSet.get(Fidelity.class) == Fidelity.FIDELITY_TRUE;
        Attribute[] attrs = this.reqAttrSet.toArray();
        for (int i = 0; i < attrs.length; ++i) {
            Attribute attr = attrs[i];
            Class<? extends Attribute> category = attr.getCategory();
            if (this.fidelity) {
                if (!this.service.isAttributeCategorySupported(category)) {
                    this.notifyEvent(103);
                    throw new PrintJobAttributeException("unsupported category: " + category, category, null);
                }
                if (!this.service.isAttributeValueSupported(attr, flavor, null)) {
                    this.notifyEvent(103);
                    throw new PrintJobAttributeException("unsupported attribute: " + attr, null, attr);
                }
            }
            if (category == Destination.class) {
                URI uri = ((Destination)attr).getURI();
                if (!"file".equals(uri.getScheme())) {
                    this.notifyEvent(103);
                    throw new PrintException("Not a file: URI");
                }
                try {
                    this.mDestination = new File(uri).getPath();
                }
                catch (Exception e) {
                    throw new PrintException(e);
                }
                SecurityManager security = System.getSecurityManager();
                if (security == null) continue;
                try {
                    security.checkWrite(this.mDestination);
                    continue;
                }
                catch (SecurityException se) {
                    this.notifyEvent(103);
                    throw new PrintException(se);
                }
            }
            if (category == JobName.class) {
                this.jobName = ((JobName)attr).getValue();
                continue;
            }
            if (category == Copies.class) {
                this.copies = ((Copies)attr).getValue();
                continue;
            }
            if (category == Media.class) {
                if (!(attr instanceof MediaSizeName)) continue;
                this.mediaName = (MediaSizeName)attr;
                if (this.service.isAttributeValueSupported(attr, null, null)) continue;
                this.mediaSize = MediaSize.getMediaSizeForName(this.mediaName);
                continue;
            }
            if (category != OrientationRequested.class) continue;
            this.orient = (OrientationRequested)attr;
        }
    }

    private native boolean startPrintRawData(String var1, String var2);

    private native boolean printRawData(byte[] var1, int var2);

    private native boolean endPrintRawData();

    @Override
    public void cancel() throws PrintException {
        Win32PrintJob win32PrintJob = this;
        synchronized (win32PrintJob) {
            if (!this.printing) {
                throw new PrintException("Job is not yet submitted.");
            }
            if (this.job != null && !this.printReturned) {
                this.job.cancel();
                this.notifyEvent(101);
                return;
            }
            throw new PrintException("Job could not be cancelled.");
        }
    }
}

