/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.FileLockInterruptionException;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.OverlappingFileLockException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sun.misc.Cleaner;
import sun.misc.JavaNioAccess;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.FileDispatcher;
import sun.nio.ch.FileDispatcherImpl;
import sun.nio.ch.FileLockImpl;
import sun.nio.ch.FileLockTable;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThreadSet;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SinkChannelImpl;
import sun.nio.ch.Util;
import sun.security.action.GetPropertyAction;

public class FileChannelImpl
extends FileChannel {
    private static final long allocationGranularity;
    private final FileDispatcher nd;
    private final FileDescriptor fd;
    private final boolean writable;
    private final boolean readable;
    private final boolean append;
    private final Object parent;
    private final String path;
    private final NativeThreadSet threads = new NativeThreadSet(2);
    private final Object positionLock = new Object();
    private static volatile boolean transferSupported;
    private static volatile boolean pipeSupported;
    private static volatile boolean fileSupported;
    private static final long MAPPED_TRANSFER_SIZE = 0x800000L;
    private static final int TRANSFER_SIZE = 8192;
    private static final int MAP_RO = 0;
    private static final int MAP_RW = 1;
    private static final int MAP_PV = 2;
    private volatile FileLockTable fileLockTable;
    private static boolean isSharedFileLockTable;
    private static volatile boolean propertyChecked;

    private FileChannelImpl(FileDescriptor fd, String path, boolean readable, boolean writable, boolean append, Object parent) {
        this.fd = fd;
        this.readable = readable;
        this.writable = writable;
        this.append = append;
        this.parent = parent;
        this.path = path;
        this.nd = new FileDispatcherImpl(append);
    }

    public static FileChannel open(FileDescriptor fd, String path, boolean readable, boolean writable, Object parent) {
        return new FileChannelImpl(fd, path, readable, writable, false, parent);
    }

    public static FileChannel open(FileDescriptor fd, String path, boolean readable, boolean writable, boolean append, Object parent) {
        return new FileChannelImpl(fd, path, readable, writable, append, parent);
    }

    private void ensureOpen() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseChannel() throws IOException {
        if (this.fileLockTable != null) {
            Iterator<FileLock> iterator = this.fileLockTable.removeAll().iterator();
            while (iterator.hasNext()) {
                FileLock fl;
                FileLock fileLock = fl = iterator.next();
                synchronized (fileLock) {
                    if (fl.isValid()) {
                        this.nd.release(this.fd, fl.position(), fl.size());
                        ((FileLockImpl)fl).invalidate();
                    }
                }
            }
        }
        this.threads.signalAndWait();
        if (this.parent != null) {
            ((Closeable)this.parent).close();
        } else {
            this.nd.close(this.fd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.ensureOpen();
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
        Object object = this.positionLock;
        synchronized (object) {
            int n3;
            int ti;
            int n;
            block10: {
                n = 0;
                ti = -1;
                this.begin();
                ti = this.threads.add();
                if (this.isOpen()) break block10;
                int n2 = 0;
                this.threads.remove(ti);
                this.end(n > 0);
                assert (IOStatus.check(n));
                return n2;
            }
            try {
                while ((n = IOUtil.read(this.fd, dst, -1L, this.nd)) == -3 && this.isOpen()) {
                }
                n3 = IOStatus.normalize(n);
                this.threads.remove(ti);
                this.end(n > 0);
            }
            catch (Throwable throwable) {
                this.threads.remove(ti);
                this.end(n > 0);
                assert (IOStatus.check(n));
                throw throwable;
            }
            assert (IOStatus.check(n));
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (offset < 0 || length < 0 || offset > dsts.length - length) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureOpen();
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
        Object object = this.positionLock;
        synchronized (object) {
            long l;
            int ti;
            long n;
            block11: {
                n = 0L;
                ti = -1;
                this.begin();
                ti = this.threads.add();
                if (this.isOpen()) break block11;
                long l2 = 0L;
                this.threads.remove(ti);
                this.end(n > 0L);
                assert (IOStatus.check(n));
                return l2;
            }
            try {
                while ((n = IOUtil.read(this.fd, dsts, offset, length, this.nd)) == -3L && this.isOpen()) {
                }
                l = IOStatus.normalize(n);
                this.threads.remove(ti);
                this.end(n > 0L);
            }
            catch (Throwable throwable) {
                this.threads.remove(ti);
                this.end(n > 0L);
                assert (IOStatus.check(n));
                throw throwable;
            }
            assert (IOStatus.check(n));
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        this.ensureOpen();
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        Object object = this.positionLock;
        synchronized (object) {
            int n3;
            int ti;
            int n;
            block10: {
                n = 0;
                ti = -1;
                this.begin();
                ti = this.threads.add();
                if (this.isOpen()) break block10;
                int n2 = 0;
                this.threads.remove(ti);
                this.end(n > 0);
                assert (IOStatus.check(n));
                return n2;
            }
            try {
                while ((n = IOUtil.write(this.fd, src, -1L, this.nd)) == -3 && this.isOpen()) {
                }
                n3 = IOStatus.normalize(n);
                this.threads.remove(ti);
                this.end(n > 0);
            }
            catch (Throwable throwable) {
                this.threads.remove(ti);
                this.end(n > 0);
                assert (IOStatus.check(n));
                throw throwable;
            }
            assert (IOStatus.check(n));
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (offset < 0 || length < 0 || offset > srcs.length - length) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureOpen();
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        Object object = this.positionLock;
        synchronized (object) {
            long l;
            int ti;
            long n;
            block11: {
                n = 0L;
                ti = -1;
                this.begin();
                ti = this.threads.add();
                if (this.isOpen()) break block11;
                long l2 = 0L;
                this.threads.remove(ti);
                this.end(n > 0L);
                assert (IOStatus.check(n));
                return l2;
            }
            try {
                while ((n = IOUtil.write(this.fd, srcs, offset, length, this.nd)) == -3L && this.isOpen()) {
                }
                l = IOStatus.normalize(n);
                this.threads.remove(ti);
                this.end(n > 0L);
            }
            catch (Throwable throwable) {
                this.threads.remove(ti);
                this.end(n > 0L);
                assert (IOStatus.check(n));
                throw throwable;
            }
            assert (IOStatus.check(n));
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long position() throws IOException {
        this.ensureOpen();
        Object object = this.positionLock;
        synchronized (object) {
            long l;
            int ti;
            long p;
            block9: {
                p = -1L;
                ti = -1;
                this.begin();
                ti = this.threads.add();
                if (this.isOpen()) break block9;
                long l2 = 0L;
                this.threads.remove(ti);
                this.end(p > -1L);
                assert (IOStatus.check(p));
                return l2;
            }
            try {
                do {
                    long l3 = p = this.append ? this.nd.size(this.fd) : this.position0(this.fd, -1L);
                } while (p == -3L && this.isOpen());
                l = IOStatus.normalize(p);
                this.threads.remove(ti);
                this.end(p > -1L);
            }
            catch (Throwable throwable) {
                this.threads.remove(ti);
                this.end(p > -1L);
                assert (IOStatus.check(p));
                throw throwable;
            }
            assert (IOStatus.check(p));
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileChannel position(long newPosition) throws IOException {
        this.ensureOpen();
        if (newPosition < 0L) {
            throw new IllegalArgumentException();
        }
        Object object = this.positionLock;
        synchronized (object) {
            FileChannelImpl fileChannelImpl;
            int ti;
            long p;
            block10: {
                p = -1L;
                ti = -1;
                this.begin();
                ti = this.threads.add();
                if (this.isOpen()) break block10;
                FileChannel fileChannel = null;
                this.threads.remove(ti);
                this.end(p > -1L);
                assert (IOStatus.check(p));
                return fileChannel;
            }
            try {
                while ((p = this.position0(this.fd, newPosition)) == -3L && this.isOpen()) {
                }
                fileChannelImpl = this;
                this.threads.remove(ti);
                this.end(p > -1L);
            }
            catch (Throwable throwable) {
                this.threads.remove(ti);
                this.end(p > -1L);
                assert (IOStatus.check(p));
                throw throwable;
            }
            assert (IOStatus.check(p));
            return fileChannelImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long size() throws IOException {
        this.ensureOpen();
        Object object = this.positionLock;
        synchronized (object) {
            long l;
            int ti;
            long s;
            block9: {
                s = -1L;
                ti = -1;
                this.begin();
                ti = this.threads.add();
                if (this.isOpen()) break block9;
                long l2 = -1L;
                this.threads.remove(ti);
                this.end(s > -1L);
                assert (IOStatus.check(s));
                return l2;
            }
            try {
                while ((s = this.nd.size(this.fd)) == -3L && this.isOpen()) {
                }
                l = IOStatus.normalize(s);
                this.threads.remove(ti);
                this.end(s > -1L);
            }
            catch (Throwable throwable) {
                this.threads.remove(ti);
                this.end(s > -1L);
                assert (IOStatus.check(s));
                throw throwable;
            }
            assert (IOStatus.check(s));
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileChannel truncate(long newSize) throws IOException {
        this.ensureOpen();
        if (newSize < 0L) {
            throw new IllegalArgumentException("Negative size");
        }
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        Object object = this.positionLock;
        synchronized (object) {
            FileChannelImpl fileChannelImpl;
            long rp;
            int ti;
            long p;
            int rv;
            block25: {
                long size;
                block24: {
                    block23: {
                        block22: {
                            rv = -1;
                            p = -1L;
                            ti = -1;
                            rp = -1L;
                            this.begin();
                            ti = this.threads.add();
                            if (this.isOpen()) break block22;
                            FileChannel fileChannel = null;
                            this.threads.remove(ti);
                            this.end(rv > -1);
                            assert (IOStatus.check(rv));
                            return fileChannel;
                        }
                        while ((size = this.nd.size(this.fd)) == -3L && this.isOpen()) {
                        }
                        if (this.isOpen()) break block23;
                        FileChannel fileChannel = null;
                        this.threads.remove(ti);
                        this.end(rv > -1);
                        assert (IOStatus.check(rv));
                        return fileChannel;
                    }
                    while ((p = this.position0(this.fd, -1L)) == -3L && this.isOpen()) {
                    }
                    if (this.isOpen()) break block24;
                    FileChannel fileChannel = null;
                    this.threads.remove(ti);
                    this.end(rv > -1);
                    assert (IOStatus.check(rv));
                    return fileChannel;
                }
                assert (p >= 0L);
                if (newSize >= size) break block25;
                while ((rv = this.nd.truncate(this.fd, newSize)) == -3 && this.isOpen()) {
                }
                if (this.isOpen()) break block25;
                FileChannel fileChannel = null;
                this.threads.remove(ti);
                this.end(rv > -1);
                assert (IOStatus.check(rv));
                return fileChannel;
            }
            try {
                if (p > newSize) {
                    p = newSize;
                }
                while ((rp = this.position0(this.fd, p)) == -3L && this.isOpen()) {
                }
                fileChannelImpl = this;
                this.threads.remove(ti);
                this.end(rv > -1);
            }
            catch (Throwable throwable) {
                this.threads.remove(ti);
                this.end(rv > -1);
                assert (IOStatus.check(rv));
                throw throwable;
            }
            assert (IOStatus.check(rv));
            return fileChannelImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void force(boolean metaData) throws IOException {
        int ti;
        int rv;
        block7: {
            this.ensureOpen();
            rv = -1;
            ti = -1;
            this.begin();
            ti = this.threads.add();
            if (this.isOpen()) break block7;
            this.threads.remove(ti);
            this.end(rv > -1);
            assert (IOStatus.check(rv));
            return;
        }
        try {
            while ((rv = this.nd.force(this.fd, metaData)) == -3 && this.isOpen()) {
            }
            this.threads.remove(ti);
            this.end(rv > -1);
        }
        catch (Throwable throwable) {
            this.threads.remove(ti);
            this.end(rv > -1);
            assert (IOStatus.check(rv));
            throw throwable;
        }
        assert (IOStatus.check(rv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long transferToDirectlyInternal(long position, int icount, WritableByteChannel target, FileDescriptor targetFD) throws IOException {
        int ti;
        long n;
        block11: {
            block10: {
                long l;
                block9: {
                    assert (!this.nd.transferToDirectlyNeedsPositionLock() || Thread.holdsLock(this.positionLock));
                    n = -1L;
                    ti = -1;
                    this.begin();
                    ti = this.threads.add();
                    if (this.isOpen()) break block9;
                    long l2 = -1L;
                    this.threads.remove(ti);
                    this.end(n > -1L);
                    return l2;
                }
                try {
                    while ((n = this.transferTo0(this.fd, position, icount, targetFD)) == -3L && this.isOpen()) {
                    }
                    if (n != -6L) break block10;
                    if (target instanceof SinkChannelImpl) {
                        pipeSupported = false;
                    }
                    if (target instanceof FileChannelImpl) {
                        fileSupported = false;
                    }
                    l = -6L;
                    this.threads.remove(ti);
                    this.end(n > -1L);
                }
                catch (Throwable throwable) {
                    this.threads.remove(ti);
                    this.end(n > -1L);
                    throw throwable;
                }
                return l;
            }
            if (n != -4L) break block11;
            transferSupported = false;
            long l = -4L;
            this.threads.remove(ti);
            this.end(n > -1L);
            return l;
        }
        long l = IOStatus.normalize(n);
        this.threads.remove(ti);
        this.end(n > -1L);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long transferToDirectly(long position, int icount, WritableByteChannel target) throws IOException {
        int targetFDVal;
        if (!transferSupported) {
            return -4L;
        }
        FileDescriptor targetFD = null;
        if (target instanceof FileChannelImpl) {
            if (!fileSupported) {
                return -6L;
            }
            targetFD = ((FileChannelImpl)target).fd;
        } else if (target instanceof SelChImpl) {
            if (target instanceof SinkChannelImpl && !pipeSupported) {
                return -6L;
            }
            SelectableChannel sc = (SelectableChannel)((Object)target);
            if (!this.nd.canTransferToDirectly(sc)) {
                return -6L;
            }
            targetFD = ((SelChImpl)((Object)target)).getFD();
        }
        if (targetFD == null) {
            return -4L;
        }
        int thisFDVal = IOUtil.fdVal(this.fd);
        if (thisFDVal == (targetFDVal = IOUtil.fdVal(targetFD))) {
            return -4L;
        }
        if (this.nd.transferToDirectlyNeedsPositionLock()) {
            Object object = this.positionLock;
            synchronized (object) {
                long l;
                long pos = this.position();
                try {
                    l = this.transferToDirectlyInternal(position, icount, target, targetFD);
                }
                catch (Throwable throwable) {
                    this.position(pos);
                    throw throwable;
                }
                this.position(pos);
                return l;
            }
        }
        return this.transferToDirectlyInternal(position, icount, target, targetFD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long transferToTrustedChannel(long position, long count, WritableByteChannel target) throws IOException {
        boolean isSelChImpl = target instanceof SelChImpl;
        if (!(target instanceof FileChannelImpl) && !isSelChImpl) {
            return -4L;
        }
        long remaining = count;
        while (remaining > 0L) {
            long size = Math.min(remaining, 0x800000L);
            try {
                MappedByteBuffer dbb = this.map(FileChannel.MapMode.READ_ONLY, position, size);
                try {
                    int n = target.write(dbb);
                    assert (n >= 0);
                    remaining -= (long)n;
                    if (isSelChImpl) break;
                    assert (n > 0);
                    position += (long)n;
                }
                finally {
                    FileChannelImpl.unmap(dbb);
                }
            }
            catch (ClosedByInterruptException e) {
                assert (!target.isOpen());
                try {
                    this.close();
                }
                catch (Throwable suppressed) {
                    e.addSuppressed(suppressed);
                }
                throw e;
            }
            catch (IOException ioe) {
                if (remaining != count) break;
                throw ioe;
            }
        }
        return count - remaining;
    }

    private long transferToArbitraryChannel(long position, int icount, WritableByteChannel target) throws IOException {
        int c = Math.min(icount, 8192);
        ByteBuffer bb = ByteBuffer.allocate(c);
        long tw = 0L;
        long pos = position;
        try {
            while (tw < (long)icount) {
                bb.limit(Math.min((int)((long)icount - tw), 8192));
                int nr = this.read(bb, pos);
                if (nr <= 0) break;
                bb.flip();
                int nw = target.write(bb);
                tw += (long)nw;
                if (nw != nr) break;
                pos += (long)nw;
                bb.clear();
            }
            return tw;
        }
        catch (IOException x) {
            if (tw > 0L) {
                return tw;
            }
            throw x;
        }
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        long n;
        this.ensureOpen();
        if (!target.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
        if (target instanceof FileChannelImpl && !((FileChannelImpl)target).writable) {
            throw new NonWritableChannelException();
        }
        if (position < 0L || count < 0L) {
            throw new IllegalArgumentException();
        }
        long sz = this.size();
        if (position > sz) {
            return 0L;
        }
        int icount = (int)Math.min(count, Integer.MAX_VALUE);
        if (sz - position < (long)icount) {
            icount = (int)(sz - position);
        }
        if ((n = this.transferToDirectly(position, icount, target)) >= 0L) {
            return n;
        }
        n = this.transferToTrustedChannel(position, icount, target);
        if (n >= 0L) {
            return n;
        }
        return this.transferToArbitraryChannel(position, icount, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long transferFromFileChannel(FileChannelImpl src, long position, long count) throws IOException {
        if (!src.readable) {
            throw new NonReadableChannelException();
        }
        Object object = src.positionLock;
        synchronized (object) {
            long max;
            long pos = src.position();
            long remaining = max = Math.min(count, src.size() - pos);
            long p = pos;
            while (remaining > 0L) {
                long size = Math.min(remaining, 0x800000L);
                MappedByteBuffer bb = src.map(FileChannel.MapMode.READ_ONLY, p, size);
                try {
                    long n = this.write(bb, position);
                    assert (n > 0L);
                    p += n;
                    position += n;
                    remaining -= n;
                }
                catch (IOException ioe) {
                    if (remaining != max) break;
                    throw ioe;
                }
                finally {
                    FileChannelImpl.unmap(bb);
                }
            }
            long nwritten = max - remaining;
            src.position(pos + nwritten);
            return nwritten;
        }
    }

    private long transferFromArbitraryChannel(ReadableByteChannel src, long position, long count) throws IOException {
        int c = (int)Math.min(count, 8192L);
        ByteBuffer bb = ByteBuffer.allocate(c);
        long tw = 0L;
        long pos = position;
        try {
            while (tw < count) {
                bb.limit((int)Math.min(count - tw, 8192L));
                int nr = src.read(bb);
                if (nr <= 0) break;
                bb.flip();
                int nw = this.write(bb, pos);
                tw += (long)nw;
                if (nw != nr) break;
                pos += (long)nw;
                bb.clear();
            }
            return tw;
        }
        catch (IOException x) {
            if (tw > 0L) {
                return tw;
            }
            throw x;
        }
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        this.ensureOpen();
        if (!src.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        if (position < 0L || count < 0L) {
            throw new IllegalArgumentException();
        }
        if (position > this.size()) {
            return 0L;
        }
        if (src instanceof FileChannelImpl) {
            return this.transferFromFileChannel((FileChannelImpl)src, position, count);
        }
        return this.transferFromArbitraryChannel(src, position, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        if (dst == null) {
            throw new NullPointerException();
        }
        if (position < 0L) {
            throw new IllegalArgumentException("Negative position");
        }
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
        this.ensureOpen();
        if (this.nd.needsPositionLock()) {
            Object object = this.positionLock;
            synchronized (object) {
                return this.readInternal(dst, position);
            }
        }
        return this.readInternal(dst, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readInternal(ByteBuffer dst, long position) throws IOException {
        int n;
        int ti;
        int n2;
        block8: {
            assert (!this.nd.needsPositionLock() || Thread.holdsLock(this.positionLock));
            n2 = 0;
            ti = -1;
            this.begin();
            ti = this.threads.add();
            if (this.isOpen()) break block8;
            int n3 = -1;
            this.threads.remove(ti);
            this.end(n2 > 0);
            assert (IOStatus.check(n2));
            return n3;
        }
        try {
            while ((n2 = IOUtil.read(this.fd, dst, position, this.nd)) == -3 && this.isOpen()) {
            }
            n = IOStatus.normalize(n2);
            this.threads.remove(ti);
            this.end(n2 > 0);
        }
        catch (Throwable throwable) {
            this.threads.remove(ti);
            this.end(n2 > 0);
            assert (IOStatus.check(n2));
            throw throwable;
        }
        assert (IOStatus.check(n2));
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        if (src == null) {
            throw new NullPointerException();
        }
        if (position < 0L) {
            throw new IllegalArgumentException("Negative position");
        }
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        this.ensureOpen();
        if (this.nd.needsPositionLock()) {
            Object object = this.positionLock;
            synchronized (object) {
                return this.writeInternal(src, position);
            }
        }
        return this.writeInternal(src, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeInternal(ByteBuffer src, long position) throws IOException {
        int n;
        int ti;
        int n2;
        block8: {
            assert (!this.nd.needsPositionLock() || Thread.holdsLock(this.positionLock));
            n2 = 0;
            ti = -1;
            this.begin();
            ti = this.threads.add();
            if (this.isOpen()) break block8;
            int n3 = -1;
            this.threads.remove(ti);
            this.end(n2 > 0);
            assert (IOStatus.check(n2));
            return n3;
        }
        try {
            while ((n2 = IOUtil.write(this.fd, src, position, this.nd)) == -3 && this.isOpen()) {
            }
            n = IOStatus.normalize(n2);
            this.threads.remove(ti);
            this.end(n2 > 0);
        }
        catch (Throwable throwable) {
            this.threads.remove(ti);
            this.end(n2 > 0);
            assert (IOStatus.check(n2));
            throw throwable;
        }
        assert (IOStatus.check(n2));
        return n;
    }

    private static void unmap(MappedByteBuffer bb) {
        Cleaner cl = ((DirectBuffer)((Object)bb)).cleaner();
        if (cl != null) {
            cl.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        long filesize;
        int ti;
        long addr;
        int imode;
        block44: {
            block43: {
                this.ensureOpen();
                if (mode == null) {
                    throw new NullPointerException("Mode is null");
                }
                if (position < 0L) {
                    throw new IllegalArgumentException("Negative position");
                }
                if (size < 0L) {
                    throw new IllegalArgumentException("Negative size");
                }
                if (position + size < 0L) {
                    throw new IllegalArgumentException("Position + size overflow");
                }
                if (size > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("Size exceeds Integer.MAX_VALUE");
                }
                imode = -1;
                if (mode == FileChannel.MapMode.READ_ONLY) {
                    imode = 0;
                } else if (mode == FileChannel.MapMode.READ_WRITE) {
                    imode = 1;
                } else if (mode == FileChannel.MapMode.PRIVATE) {
                    imode = 2;
                }
                assert (imode >= 0);
                if (mode != FileChannel.MapMode.READ_ONLY && !this.writable) {
                    throw new NonWritableChannelException();
                }
                if (!this.readable) {
                    throw new NonReadableChannelException();
                }
                addr = -1L;
                ti = -1;
                this.begin();
                ti = this.threads.add();
                if (this.isOpen()) break block43;
                MappedByteBuffer mappedByteBuffer = null;
                this.threads.remove(ti);
                this.end(IOStatus.checkAll(addr));
                return mappedByteBuffer;
            }
            Object object = this.positionLock;
            // MONITORENTER : object
            while ((filesize = this.nd.size(this.fd)) == -3L && this.isOpen()) {
            }
            if (this.isOpen()) break block44;
            MappedByteBuffer mappedByteBuffer = null;
            // MONITOREXIT : object
            this.threads.remove(ti);
            this.end(IOStatus.checkAll(addr));
            return mappedByteBuffer;
        }
        if (filesize < position + size) {
            int rv;
            if (!this.writable) {
                throw new IOException("Channel not open for writing - cannot extend file to required size");
            }
            while ((rv = this.nd.allocate(this.fd, position + size)) == -3 && this.isOpen()) {
            }
            if (!this.isOpen()) {
                MappedByteBuffer mappedByteBuffer = null;
                // MONITOREXIT : object
                this.threads.remove(ti);
                this.end(IOStatus.checkAll(addr));
                return mappedByteBuffer;
            }
        }
        if (size == 0L) {
            addr = 0L;
            FileDescriptor dummy = new FileDescriptor();
            if (this.writable && imode != 0) {
                MappedByteBuffer mappedByteBuffer = Util.newMappedByteBuffer(0, 0L, dummy, null);
                // MONITOREXIT : object
                this.threads.remove(ti);
                this.end(IOStatus.checkAll(addr));
                return mappedByteBuffer;
            }
            MappedByteBuffer mappedByteBuffer = Util.newMappedByteBufferR(0, 0L, dummy, null);
            // MONITOREXIT : object
            this.threads.remove(ti);
            this.end(IOStatus.checkAll(addr));
            return mappedByteBuffer;
        }
        try {
            FileDescriptor mfd;
            int pagePosition = (int)(position % allocationGranularity);
            long mapPosition = position - (long)pagePosition;
            long mapSize = size + (long)pagePosition;
            try {
                addr = this.map0(imode, mapPosition, mapSize);
            }
            catch (OutOfMemoryError x) {
                System.gc();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException y) {
                    Thread.currentThread().interrupt();
                }
                try {
                    addr = this.map0(imode, mapPosition, mapSize);
                }
                catch (OutOfMemoryError y) {
                    throw new IOException("Map failed", y);
                }
            }
            try {
                mfd = this.nd.duplicateForMapping(this.fd);
            }
            catch (IOException ioe) {
                FileChannelImpl.unmap0(addr, mapSize);
                throw ioe;
            }
            assert (IOStatus.checkAll(addr));
            assert (addr % allocationGranularity == 0L);
            int isize = (int)size;
            Unmapper um = new Unmapper(addr, mapSize, isize, mfd);
            if (!this.writable || imode == 0) {
                MappedByteBuffer mappedByteBuffer = Util.newMappedByteBufferR(isize, addr + (long)pagePosition, mfd, um);
                return mappedByteBuffer;
            }
            MappedByteBuffer mappedByteBuffer = Util.newMappedByteBuffer(isize, addr + (long)pagePosition, mfd, um);
            return mappedByteBuffer;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.threads.remove(ti);
            this.end(IOStatus.checkAll(addr));
        }
    }

    public static JavaNioAccess.BufferPool getMappedBufferPool() {
        return new JavaNioAccess.BufferPool(){

            @Override
            public String getName() {
                return "mapped";
            }

            @Override
            public long getCount() {
                return Unmapper.count;
            }

            @Override
            public long getTotalCapacity() {
                return Unmapper.totalCapacity;
            }

            @Override
            public long getMemoryUsed() {
                return Unmapper.totalSize;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isSharedFileLockTable() {
        if (propertyChecked) return isSharedFileLockTable;
        Class<FileChannelImpl> clazz = FileChannelImpl.class;
        synchronized (FileChannelImpl.class) {
            if (propertyChecked) return isSharedFileLockTable;
            String value = AccessController.doPrivileged(new GetPropertyAction("sun.nio.ch.disableSystemWideOverlappingFileLockCheck"));
            isSharedFileLockTable = value == null || value.equals("false");
            propertyChecked = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return isSharedFileLockTable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileLockTable fileLockTable() throws IOException {
        if (this.fileLockTable == null) {
            FileChannelImpl fileChannelImpl = this;
            synchronized (fileChannelImpl) {
                if (this.fileLockTable == null) {
                    if (FileChannelImpl.isSharedFileLockTable()) {
                        int ti = this.threads.add();
                        try {
                            this.ensureOpen();
                            this.fileLockTable = FileLockTable.newSharedFileLockTable(this, this.fd);
                        }
                        finally {
                            this.threads.remove(ti);
                        }
                    } else {
                        this.fileLockTable = new SimpleFileLockTable();
                    }
                }
            }
        }
        return this.fileLockTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        this.ensureOpen();
        if (shared && !this.readable) {
            throw new NonReadableChannelException();
        }
        if (!shared && !this.writable) {
            throw new NonWritableChannelException();
        }
        FileLockImpl fli = new FileLockImpl(this, position, size, shared);
        FileLockTable flt = this.fileLockTable();
        flt.add(fli);
        boolean completed = false;
        int ti = -1;
        try {
            int n;
            this.begin();
            ti = this.threads.add();
            if (!this.isOpen()) {
                FileLock fileLock = null;
                return fileLock;
            }
            while ((n = this.nd.lock(this.fd, true, position, size, shared)) == 2 && this.isOpen()) {
            }
            if (this.isOpen()) {
                if (n == 1) {
                    assert (shared);
                    FileLockImpl fli2 = new FileLockImpl(this, position, size, false);
                    flt.replace(fli, fli2);
                    fli = fli2;
                }
                completed = true;
            }
        }
        finally {
            if (!completed) {
                flt.remove(fli);
            }
            this.threads.remove(ti);
            try {
                this.end(completed);
            }
            catch (ClosedByInterruptException e) {
                throw new FileLockInterruptionException();
            }
        }
        return fli;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        this.ensureOpen();
        if (shared && !this.readable) {
            throw new NonReadableChannelException();
        }
        if (!shared && !this.writable) {
            throw new NonWritableChannelException();
        }
        FileLockImpl fli = new FileLockImpl(this, position, size, shared);
        FileLockTable flt = this.fileLockTable();
        flt.add(fli);
        int ti = this.threads.add();
        try {
            int result;
            try {
                this.ensureOpen();
                result = this.nd.lock(this.fd, false, position, size, shared);
            }
            catch (IOException e) {
                flt.remove(fli);
                throw e;
            }
            if (result == -1) {
                flt.remove(fli);
                FileLock e = null;
                return e;
            }
            if (result == 1) {
                assert (shared);
                FileLockImpl fli2 = new FileLockImpl(this, position, size, false);
                flt.replace(fli, fli2);
                FileLockImpl fileLockImpl = fli2;
                return fileLockImpl;
            }
            FileLockImpl fileLockImpl = fli;
            return fileLockImpl;
        }
        finally {
            this.threads.remove(ti);
        }
    }

    void release(FileLockImpl fli) throws IOException {
        int ti = this.threads.add();
        try {
            this.ensureOpen();
            this.nd.release(this.fd, fli.position(), fli.size());
        }
        finally {
            this.threads.remove(ti);
        }
        assert (this.fileLockTable != null);
        this.fileLockTable.remove(fli);
    }

    private native long map0(int var1, long var2, long var4) throws IOException;

    private static native int unmap0(long var0, long var2);

    private native long transferTo0(FileDescriptor var1, long var2, long var4, FileDescriptor var6);

    private native long position0(FileDescriptor var1, long var2);

    private static native long initIDs();

    static {
        transferSupported = true;
        pipeSupported = true;
        fileSupported = true;
        IOUtil.load();
        allocationGranularity = FileChannelImpl.initIDs();
    }

    private static class SimpleFileLockTable
    extends FileLockTable {
        private final List<FileLock> lockList = new ArrayList<FileLock>(2);

        private void checkList(long position, long size) throws OverlappingFileLockException {
            assert (Thread.holdsLock(this.lockList));
            for (FileLock fl : this.lockList) {
                if (!fl.overlaps(position, size)) continue;
                throw new OverlappingFileLockException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(FileLock fl) throws OverlappingFileLockException {
            List<FileLock> list = this.lockList;
            synchronized (list) {
                this.checkList(fl.position(), fl.size());
                this.lockList.add(fl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(FileLock fl) {
            List<FileLock> list = this.lockList;
            synchronized (list) {
                this.lockList.remove(fl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<FileLock> removeAll() {
            List<FileLock> list = this.lockList;
            synchronized (list) {
                ArrayList<FileLock> result = new ArrayList<FileLock>(this.lockList);
                this.lockList.clear();
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replace(FileLock fl1, FileLock fl2) {
            List<FileLock> list = this.lockList;
            synchronized (list) {
                this.lockList.remove(fl1);
                this.lockList.add(fl2);
            }
        }
    }

    private static class Unmapper
    implements Runnable {
        private static final NativeDispatcher nd = new FileDispatcherImpl();
        static volatile int count;
        static volatile long totalSize;
        static volatile long totalCapacity;
        private volatile long address;
        private final long size;
        private final int cap;
        private final FileDescriptor fd;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Unmapper(long address, long size, int cap, FileDescriptor fd) {
            assert (address != 0L);
            this.address = address;
            this.size = size;
            this.cap = cap;
            this.fd = fd;
            Class<Unmapper> clazz = Unmapper.class;
            synchronized (Unmapper.class) {
                ++count;
                totalSize += size;
                totalCapacity += (long)cap;
                // ** MonitorExit[var7_5] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.address == 0L) {
                return;
            }
            FileChannelImpl.unmap0(this.address, this.size);
            this.address = 0L;
            if (this.fd.valid()) {
                try {
                    nd.close(this.fd);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            Class<Unmapper> clazz = Unmapper.class;
            synchronized (Unmapper.class) {
                --count;
                totalSize -= this.size;
                totalCapacity -= (long)this.cap;
                // ** MonitorExit[var1_2] (shouldn't be in output)
                return;
            }
        }
    }
}

