/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.shell;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import sun.awt.OSInfo;
import sun.awt.shell.ShellFolder;
import sun.awt.shell.ShellFolderManager;
import sun.awt.shell.Win32ShellFolder2;
import sun.awt.windows.WToolkit;
import sun.misc.ThreadGroupUtils;

public class Win32ShellFolderManager2
extends ShellFolderManager {
    private static final int VIEW_LIST = 2;
    private static final int VIEW_DETAILS = 3;
    private static final int VIEW_PARENTFOLDER = 8;
    private static final int VIEW_NEWFOLDER = 11;
    private static final Image[] STANDARD_VIEW_BUTTONS;
    private static Win32ShellFolder2 desktop;
    private static Win32ShellFolder2 drives;
    private static Win32ShellFolder2 recent;
    private static Win32ShellFolder2 network;
    private static Win32ShellFolder2 personal;
    private static File[] roots;
    private static List topFolderList;

    @Override
    public ShellFolder createShellFolder(File file) throws FileNotFoundException {
        try {
            return Win32ShellFolderManager2.createShellFolder(Win32ShellFolderManager2.getDesktop(), file);
        }
        catch (InterruptedException e) {
            throw new FileNotFoundException("Execution was interrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Win32ShellFolder2 createShellFolder(Win32ShellFolder2 parent, File file) throws FileNotFoundException, InterruptedException {
        long pIDL;
        try {
            pIDL = parent.parseDisplayName(file.getCanonicalPath());
        }
        catch (IOException ex) {
            pIDL = 0L;
        }
        if (pIDL == 0L) {
            throw new FileNotFoundException("File " + file.getAbsolutePath() + " not found");
        }
        try {
            Win32ShellFolder2 win32ShellFolder2 = Win32ShellFolderManager2.createShellFolderFromRelativePIDL(parent, pIDL);
            return win32ShellFolder2;
        }
        finally {
            Win32ShellFolder2.releasePIDL(pIDL);
        }
    }

    static Win32ShellFolder2 createShellFolderFromRelativePIDL(Win32ShellFolder2 parent, long pIDL) throws InterruptedException {
        long curPIDL;
        while (pIDL != 0L && (curPIDL = Win32ShellFolder2.copyFirstPIDLEntry(pIDL)) != 0L) {
            parent = new Win32ShellFolder2(parent, curPIDL);
            pIDL = Win32ShellFolder2.getNextPIDLEntry(pIDL);
        }
        return parent;
    }

    private static Image getStandardViewButton(int iconIndex) {
        Image result = STANDARD_VIEW_BUTTONS[iconIndex];
        if (result != null) {
            return result;
        }
        BufferedImage img = new BufferedImage(16, 16, 2);
        img.setRGB(0, 0, 16, 16, Win32ShellFolder2.getStandardViewButton0(iconIndex), 0, 16);
        Win32ShellFolderManager2.STANDARD_VIEW_BUTTONS[iconIndex] = img;
        return img;
    }

    static Win32ShellFolder2 getDesktop() {
        if (desktop == null) {
            try {
                desktop = new Win32ShellFolder2(0);
            }
            catch (SecurityException securityException) {
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return desktop;
    }

    static Win32ShellFolder2 getDrives() {
        if (drives == null) {
            try {
                drives = new Win32ShellFolder2(17);
            }
            catch (SecurityException securityException) {
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return drives;
    }

    static Win32ShellFolder2 getRecent() {
        if (recent == null) {
            try {
                String path = Win32ShellFolder2.getFileSystemPath(8);
                if (path != null) {
                    recent = Win32ShellFolderManager2.createShellFolder(Win32ShellFolderManager2.getDesktop(), new File(path));
                }
            }
            catch (SecurityException securityException) {
            }
            catch (InterruptedException interruptedException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return recent;
    }

    static Win32ShellFolder2 getNetwork() {
        if (network == null) {
            try {
                network = new Win32ShellFolder2(18);
            }
            catch (SecurityException securityException) {
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return network;
    }

    static Win32ShellFolder2 getPersonal() {
        if (personal == null) {
            try {
                String path = Win32ShellFolder2.getFileSystemPath(5);
                if (path != null) {
                    Win32ShellFolder2 desktop = Win32ShellFolderManager2.getDesktop();
                    personal = desktop.getChildByPath(path);
                    if (personal == null) {
                        personal = Win32ShellFolderManager2.createShellFolder(Win32ShellFolderManager2.getDesktop(), new File(path));
                    }
                    if (personal != null) {
                        personal.setIsPersonal();
                    }
                }
            }
            catch (SecurityException securityException) {
            }
            catch (InterruptedException interruptedException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return personal;
    }

    @Override
    public Object get(String key) {
        if (key.equals("fileChooserDefaultFolder")) {
            Win32ShellFolder2 file = Win32ShellFolderManager2.getPersonal();
            if (file == null) {
                file = Win32ShellFolderManager2.getDesktop();
            }
            return Win32ShellFolderManager2.checkFile(file);
        }
        if (key.equals("roots")) {
            if (roots == null) {
                Win32ShellFolder2 desktop = Win32ShellFolderManager2.getDesktop();
                roots = desktop != null ? new File[]{desktop} : (File[])super.get(key);
            }
            return Win32ShellFolderManager2.checkFiles(roots);
        }
        if (key.equals("fileChooserComboBoxFolders")) {
            Win32ShellFolder2 desktop = Win32ShellFolderManager2.getDesktop();
            if (desktop != null && Win32ShellFolderManager2.checkFile(desktop) != null) {
                ArrayList<File> folders = new ArrayList<File>();
                Win32ShellFolder2 drives = Win32ShellFolderManager2.getDrives();
                Win32ShellFolder2 recentFolder = Win32ShellFolderManager2.getRecent();
                if (recentFolder != null && OSInfo.getWindowsVersion().compareTo(OSInfo.WINDOWS_2000) >= 0) {
                    folders.add(recentFolder);
                }
                folders.add(desktop);
                Object[] secondLevelFolders = Win32ShellFolderManager2.checkFiles(desktop.listFiles());
                Arrays.sort(secondLevelFolders);
                for (Object secondLevelFolder : secondLevelFolders) {
                    File[] thirdLevelFolders;
                    Win32ShellFolder2 folder = (Win32ShellFolder2)secondLevelFolder;
                    if (folder.isFileSystem() && (!folder.isDirectory() || folder.isLink())) continue;
                    folders.add(folder);
                    if (!folder.equals(drives) || (thirdLevelFolders = Win32ShellFolderManager2.checkFiles(folder.listFiles())) == null || thirdLevelFolders.length <= 0) continue;
                    List<File> thirdLevelFoldersList = Arrays.asList(thirdLevelFolders);
                    folder.sortChildren(thirdLevelFoldersList);
                    folders.addAll(thirdLevelFoldersList);
                }
                return Win32ShellFolderManager2.checkFiles(folders);
            }
            return super.get(key);
        }
        if (key.equals("fileChooserShortcutPanelFolders")) {
            Object value;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            ArrayList<File> folders = new ArrayList<File>();
            int i = 0;
            do {
                value = toolkit.getDesktopProperty("win.comdlg.placesBarPlace" + i++);
                try {
                    if (value instanceof Integer) {
                        folders.add(new Win32ShellFolder2((Integer)value));
                        continue;
                    }
                    if (!(value instanceof String)) continue;
                    folders.add(this.createShellFolder(new File((String)value)));
                }
                catch (IOException secondLevelFolders) {
                }
                catch (InterruptedException e) {
                    return new File[0];
                }
            } while (value != null);
            if (folders.size() == 0) {
                for (File f : new File[]{Win32ShellFolderManager2.getRecent(), Win32ShellFolderManager2.getDesktop(), Win32ShellFolderManager2.getPersonal(), Win32ShellFolderManager2.getDrives(), Win32ShellFolderManager2.getNetwork()}) {
                    if (f == null) continue;
                    folders.add(f);
                }
            }
            return Win32ShellFolderManager2.checkFiles(folders);
        }
        if (key.startsWith("fileChooserIcon ")) {
            int iconIndex;
            String name = key.substring(key.indexOf(" ") + 1);
            if (name.equals("ListView") || name.equals("ViewMenu")) {
                iconIndex = 2;
            } else if (name.equals("DetailsView")) {
                iconIndex = 3;
            } else if (name.equals("UpFolder")) {
                iconIndex = 8;
            } else if (name.equals("NewFolder")) {
                iconIndex = 11;
            } else {
                return null;
            }
            return Win32ShellFolderManager2.getStandardViewButton(iconIndex);
        }
        if (key.startsWith("optionPaneIcon ")) {
            Win32ShellFolder2.SystemIcon iconType;
            if (key == "optionPaneIcon Error") {
                iconType = Win32ShellFolder2.SystemIcon.IDI_ERROR;
            } else if (key == "optionPaneIcon Information") {
                iconType = Win32ShellFolder2.SystemIcon.IDI_INFORMATION;
            } else if (key == "optionPaneIcon Question") {
                iconType = Win32ShellFolder2.SystemIcon.IDI_QUESTION;
            } else if (key == "optionPaneIcon Warning") {
                iconType = Win32ShellFolder2.SystemIcon.IDI_EXCLAMATION;
            } else {
                return null;
            }
            return Win32ShellFolder2.getSystemIcon(iconType);
        }
        if (key.startsWith("shell32Icon ") || key.startsWith("shell32LargeIcon ")) {
            String name = key.substring(key.indexOf(" ") + 1);
            try {
                int i = Integer.parseInt(name);
                if (i >= 0) {
                    return Win32ShellFolder2.getShell32Icon(i, key.startsWith("shell32LargeIcon "));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static File checkFile(File file) {
        SecurityManager sm = System.getSecurityManager();
        return sm == null || file == null ? file : Win32ShellFolderManager2.checkFile(file, sm);
    }

    private static File checkFile(File file, SecurityManager sm) {
        try {
            Win32ShellFolder2 link;
            Win32ShellFolder2 f;
            sm.checkRead(file.getPath());
            if (file instanceof Win32ShellFolder2 && (f = (Win32ShellFolder2)file).isLink() && (link = (Win32ShellFolder2)f.getLinkLocation()) != null) {
                sm.checkRead(link.getPath());
            }
            return file;
        }
        catch (SecurityException se) {
            return null;
        }
    }

    static File[] checkFiles(File[] files) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null || files == null || files.length == 0) {
            return files;
        }
        return Win32ShellFolderManager2.checkFiles(Arrays.stream(files), sm);
    }

    private static File[] checkFiles(List<File> files) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null || files.isEmpty()) {
            return files.toArray(new File[files.size()]);
        }
        return Win32ShellFolderManager2.checkFiles(files.stream(), sm);
    }

    private static File[] checkFiles(Stream<File> filesStream, SecurityManager sm) {
        return (File[])filesStream.filter(file -> Win32ShellFolderManager2.checkFile(file, sm) != null).toArray(File[]::new);
    }

    @Override
    public boolean isComputerNode(final File dir) {
        if (dir != null && dir == Win32ShellFolderManager2.getDrives()) {
            return true;
        }
        String path = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return dir.getAbsolutePath();
            }
        });
        return path.startsWith("\\\\") && path.indexOf("\\", 2) < 0;
    }

    @Override
    public boolean isFileSystemRoot(File dir) {
        if (dir != null) {
            String path;
            Win32ShellFolder2 drives = Win32ShellFolderManager2.getDrives();
            if (dir instanceof Win32ShellFolder2) {
                Win32ShellFolder2 sf = (Win32ShellFolder2)dir;
                if (sf.isFileSystem()) {
                    if (sf.parent != null) {
                        return sf.parent.equals(drives);
                    }
                } else {
                    return false;
                }
            }
            if ((path = dir.getPath()).length() != 3 || path.charAt(1) != ':') {
                return false;
            }
            File[] files = drives.listFiles();
            return files != null && Arrays.asList(files).contains(dir);
        }
        return false;
    }

    static int compareShellFolders(Win32ShellFolder2 sf1, Win32ShellFolder2 sf2) {
        boolean special1 = sf1.isSpecial();
        boolean special2 = sf2.isSpecial();
        if (special1 || special2) {
            if (topFolderList == null) {
                ArrayList<Win32ShellFolder2> tmpTopFolderList = new ArrayList<Win32ShellFolder2>();
                tmpTopFolderList.add(Win32ShellFolderManager2.getPersonal());
                tmpTopFolderList.add(Win32ShellFolderManager2.getDesktop());
                tmpTopFolderList.add(Win32ShellFolderManager2.getDrives());
                tmpTopFolderList.add(Win32ShellFolderManager2.getNetwork());
                topFolderList = tmpTopFolderList;
            }
            int i1 = topFolderList.indexOf(sf1);
            int i2 = topFolderList.indexOf(sf2);
            if (i1 >= 0 && i2 >= 0) {
                return i1 - i2;
            }
            if (i1 >= 0) {
                return -1;
            }
            if (i2 >= 0) {
                return 1;
            }
        }
        if (special1 && !special2) {
            return -1;
        }
        if (special2 && !special1) {
            return 1;
        }
        return Win32ShellFolderManager2.compareNames(sf1.getAbsolutePath(), sf2.getAbsolutePath());
    }

    static int compareNames(String name1, String name2) {
        int diff = name1.compareToIgnoreCase(name2);
        if (diff != 0) {
            return diff;
        }
        return name1.compareTo(name2);
    }

    @Override
    protected ShellFolder.Invoker createInvoker() {
        return new ComInvoker();
    }

    static native void initializeCom();

    static native void uninitializeCom();

    static {
        WToolkit.loadLibraries();
        STANDARD_VIEW_BUTTONS = new Image[12];
        topFolderList = null;
    }

    private static class ComInvoker
    extends ThreadPoolExecutor
    implements ThreadFactory,
    ShellFolder.Invoker {
        private static Thread comThread;

        private ComInvoker() {
            super(1, 1, 0L, TimeUnit.DAYS, new LinkedBlockingQueue<Runnable>());
            this.allowCoreThreadTimeOut(false);
            this.setThreadFactory(this);
            final Runnable shutdownHook = new Runnable(){

                @Override
                public void run() {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            this.shutdownNow();
                            return null;
                        }
                    });
                }
            };
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Runtime.getRuntime().addShutdownHook(new Thread(shutdownHook));
                    return null;
                }
            });
        }

        @Override
        public synchronized Thread newThread(final Runnable task) {
            Runnable comRun = new Runnable(){

                @Override
                public void run() {
                    try {
                        Win32ShellFolderManager2.initializeCom();
                        task.run();
                    }
                    finally {
                        Win32ShellFolderManager2.uninitializeCom();
                    }
                }
            };
            comThread = AccessController.doPrivileged(() -> {
                ThreadGroup rootTG = ThreadGroupUtils.getRootThreadGroup();
                Thread thread = new Thread(rootTG, comRun, "Swing-Shell");
                thread.setDaemon(true);
                return thread;
            });
            return comThread;
        }

        @Override
        public <T> T invoke(Callable<T> task) throws Exception {
            Future<T> future;
            if (Thread.currentThread() == comThread) {
                return task.call();
            }
            try {
                future = this.submit(task);
            }
            catch (RejectedExecutionException e) {
                throw new InterruptedException(e.getMessage());
            }
            try {
                return future.get();
            }
            catch (InterruptedException e) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        future.cancel(true);
                        return null;
                    }
                });
                throw e;
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new RuntimeException("Unexpected error", cause);
            }
        }
    }
}

