/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.lang.ref.SoftReference;
import java.text.CollationKey;
import java.text.spi.CollatorProvider;
import java.util.Comparator;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.locale.provider.LocaleServiceProviderPool;

public abstract class Collator
implements Comparator<Object>,
Cloneable {
    public static final int PRIMARY = 0;
    public static final int SECONDARY = 1;
    public static final int TERTIARY = 2;
    public static final int IDENTICAL = 3;
    public static final int NO_DECOMPOSITION = 0;
    public static final int CANONICAL_DECOMPOSITION = 1;
    public static final int FULL_DECOMPOSITION = 2;
    private int strength = 2;
    private int decmp = 1;
    private static final ConcurrentMap<Locale, SoftReference<Collator>> cache = new ConcurrentHashMap<Locale, SoftReference<Collator>>();
    static final int LESS = -1;
    static final int EQUAL = 0;
    static final int GREATER = 1;

    public static synchronized Collator getInstance() {
        return Collator.getInstance(Locale.getDefault());
    }

    public static Collator getInstance(Locale desiredLocale) {
        Collator result;
        block3: {
            Collator cachedColl;
            SoftReference<Collator> ref = (SoftReference<Collator>)cache.get(desiredLocale);
            Collator collator = result = ref != null ? (Collator)ref.get() : null;
            if (result != null) break block3;
            LocaleProviderAdapter adapter = LocaleProviderAdapter.getAdapter(CollatorProvider.class, desiredLocale);
            CollatorProvider provider = adapter.getCollatorProvider();
            result = provider.getInstance(desiredLocale);
            if (result == null) {
                result = LocaleProviderAdapter.forJRE().getCollatorProvider().getInstance(desiredLocale);
            }
            do {
                if (ref != null) {
                    cache.remove(desiredLocale, ref);
                }
                if ((ref = cache.putIfAbsent(desiredLocale, new SoftReference<Collator>(result))) == null) break block3;
            } while ((cachedColl = ref.get()) == null);
            result = cachedColl;
        }
        return (Collator)result.clone();
    }

    @Override
    public abstract int compare(String var1, String var2);

    @Override
    public int compare(Object o1, Object o2) {
        return this.compare((String)o1, (String)o2);
    }

    public abstract CollationKey getCollationKey(String var1);

    public boolean equals(String source, String target) {
        return this.compare(source, target) == 0;
    }

    public synchronized int getStrength() {
        return this.strength;
    }

    public synchronized void setStrength(int newStrength) {
        if (newStrength != 0 && newStrength != 1 && newStrength != 2 && newStrength != 3) {
            throw new IllegalArgumentException("Incorrect comparison level.");
        }
        this.strength = newStrength;
    }

    public synchronized int getDecomposition() {
        return this.decmp;
    }

    public synchronized void setDecomposition(int decompositionMode) {
        if (decompositionMode != 0 && decompositionMode != 1 && decompositionMode != 2) {
            throw new IllegalArgumentException("Wrong decomposition mode.");
        }
        this.decmp = decompositionMode;
    }

    public static synchronized Locale[] getAvailableLocales() {
        LocaleServiceProviderPool pool = LocaleServiceProviderPool.getPool(CollatorProvider.class);
        return pool.getAvailableLocales();
    }

    public Object clone() {
        try {
            return (Collator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        Collator other = (Collator)that;
        return this.strength == other.strength && this.decmp == other.decmp;
    }

    public abstract int hashCode();

    protected Collator() {
    }
}

