/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.accessibility.util;

import com.sun.java.accessibility.util.EventQueueMonitor;
import com.sun.java.accessibility.util.TopLevelWindowListener;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jdk.Exported;
import sun.security.util.SecurityConstants;

@Exported
public class AWTEventMonitor {
    private static boolean runningOnJDK1_4 = false;
    @Deprecated
    protected static Component componentWithFocus = null;
    private static Component componentWithFocus_private = null;
    @Deprecated
    protected static ComponentListener componentListener = null;
    private static ComponentListener componentListener_private = null;
    @Deprecated
    protected static ContainerListener containerListener = null;
    private static ContainerListener containerListener_private = null;
    @Deprecated
    protected static FocusListener focusListener = null;
    private static FocusListener focusListener_private = null;
    @Deprecated
    protected static KeyListener keyListener = null;
    private static KeyListener keyListener_private = null;
    @Deprecated
    protected static MouseListener mouseListener = null;
    private static MouseListener mouseListener_private = null;
    @Deprecated
    protected static MouseMotionListener mouseMotionListener = null;
    private static MouseMotionListener mouseMotionListener_private = null;
    @Deprecated
    protected static WindowListener windowListener = null;
    private static WindowListener windowListener_private = null;
    @Deprecated
    protected static ActionListener actionListener = null;
    private static ActionListener actionListener_private = null;
    @Deprecated
    protected static AdjustmentListener adjustmentListener = null;
    private static AdjustmentListener adjustmentListener_private = null;
    @Deprecated
    protected static ItemListener itemListener = null;
    private static ItemListener itemListener_private = null;
    @Deprecated
    protected static TextListener textListener = null;
    private static TextListener textListener_private = null;
    @Deprecated
    protected static AWTEventsListener awtListener = new AWTEventsListener();
    private static final AWTEventsListener awtListener_private = new AWTEventsListener();

    public static Component getComponentWithFocus() {
        return componentWithFocus_private;
    }

    private static void checkInstallPermission() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(SecurityConstants.AWT.ALL_AWT_EVENTS_PERMISSION);
        }
    }

    public static void addComponentListener(ComponentListener l) {
        if (componentListener_private == null) {
            AWTEventMonitor.checkInstallPermission();
            awtListener_private.installListeners(2);
        }
        componentListener_private = AWTEventMulticaster.add(componentListener_private, l);
    }

    public static void removeComponentListener(ComponentListener l) {
        if ((componentListener_private = AWTEventMulticaster.remove(componentListener_private, l)) == null) {
            awtListener_private.removeListeners(2);
        }
    }

    public static void addContainerListener(ContainerListener l) {
        containerListener_private = AWTEventMulticaster.add(containerListener_private, l);
    }

    public static void removeContainerListener(ContainerListener l) {
        containerListener_private = AWTEventMulticaster.remove(containerListener_private, l);
    }

    public static void addFocusListener(FocusListener l) {
        focusListener_private = AWTEventMulticaster.add(focusListener_private, l);
    }

    public static void removeFocusListener(FocusListener l) {
        focusListener_private = AWTEventMulticaster.remove(focusListener_private, l);
    }

    public static void addKeyListener(KeyListener l) {
        if (keyListener_private == null) {
            AWTEventMonitor.checkInstallPermission();
            awtListener_private.installListeners(6);
        }
        keyListener_private = AWTEventMulticaster.add(keyListener_private, l);
    }

    public static void removeKeyListener(KeyListener l) {
        if ((keyListener_private = AWTEventMulticaster.remove(keyListener_private, l)) == null) {
            awtListener_private.removeListeners(6);
        }
    }

    public static void addMouseListener(MouseListener l) {
        if (mouseListener_private == null) {
            AWTEventMonitor.checkInstallPermission();
            awtListener_private.installListeners(7);
        }
        mouseListener_private = AWTEventMulticaster.add(mouseListener_private, l);
    }

    public static void removeMouseListener(MouseListener l) {
        if ((mouseListener_private = AWTEventMulticaster.remove(mouseListener_private, l)) == null) {
            awtListener_private.removeListeners(7);
        }
    }

    public static void addMouseMotionListener(MouseMotionListener l) {
        if (mouseMotionListener_private == null) {
            AWTEventMonitor.checkInstallPermission();
            awtListener_private.installListeners(8);
        }
        mouseMotionListener_private = AWTEventMulticaster.add(mouseMotionListener_private, l);
    }

    public static void removeMouseMotionListener(MouseMotionListener l) {
        if ((mouseMotionListener_private = AWTEventMulticaster.remove(mouseMotionListener_private, l)) == null) {
            awtListener_private.removeListeners(8);
        }
    }

    public static void addWindowListener(WindowListener l) {
        if (windowListener_private == null) {
            AWTEventMonitor.checkInstallPermission();
            awtListener_private.installListeners(11);
        }
        windowListener_private = AWTEventMulticaster.add(windowListener_private, l);
    }

    public static void removeWindowListener(WindowListener l) {
        if ((windowListener_private = AWTEventMulticaster.remove(windowListener_private, l)) == null) {
            awtListener_private.removeListeners(11);
        }
    }

    public static void addActionListener(ActionListener l) {
        if (actionListener_private == null) {
            AWTEventMonitor.checkInstallPermission();
            awtListener_private.installListeners(0);
        }
        actionListener_private = AWTEventMulticaster.add(actionListener_private, l);
    }

    public static void removeActionListener(ActionListener l) {
        if ((actionListener_private = AWTEventMulticaster.remove(actionListener_private, l)) == null) {
            awtListener_private.removeListeners(0);
        }
    }

    public static void addAdjustmentListener(AdjustmentListener l) {
        if (adjustmentListener_private == null) {
            AWTEventMonitor.checkInstallPermission();
            awtListener_private.installListeners(1);
        }
        adjustmentListener_private = AWTEventMulticaster.add(adjustmentListener_private, l);
    }

    public static void removeAdjustmentListener(AdjustmentListener l) {
        if ((adjustmentListener_private = AWTEventMulticaster.remove(adjustmentListener_private, l)) == null) {
            awtListener_private.removeListeners(1);
        }
    }

    public static void addItemListener(ItemListener l) {
        if (itemListener_private == null) {
            AWTEventMonitor.checkInstallPermission();
            awtListener_private.installListeners(5);
        }
        itemListener_private = AWTEventMulticaster.add(itemListener_private, l);
    }

    public static void removeItemListener(ItemListener l) {
        if ((itemListener_private = AWTEventMulticaster.remove(itemListener_private, l)) == null) {
            awtListener_private.removeListeners(5);
        }
    }

    public static void addTextListener(TextListener l) {
        if (textListener_private == null) {
            AWTEventMonitor.checkInstallPermission();
            awtListener_private.installListeners(10);
        }
        textListener_private = AWTEventMulticaster.add(textListener_private, l);
    }

    public static void removeTextListener(TextListener l) {
        if ((textListener_private = AWTEventMulticaster.remove(textListener_private, l)) == null) {
            awtListener_private.removeListeners(10);
        }
    }

    static class AWTEventsListener
    implements TopLevelWindowListener,
    ActionListener,
    AdjustmentListener,
    ComponentListener,
    ContainerListener,
    FocusListener,
    ItemListener,
    KeyListener,
    MouseListener,
    MouseMotionListener,
    TextListener,
    WindowListener,
    ChangeListener {
        private Class[] actionListeners;
        private Method removeActionMethod;
        private Method addActionMethod;
        private Object[] actionArgs;
        private Class[] itemListeners;
        private Method removeItemMethod;
        private Method addItemMethod;
        private Object[] itemArgs;
        private Class[] textListeners;
        private Method removeTextMethod;
        private Method addTextMethod;
        private Object[] textArgs;
        private Class[] windowListeners;
        private Method removeWindowMethod;
        private Method addWindowMethod;
        private Object[] windowArgs;

        public AWTEventsListener() {
            String version = System.getProperty("java.version");
            if (version != null) {
                runningOnJDK1_4 = version.compareTo("1.4") >= 0;
            }
            this.initializeIntrospection();
            this.installListeners();
            if (runningOnJDK1_4) {
                MenuSelectionManager.defaultManager().addChangeListener(this);
            }
            EventQueueMonitor.addTopLevelWindowListener(this);
        }

        private boolean initializeIntrospection() {
            try {
                this.actionListeners = new Class[1];
                this.actionArgs = new Object[1];
                this.actionListeners[0] = Class.forName("java.awt.event.ActionListener");
                this.actionArgs[0] = this;
                this.itemListeners = new Class[1];
                this.itemArgs = new Object[1];
                this.itemListeners[0] = Class.forName("java.awt.event.ItemListener");
                this.itemArgs[0] = this;
                this.textListeners = new Class[1];
                this.textArgs = new Object[1];
                this.textListeners[0] = Class.forName("java.awt.event.TextListener");
                this.textArgs[0] = this;
                this.windowListeners = new Class[1];
                this.windowArgs = new Object[1];
                this.windowListeners[0] = Class.forName("java.awt.event.WindowListener");
                this.windowArgs[0] = this;
                return true;
            }
            catch (ClassNotFoundException e) {
                System.out.println("EXCEPTION - Class 'java.awt.event.*' not in CLASSPATH");
                return false;
            }
        }

        protected void installListeners() {
            Window[] topLevelWindows = EventQueueMonitor.getTopLevelWindows();
            if (topLevelWindows != null) {
                for (int i = 0; i < topLevelWindows.length; ++i) {
                    this.installListeners(topLevelWindows[i]);
                }
            }
        }

        protected void installListeners(int eventID) {
            Window[] topLevelWindows = EventQueueMonitor.getTopLevelWindows();
            if (topLevelWindows != null) {
                for (int i = 0; i < topLevelWindows.length; ++i) {
                    this.installListeners(topLevelWindows[i], eventID);
                }
            }
        }

        protected void installListeners(Component c) {
            this.installListeners(c, 3);
            this.installListeners(c, 4);
            if (componentListener_private != null) {
                this.installListeners(c, 2);
            }
            if (keyListener_private != null) {
                this.installListeners(c, 6);
            }
            if (mouseListener_private != null) {
                this.installListeners(c, 7);
            }
            if (mouseMotionListener_private != null) {
                this.installListeners(c, 8);
            }
            if (windowListener_private != null) {
                this.installListeners(c, 11);
            }
            if (actionListener_private != null) {
                this.installListeners(c, 0);
            }
            if (adjustmentListener_private != null) {
                this.installListeners(c, 1);
            }
            if (itemListener_private != null) {
                this.installListeners(c, 5);
            }
            if (textListener_private != null) {
                this.installListeners(c, 10);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.processFocusGained();
        }

        private void processFocusGained() {
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (focusOwner == null) {
                return;
            }
            MenuSelectionManager.defaultManager().removeChangeListener(this);
            MenuSelectionManager.defaultManager().addChangeListener(this);
            if (focusOwner instanceof JRootPane) {
                MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
                if (path.length > 1) {
                    Component penult = path[path.length - 2].getComponent();
                    Component last = path[path.length - 1].getComponent();
                    if (last instanceof JPopupMenu || last instanceof JMenu) {
                        componentWithFocus_private = last;
                    } else if (penult instanceof JPopupMenu) {
                        componentWithFocus_private = penult;
                    }
                }
            } else {
                componentWithFocus_private = focusOwner;
            }
        }

        protected void installListeners(Component c, int eventID) {
            switch (eventID) {
                case 0: {
                    try {
                        this.removeActionMethod = c.getClass().getMethod("removeActionListener", this.actionListeners);
                        this.addActionMethod = c.getClass().getMethod("addActionListener", this.actionListeners);
                        try {
                            this.removeActionMethod.invoke((Object)c, this.actionArgs);
                            this.addActionMethod.invoke((Object)c, this.actionArgs);
                        }
                        catch (InvocationTargetException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                        catch (IllegalAccessException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                    }
                    catch (NoSuchMethodException e) {
                    }
                    catch (SecurityException e) {
                        System.out.println("Exception: " + e.toString());
                    }
                    break;
                }
                case 1: {
                    if (!(c instanceof Adjustable)) break;
                    ((Adjustable)((Object)c)).removeAdjustmentListener(this);
                    ((Adjustable)((Object)c)).addAdjustmentListener(this);
                    break;
                }
                case 2: {
                    c.removeComponentListener(this);
                    c.addComponentListener(this);
                    break;
                }
                case 3: {
                    if (!(c instanceof Container)) break;
                    ((Container)c).removeContainerListener(this);
                    ((Container)c).addContainerListener(this);
                    break;
                }
                case 4: {
                    c.removeFocusListener(this);
                    c.addFocusListener(this);
                    if (runningOnJDK1_4) {
                        this.processFocusGained();
                        break;
                    }
                    if (c == componentWithFocus_private || !c.hasFocus()) break;
                    componentWithFocus_private = c;
                    break;
                }
                case 5: {
                    try {
                        this.removeItemMethod = c.getClass().getMethod("removeItemListener", this.itemListeners);
                        this.addItemMethod = c.getClass().getMethod("addItemListener", this.itemListeners);
                        try {
                            this.removeItemMethod.invoke((Object)c, this.itemArgs);
                            this.addItemMethod.invoke((Object)c, this.itemArgs);
                        }
                        catch (InvocationTargetException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                        catch (IllegalAccessException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                    }
                    catch (NoSuchMethodException e) {
                    }
                    catch (SecurityException e) {
                        System.out.println("Exception: " + e.toString());
                    }
                    break;
                }
                case 6: {
                    c.removeKeyListener(this);
                    c.addKeyListener(this);
                    break;
                }
                case 7: {
                    c.removeMouseListener(this);
                    c.addMouseListener(this);
                    break;
                }
                case 8: {
                    c.removeMouseMotionListener(this);
                    c.addMouseMotionListener(this);
                    break;
                }
                case 10: {
                    try {
                        this.removeTextMethod = c.getClass().getMethod("removeTextListener", this.textListeners);
                        this.addTextMethod = c.getClass().getMethod("addTextListener", this.textListeners);
                        try {
                            this.removeTextMethod.invoke((Object)c, this.textArgs);
                            this.addTextMethod.invoke((Object)c, this.textArgs);
                        }
                        catch (InvocationTargetException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                        catch (IllegalAccessException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                    }
                    catch (NoSuchMethodException e) {
                    }
                    catch (SecurityException e) {
                        System.out.println("Exception: " + e.toString());
                    }
                    break;
                }
                case 11: {
                    try {
                        this.removeWindowMethod = c.getClass().getMethod("removeWindowListener", this.windowListeners);
                        this.addWindowMethod = c.getClass().getMethod("addWindowListener", this.windowListeners);
                        try {
                            this.removeWindowMethod.invoke((Object)c, this.windowArgs);
                            this.addWindowMethod.invoke((Object)c, this.windowArgs);
                        }
                        catch (InvocationTargetException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                        catch (IllegalAccessException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                    }
                    catch (NoSuchMethodException e) {
                    }
                    catch (SecurityException e) {
                        System.out.println("Exception: " + e.toString());
                    }
                    break;
                }
                default: {
                    return;
                }
            }
            if (c instanceof Container) {
                int count = ((Container)c).getComponentCount();
                for (int i = 0; i < count; ++i) {
                    this.installListeners(((Container)c).getComponent(i), eventID);
                }
            }
        }

        protected void removeListeners(int eventID) {
            Window[] topLevelWindows = EventQueueMonitor.getTopLevelWindows();
            if (topLevelWindows != null) {
                for (int i = 0; i < topLevelWindows.length; ++i) {
                    this.removeListeners(topLevelWindows[i], eventID);
                }
            }
        }

        protected void removeListeners(Component c) {
            if (componentListener_private != null) {
                this.removeListeners(c, 2);
            }
            if (keyListener_private != null) {
                this.removeListeners(c, 6);
            }
            if (mouseListener_private != null) {
                this.removeListeners(c, 7);
            }
            if (mouseMotionListener_private != null) {
                this.removeListeners(c, 8);
            }
            if (windowListener_private != null) {
                this.removeListeners(c, 11);
            }
            if (actionListener_private != null) {
                this.removeListeners(c, 0);
            }
            if (adjustmentListener_private != null) {
                this.removeListeners(c, 1);
            }
            if (itemListener_private != null) {
                this.removeListeners(c, 5);
            }
            if (textListener_private != null) {
                this.removeListeners(c, 10);
            }
        }

        protected void removeListeners(Component c, int eventID) {
            switch (eventID) {
                case 0: {
                    try {
                        this.removeActionMethod = c.getClass().getMethod("removeActionListener", this.actionListeners);
                        try {
                            this.removeActionMethod.invoke((Object)c, this.actionArgs);
                        }
                        catch (InvocationTargetException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                        catch (IllegalAccessException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                    }
                    catch (NoSuchMethodException e) {
                    }
                    catch (SecurityException e) {
                        System.out.println("Exception: " + e.toString());
                    }
                    break;
                }
                case 1: {
                    if (!(c instanceof Adjustable)) break;
                    ((Adjustable)((Object)c)).removeAdjustmentListener(this);
                    break;
                }
                case 2: {
                    c.removeComponentListener(this);
                    break;
                }
                case 5: {
                    try {
                        this.removeItemMethod = c.getClass().getMethod("removeItemListener", this.itemListeners);
                        try {
                            this.removeItemMethod.invoke((Object)c, this.itemArgs);
                        }
                        catch (InvocationTargetException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                        catch (IllegalAccessException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                    }
                    catch (NoSuchMethodException e) {
                    }
                    catch (SecurityException e) {
                        System.out.println("Exception: " + e.toString());
                    }
                    break;
                }
                case 6: {
                    c.removeKeyListener(this);
                    break;
                }
                case 7: {
                    c.removeMouseListener(this);
                    break;
                }
                case 8: {
                    c.removeMouseMotionListener(this);
                    break;
                }
                case 10: {
                    try {
                        this.removeTextMethod = c.getClass().getMethod("removeTextListener", this.textListeners);
                        try {
                            this.removeTextMethod.invoke((Object)c, this.textArgs);
                        }
                        catch (InvocationTargetException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                        catch (IllegalAccessException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                    }
                    catch (NoSuchMethodException e) {
                    }
                    catch (SecurityException e) {
                        System.out.println("Exception: " + e.toString());
                    }
                    break;
                }
                case 11: {
                    try {
                        this.removeWindowMethod = c.getClass().getMethod("removeWindowListener", this.windowListeners);
                        try {
                            this.removeWindowMethod.invoke((Object)c, this.windowArgs);
                        }
                        catch (InvocationTargetException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                        catch (IllegalAccessException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                    }
                    catch (NoSuchMethodException e) {
                    }
                    catch (SecurityException e) {
                        System.out.println("Exception: " + e.toString());
                    }
                    break;
                }
                default: {
                    return;
                }
            }
            if (c instanceof Container) {
                int count = ((Container)c).getComponentCount();
                for (int i = 0; i < count; ++i) {
                    this.removeListeners(((Container)c).getComponent(i), eventID);
                }
            }
        }

        @Override
        public void topLevelWindowCreated(Window w) {
            this.installListeners(w);
        }

        @Override
        public void topLevelWindowDestroyed(Window w) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (actionListener_private != null) {
                actionListener_private.actionPerformed(e);
            }
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (adjustmentListener_private != null) {
                adjustmentListener_private.adjustmentValueChanged(e);
            }
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            if (componentListener_private != null) {
                componentListener_private.componentHidden(e);
            }
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            if (componentListener_private != null) {
                componentListener_private.componentMoved(e);
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (componentListener_private != null) {
                componentListener_private.componentResized(e);
            }
        }

        @Override
        public void componentShown(ComponentEvent e) {
            if (componentListener_private != null) {
                componentListener_private.componentShown(e);
            }
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            this.installListeners(e.getChild());
            if (containerListener_private != null) {
                containerListener_private.componentAdded(e);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            this.removeListeners(e.getChild());
            if (containerListener_private != null) {
                containerListener_private.componentRemoved(e);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            componentWithFocus_private = (Component)e.getSource();
            if (focusListener_private != null) {
                focusListener_private.focusGained(e);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            componentWithFocus_private = null;
            if (focusListener_private != null) {
                focusListener_private.focusLost(e);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (itemListener_private != null) {
                itemListener_private.itemStateChanged(e);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (keyListener_private != null) {
                keyListener_private.keyPressed(e);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (keyListener_private != null) {
                keyListener_private.keyReleased(e);
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (keyListener_private != null) {
                keyListener_private.keyTyped(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (mouseListener_private != null) {
                mouseListener_private.mouseClicked(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (mouseListener_private != null) {
                mouseListener_private.mouseEntered(e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (mouseListener_private != null) {
                mouseListener_private.mouseExited(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (mouseListener_private != null) {
                mouseListener_private.mousePressed(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (mouseListener_private != null) {
                mouseListener_private.mouseReleased(e);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (mouseMotionListener_private != null) {
                mouseMotionListener_private.mouseDragged(e);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (mouseMotionListener_private != null) {
                mouseMotionListener_private.mouseMoved(e);
            }
        }

        @Override
        public void textValueChanged(TextEvent e) {
            if (textListener_private != null) {
                textListener_private.textValueChanged(e);
            }
        }

        @Override
        public void windowOpened(WindowEvent e) {
            if (windowListener_private != null) {
                windowListener_private.windowOpened(e);
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (windowListener_private != null) {
                windowListener_private.windowClosing(e);
            }
        }

        @Override
        public void windowClosed(WindowEvent e) {
            if (windowListener_private != null) {
                windowListener_private.windowClosed(e);
            }
        }

        @Override
        public void windowIconified(WindowEvent e) {
            if (windowListener_private != null) {
                windowListener_private.windowIconified(e);
            }
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
            if (windowListener_private != null) {
                windowListener_private.windowDeiconified(e);
            }
        }

        @Override
        public void windowActivated(WindowEvent e) {
            if (windowListener_private != null) {
                windowListener_private.windowActivated(e);
            }
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            if (windowListener_private != null) {
                windowListener_private.windowDeactivated(e);
            }
        }
    }
}

