/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.CipherBlockChaining;
import com.sun.crypto.provider.CipherFeedback;
import com.sun.crypto.provider.CipherTextStealing;
import com.sun.crypto.provider.ConstructKeys;
import com.sun.crypto.provider.CounterMode;
import com.sun.crypto.provider.ElectronicCodeBook;
import com.sun.crypto.provider.FeedbackCipher;
import com.sun.crypto.provider.GaloisCounterMode;
import com.sun.crypto.provider.ISO10126Padding;
import com.sun.crypto.provider.OutputFeedback;
import com.sun.crypto.provider.PCBC;
import com.sun.crypto.provider.PKCS5Padding;
import com.sun.crypto.provider.Padding;
import com.sun.crypto.provider.RC2Crypt;
import com.sun.crypto.provider.SunJCE;
import com.sun.crypto.provider.SymmetricCipher;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.util.Locale;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;

final class CipherCore {
    private byte[] buffer = null;
    private int blockSize = 0;
    private int unitBytes = 0;
    private int buffered = 0;
    private int minBytes = 0;
    private int diffBlocksize = 0;
    private Padding padding = null;
    private FeedbackCipher cipher = null;
    private int cipherMode = 0;
    private boolean decrypting = false;
    private static final int ECB_MODE = 0;
    private static final int CBC_MODE = 1;
    private static final int CFB_MODE = 2;
    private static final int OFB_MODE = 3;
    private static final int PCBC_MODE = 4;
    private static final int CTR_MODE = 5;
    private static final int CTS_MODE = 6;
    static final int GCM_MODE = 7;
    private boolean requireReinit = false;
    private byte[] lastEncKey = null;
    private byte[] lastEncIv = null;

    CipherCore(SymmetricCipher impl, int blkSize) {
        this.blockSize = blkSize;
        this.unitBytes = blkSize;
        this.diffBlocksize = blkSize;
        this.buffer = new byte[this.blockSize * 2];
        this.cipher = new ElectronicCodeBook(impl);
        this.padding = new PKCS5Padding(this.blockSize);
    }

    void setMode(String mode) throws NoSuchAlgorithmException {
        if (mode == null) {
            throw new NoSuchAlgorithmException("null mode");
        }
        String modeUpperCase = mode.toUpperCase(Locale.ENGLISH);
        if (modeUpperCase.equals("ECB")) {
            return;
        }
        SymmetricCipher rawImpl = this.cipher.getEmbeddedCipher();
        if (modeUpperCase.equals("CBC")) {
            this.cipherMode = 1;
            this.cipher = new CipherBlockChaining(rawImpl);
        } else if (modeUpperCase.equals("CTS")) {
            this.cipherMode = 6;
            this.cipher = new CipherTextStealing(rawImpl);
            this.minBytes = this.blockSize + 1;
            this.padding = null;
        } else if (modeUpperCase.equals("CTR")) {
            this.cipherMode = 5;
            this.cipher = new CounterMode(rawImpl);
            this.unitBytes = 1;
            this.padding = null;
        } else if (modeUpperCase.equals("GCM")) {
            if (this.blockSize != 16) {
                throw new NoSuchAlgorithmException("GCM mode can only be used for AES cipher");
            }
            this.cipherMode = 7;
            this.cipher = new GaloisCounterMode(rawImpl);
            this.padding = null;
        } else if (modeUpperCase.startsWith("CFB")) {
            this.cipherMode = 2;
            this.unitBytes = CipherCore.getNumOfUnit(mode, "CFB".length(), this.blockSize);
            this.cipher = new CipherFeedback(rawImpl, this.unitBytes);
        } else if (modeUpperCase.startsWith("OFB")) {
            this.cipherMode = 3;
            this.unitBytes = CipherCore.getNumOfUnit(mode, "OFB".length(), this.blockSize);
            this.cipher = new OutputFeedback(rawImpl, this.unitBytes);
        } else if (modeUpperCase.equals("PCBC")) {
            this.cipherMode = 4;
            this.cipher = new PCBC(rawImpl);
        } else {
            throw new NoSuchAlgorithmException("Cipher mode: " + mode + " not found");
        }
    }

    int getMode() {
        return this.cipherMode;
    }

    private static int getNumOfUnit(String mode, int offset, int blockSize) throws NoSuchAlgorithmException {
        int result = blockSize;
        if (mode.length() > offset) {
            int numInt;
            try {
                Integer num = Integer.valueOf(mode.substring(offset));
                numInt = num;
                result = numInt >> 3;
            }
            catch (NumberFormatException e) {
                throw new NoSuchAlgorithmException("Algorithm mode: " + mode + " not implemented");
            }
            if (numInt % 8 != 0 || result > blockSize) {
                throw new NoSuchAlgorithmException("Invalid algorithm mode: " + mode);
            }
        }
        return result;
    }

    void setPadding(String paddingScheme) throws NoSuchPaddingException {
        if (paddingScheme == null) {
            throw new NoSuchPaddingException("null padding");
        }
        if (paddingScheme.equalsIgnoreCase("NoPadding")) {
            this.padding = null;
        } else if (paddingScheme.equalsIgnoreCase("ISO10126Padding")) {
            this.padding = new ISO10126Padding(this.blockSize);
        } else if (!paddingScheme.equalsIgnoreCase("PKCS5Padding")) {
            throw new NoSuchPaddingException("Padding: " + paddingScheme + " not implemented");
        }
        if (this.padding != null && (this.cipherMode == 5 || this.cipherMode == 6 || this.cipherMode == 7)) {
            this.padding = null;
            String modeStr = null;
            switch (this.cipherMode) {
                case 5: {
                    modeStr = "CTR";
                    break;
                }
                case 7: {
                    modeStr = "GCM";
                    break;
                }
                case 6: {
                    modeStr = "CTS";
                    break;
                }
            }
            if (modeStr != null) {
                throw new NoSuchPaddingException(modeStr + " mode must be used with NoPadding");
            }
        }
    }

    int getOutputSize(int inputLen) {
        return this.getOutputSizeByOperation(inputLen, true);
    }

    private int getOutputSizeByOperation(int inputLen, boolean isDoFinal) {
        int totalLen = Math.addExact(this.buffered, this.cipher.getBufferedLength());
        totalLen = Math.addExact(totalLen, inputLen);
        switch (this.cipherMode) {
            case 7: {
                if (isDoFinal) {
                    int tagLen = ((GaloisCounterMode)this.cipher).getTagLen();
                    totalLen = !this.decrypting ? Math.addExact(totalLen, tagLen) : (totalLen -= tagLen);
                }
                if (totalLen >= 0) break;
                totalLen = 0;
                break;
            }
            default: {
                if (this.padding == null || this.decrypting) break;
                if (this.unitBytes != this.blockSize) {
                    if (totalLen < this.diffBlocksize) {
                        totalLen = this.diffBlocksize;
                        break;
                    }
                    int residue = (totalLen - this.diffBlocksize) % this.blockSize;
                    totalLen = Math.addExact(totalLen, this.blockSize - residue);
                    break;
                }
                totalLen = Math.addExact(totalLen, this.padding.padLength(totalLen));
            }
        }
        return totalLen;
    }

    byte[] getIV() {
        byte[] iv = this.cipher.getIV();
        return iv == null ? null : (byte[])iv.clone();
    }

    AlgorithmParameters getParameters(String algName) {
        AlgorithmParameterSpec spec;
        if (this.cipherMode == 0) {
            return null;
        }
        AlgorithmParameters params = null;
        byte[] iv = this.getIV();
        if (iv == null) {
            iv = this.cipherMode == 7 ? new byte[GaloisCounterMode.DEFAULT_IV_LEN] : new byte[this.blockSize];
            SunJCE.getRandom().nextBytes(iv);
        }
        if (this.cipherMode == 7) {
            algName = "GCM";
            spec = new GCMParameterSpec(((GaloisCounterMode)this.cipher).getTagLen() * 8, iv);
        } else if (algName.equals("RC2")) {
            RC2Crypt rawImpl = (RC2Crypt)this.cipher.getEmbeddedCipher();
            spec = new RC2ParameterSpec(rawImpl.getEffectiveKeyBits(), iv);
        } else {
            spec = new IvParameterSpec(iv);
        }
        try {
            params = AlgorithmParameters.getInstance(algName, SunJCE.getInstance());
            params.init(spec);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("Cannot find " + algName + " AlgorithmParameters implementation in SunJCE provider");
        }
        catch (InvalidParameterSpecException ipse) {
            throw new RuntimeException(spec.getClass() + " not supported");
        }
        return params;
    }

    void init(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.init(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException(e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void init(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.decrypting = opmode == 2 || opmode == 4;
        byte[] keyBytes = CipherCore.getKeyBytes(key);
        int tagLen = -1;
        byte[] ivBytes = null;
        if (params != null) {
            if (this.cipherMode == 7) {
                if (!(params instanceof GCMParameterSpec)) throw new InvalidAlgorithmParameterException("Unsupported parameter: " + params);
                tagLen = ((GCMParameterSpec)params).getTLen();
                if (tagLen < 96 || tagLen > 128 || (tagLen & 7) != 0) {
                    throw new InvalidAlgorithmParameterException("Unsupported TLen value; must be one of {128, 120, 112, 104, 96}");
                }
                tagLen >>= 3;
                ivBytes = ((GCMParameterSpec)params).getIV();
            } else if (params instanceof IvParameterSpec) {
                ivBytes = ((IvParameterSpec)params).getIV();
                if (ivBytes == null || ivBytes.length != this.blockSize) {
                    throw new InvalidAlgorithmParameterException("Wrong IV length: must be " + this.blockSize + " bytes long");
                }
            } else {
                if (!(params instanceof RC2ParameterSpec)) throw new InvalidAlgorithmParameterException("Unsupported parameter: " + params);
                ivBytes = ((RC2ParameterSpec)params).getIV();
                if (ivBytes != null && ivBytes.length != this.blockSize) {
                    throw new InvalidAlgorithmParameterException("Wrong IV length: must be " + this.blockSize + " bytes long");
                }
            }
        }
        if (this.cipherMode == 0) {
            if (ivBytes != null) {
                throw new InvalidAlgorithmParameterException("ECB mode cannot use IV");
            }
        } else if (ivBytes == null) {
            if (this.decrypting) {
                throw new InvalidAlgorithmParameterException("Parameters missing");
            }
            if (random == null) {
                random = SunJCE.getRandom();
            }
            ivBytes = this.cipherMode == 7 ? new byte[GaloisCounterMode.DEFAULT_IV_LEN] : new byte[this.blockSize];
            random.nextBytes(ivBytes);
        }
        this.buffered = 0;
        this.diffBlocksize = this.blockSize;
        String algorithm = key.getAlgorithm();
        if (this.cipherMode == 7) {
            if (tagLen == -1) {
                tagLen = GaloisCounterMode.DEFAULT_TAG_LEN;
            }
            if (this.decrypting) {
                this.minBytes = tagLen;
            } else {
                boolean bl = this.requireReinit = Arrays.equals(ivBytes, this.lastEncIv) && MessageDigest.isEqual(keyBytes, this.lastEncKey);
                if (this.requireReinit) {
                    throw new InvalidAlgorithmParameterException("Cannot reuse iv for GCM encryption");
                }
                this.lastEncIv = ivBytes;
                this.lastEncKey = keyBytes;
            }
            ((GaloisCounterMode)this.cipher).init(this.decrypting, algorithm, keyBytes, ivBytes, tagLen);
        } else {
            this.cipher.init(this.decrypting, algorithm, keyBytes, ivBytes);
        }
        this.requireReinit = false;
    }

    void init(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec spec = null;
        String paramType = null;
        if (params != null) {
            try {
                if (this.cipherMode == 7) {
                    paramType = "GCM";
                    spec = params.getParameterSpec(GCMParameterSpec.class);
                } else {
                    paramType = "IV";
                    spec = params.getParameterSpec(IvParameterSpec.class);
                }
            }
            catch (InvalidParameterSpecException ipse) {
                throw new InvalidAlgorithmParameterException("Wrong parameter type: " + paramType + " expected");
            }
        }
        this.init(opmode, key, spec, random);
    }

    static byte[] getKeyBytes(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("No key given");
        }
        if (!"RAW".equalsIgnoreCase(key.getFormat())) {
            throw new InvalidKeyException("Wrong format: RAW bytes needed");
        }
        byte[] keyBytes = key.getEncoded();
        if (keyBytes == null) {
            throw new InvalidKeyException("RAW key bytes missing");
        }
        return keyBytes;
    }

    byte[] update(byte[] input, int inputOffset, int inputLen) {
        this.checkReinit();
        byte[] output = null;
        try {
            output = new byte[this.getOutputSizeByOperation(inputLen, false)];
            int len = this.update(input, inputOffset, inputLen, output, 0);
            if (len == output.length) {
                return output;
            }
            byte[] copy = Arrays.copyOf(output, len);
            if (this.decrypting) {
                Arrays.fill(output, (byte)0);
            }
            return copy;
        }
        catch (ShortBufferException e) {
            throw new ProviderException("Unexpected exception", e);
        }
    }

    int update(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        this.checkReinit();
        int len = Math.addExact(this.buffered, inputLen);
        len -= this.minBytes;
        if (this.padding != null && this.decrypting) {
            len -= this.blockSize;
        }
        int n = len = len > 0 ? len - len % this.unitBytes : 0;
        if (output == null || output.length - outputOffset < len) {
            throw new ShortBufferException("Output buffer must be (at least) " + len + " bytes long");
        }
        int outLen = 0;
        if (len != 0) {
            if (input == output && outputOffset - inputOffset < inputLen && inputOffset - outputOffset < this.buffer.length) {
                input = Arrays.copyOfRange(input, inputOffset, Math.addExact(inputOffset, inputLen));
                inputOffset = 0;
            }
            if (len <= this.buffered) {
                outLen = this.decrypting ? this.cipher.decrypt(this.buffer, 0, len, output, outputOffset) : this.cipher.encrypt(this.buffer, 0, len, output, outputOffset);
                this.buffered -= len;
                if (this.buffered != 0) {
                    System.arraycopy(this.buffer, len, this.buffer, 0, this.buffered);
                }
            } else {
                int inputConsumed = len - this.buffered;
                if (this.buffered > 0) {
                    int bufferCapacity = this.buffer.length - this.buffered;
                    if (bufferCapacity != 0) {
                        int temp = Math.min(bufferCapacity, inputConsumed);
                        if (this.unitBytes != this.blockSize) {
                            temp -= Math.addExact(this.buffered, temp) % this.unitBytes;
                        }
                        System.arraycopy(input, inputOffset, this.buffer, this.buffered, temp);
                        inputOffset = Math.addExact(inputOffset, temp);
                        inputConsumed -= temp;
                        inputLen -= temp;
                        this.buffered = Math.addExact(this.buffered, temp);
                    }
                    if (this.decrypting) {
                        outLen = this.cipher.decrypt(this.buffer, 0, this.buffered, output, outputOffset);
                    } else {
                        outLen = this.cipher.encrypt(this.buffer, 0, this.buffered, output, outputOffset);
                        Arrays.fill(this.buffer, (byte)0);
                    }
                    outputOffset = Math.addExact(outputOffset, outLen);
                    this.buffered = 0;
                }
                if (inputConsumed > 0) {
                    outLen = this.decrypting ? (outLen += this.cipher.decrypt(input, inputOffset, inputConsumed, output, outputOffset)) : (outLen += this.cipher.encrypt(input, inputOffset, inputConsumed, output, outputOffset));
                    inputOffset += inputConsumed;
                    inputLen -= inputConsumed;
                }
            }
            if (this.unitBytes != this.blockSize) {
                this.diffBlocksize = len < this.diffBlocksize ? (this.diffBlocksize -= len) : this.blockSize - (len - this.diffBlocksize) % this.blockSize;
            }
        }
        if (inputLen > 0) {
            System.arraycopy(input, inputOffset, this.buffer, this.buffered, inputLen);
            this.buffered = Math.addExact(this.buffered, inputLen);
        }
        return outLen;
    }

    byte[] doFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        try {
            this.checkReinit();
            byte[] output = new byte[this.getOutputSizeByOperation(inputLen, true)];
            byte[] finalBuf = this.prepareInputBuffer(input, inputOffset, inputLen, output, 0);
            int finalOffset = finalBuf == input ? inputOffset : 0;
            int finalBufLen = finalBuf == input ? inputLen : finalBuf.length;
            int outLen = this.fillOutputBuffer(finalBuf, finalOffset, output, 0, finalBufLen, input);
            this.endDoFinal();
            if (outLen < output.length) {
                byte[] copy = Arrays.copyOf(output, outLen);
                if (this.decrypting) {
                    Arrays.fill(output, (byte)0);
                }
                return copy;
            }
            return output;
        }
        catch (ShortBufferException e) {
            throw new ProviderException("Unexpected exception", e);
        }
    }

    int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        int finalBufLen;
        this.checkReinit();
        int estOutSize = this.getOutputSizeByOperation(inputLen, true);
        int outputCapacity = this.checkOutputCapacity(output, outputOffset, estOutSize);
        int offset = this.decrypting ? 0 : outputOffset;
        byte[] finalBuf = this.prepareInputBuffer(input, inputOffset, inputLen, output, outputOffset);
        byte[] outWithPadding = null;
        int finalOffset = finalBuf == input ? inputOffset : 0;
        int n = finalBufLen = finalBuf == input ? inputLen : finalBuf.length;
        if (this.decrypting) {
            if (outputCapacity < estOutSize) {
                this.cipher.save();
            }
            outWithPadding = new byte[estOutSize];
        }
        byte[] outBuffer = this.decrypting ? outWithPadding : output;
        int outLen = this.fillOutputBuffer(finalBuf, finalOffset, outBuffer, offset, finalBufLen, input);
        if (this.decrypting) {
            if (outputCapacity < outLen) {
                this.cipher.restore();
                throw new ShortBufferException("Output buffer too short: " + outputCapacity + " bytes given, " + outLen + " bytes needed");
            }
            System.arraycopy(outWithPadding, 0, output, outputOffset, outLen);
            Arrays.fill(outWithPadding, (byte)0);
        }
        this.endDoFinal();
        return outLen;
    }

    private void endDoFinal() {
        this.buffered = 0;
        this.diffBlocksize = this.blockSize;
        if (this.cipherMode != 0) {
            this.cipher.reset();
        }
    }

    private int unpad(int outLen, byte[] outWithPadding) throws BadPaddingException {
        int padStart = this.padding.unpad(outWithPadding, 0, outLen);
        if (padStart < 0) {
            throw new BadPaddingException("Given final block not properly padded. Such issues can arise if a bad key is used during decryption.");
        }
        outLen = padStart;
        return outLen;
    }

    private byte[] prepareInputBuffer(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, ShortBufferException {
        int len = Math.addExact(this.buffered, inputLen);
        int totalLen = Math.addExact(len, this.cipher.getBufferedLength());
        int paddingLen = 0;
        if (this.unitBytes != this.blockSize) {
            paddingLen = totalLen < this.diffBlocksize ? this.diffBlocksize - totalLen : this.blockSize - (totalLen - this.diffBlocksize) % this.blockSize;
        } else if (this.padding != null) {
            paddingLen = this.padding.padLength(totalLen);
        }
        if (this.decrypting && this.padding != null && paddingLen > 0 && paddingLen != this.blockSize) {
            throw new IllegalBlockSizeException("Input length must be multiple of " + this.blockSize + " when decrypting with padded cipher");
        }
        if (this.buffered != 0 || !this.decrypting && this.padding != null || input == output && outputOffset - inputOffset < inputLen && inputOffset - outputOffset < this.buffer.length) {
            if (this.decrypting || this.padding == null) {
                paddingLen = 0;
            }
            byte[] finalBuf = new byte[Math.addExact(len, paddingLen)];
            if (this.buffered != 0) {
                System.arraycopy(this.buffer, 0, finalBuf, 0, this.buffered);
                if (!this.decrypting) {
                    Arrays.fill(this.buffer, (byte)0);
                }
            }
            if (inputLen != 0) {
                System.arraycopy(input, inputOffset, finalBuf, this.buffered, inputLen);
            }
            if (paddingLen != 0) {
                this.padding.padWithLen(finalBuf, Math.addExact(this.buffered, inputLen), paddingLen);
            }
            return finalBuf;
        }
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int fillOutputBuffer(byte[] finalBuf, int finalOffset, byte[] output, int outOfs, int finalBufLen, byte[] input) throws ShortBufferException, BadPaddingException, IllegalBlockSizeException {
        int n;
        block6: {
            try {
                int len = this.finalNoPadding(finalBuf, finalOffset, output, outOfs, finalBufLen);
                if (this.decrypting && this.padding != null) {
                    len = this.unpad(len, output);
                }
                n = len;
                if (this.decrypting) break block6;
                boolean bl = this.requireReinit = this.cipherMode == 7;
            }
            catch (Throwable throwable) {
                if (!this.decrypting) {
                    boolean bl = this.requireReinit = this.cipherMode == 7;
                    if (finalBuf != input) {
                        Arrays.fill(finalBuf, (byte)0);
                    }
                }
                throw throwable;
            }
            if (finalBuf != input) {
                Arrays.fill(finalBuf, (byte)0);
            }
        }
        return n;
    }

    private int checkOutputCapacity(byte[] output, int outputOffset, int estOutSize) throws ShortBufferException {
        int minOutSize;
        int outputCapacity = output.length - outputOffset;
        int n = minOutSize = this.decrypting ? estOutSize - this.blockSize : estOutSize;
        if (output == null || outputCapacity < minOutSize) {
            throw new ShortBufferException("Output buffer must be (at least) " + minOutSize + " bytes long");
        }
        return outputCapacity;
    }

    private void checkReinit() {
        if (this.requireReinit) {
            throw new IllegalStateException("Must use either different key or iv for GCM encryption");
        }
    }

    private int finalNoPadding(byte[] in, int inOfs, byte[] out, int outOfs, int len) throws IllegalBlockSizeException, AEADBadTagException, ShortBufferException {
        if (this.cipherMode != 7 && (in == null || len == 0)) {
            return 0;
        }
        if (this.cipherMode != 2 && this.cipherMode != 3 && this.cipherMode != 7 && len % this.unitBytes != 0 && this.cipherMode != 6) {
            if (this.padding != null) {
                throw new IllegalBlockSizeException("Input length (with padding) not multiple of " + this.unitBytes + " bytes");
            }
            throw new IllegalBlockSizeException("Input length not multiple of " + this.unitBytes + " bytes");
        }
        int outLen = 0;
        outLen = this.decrypting ? this.cipher.decryptFinal(in, inOfs, len, out, outOfs) : this.cipher.encryptFinal(in, inOfs, len, out, outOfs);
        return outLen;
    }

    byte[] wrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] result = null;
        try {
            byte[] encodedKey = key.getEncoded();
            if (encodedKey == null || encodedKey.length == 0) {
                throw new InvalidKeyException("Cannot get an encoding of the key to be wrapped");
            }
            result = this.doFinal(encodedKey, 0, encodedKey.length);
        }
        catch (BadPaddingException badPaddingException) {
            // empty catch block
        }
        return result;
    }

    Key unwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] encodedKey;
        try {
            encodedKey = this.doFinal(wrappedKey, 0, wrappedKey.length);
        }
        catch (BadPaddingException ePadding) {
            throw new InvalidKeyException("The wrapped key is not padded correctly");
        }
        catch (IllegalBlockSizeException eBlockSize) {
            throw new InvalidKeyException("The wrapped key does not have the correct length");
        }
        return ConstructKeys.constructKey(encodedKey, wrappedKeyAlgorithm, wrappedKeyType);
    }

    void updateAAD(byte[] src, int offset, int len) {
        this.checkReinit();
        this.cipher.updateAAD(src, offset, len);
    }
}

