/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.IllegalChannelGroupException;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import sun.nio.ch.Iocp;
import sun.nio.ch.ThreadPool;
import sun.nio.ch.WindowsAsynchronousServerSocketChannelImpl;
import sun.nio.ch.WindowsAsynchronousSocketChannelImpl;

public class WindowsAsynchronousChannelProvider
extends AsynchronousChannelProvider {
    private static volatile Iocp defaultIocp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Iocp defaultIocp() throws IOException {
        if (defaultIocp != null) return defaultIocp;
        Class<WindowsAsynchronousChannelProvider> clazz = WindowsAsynchronousChannelProvider.class;
        synchronized (WindowsAsynchronousChannelProvider.class) {
            if (defaultIocp != null) return defaultIocp;
            defaultIocp = new Iocp(this, ThreadPool.getDefault()).start();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return defaultIocp;
        }
    }

    @Override
    public AsynchronousChannelGroup openAsynchronousChannelGroup(int nThreads, ThreadFactory factory) throws IOException {
        return new Iocp(this, ThreadPool.create(nThreads, factory)).start();
    }

    @Override
    public AsynchronousChannelGroup openAsynchronousChannelGroup(ExecutorService executor, int initialSize) throws IOException {
        return new Iocp(this, ThreadPool.wrap(executor, initialSize)).start();
    }

    private Iocp toIocp(AsynchronousChannelGroup group) throws IOException {
        if (group == null) {
            return this.defaultIocp();
        }
        if (!(group instanceof Iocp)) {
            throw new IllegalChannelGroupException();
        }
        return (Iocp)group;
    }

    @Override
    public AsynchronousServerSocketChannel openAsynchronousServerSocketChannel(AsynchronousChannelGroup group) throws IOException {
        return new WindowsAsynchronousServerSocketChannelImpl(this.toIocp(group));
    }

    @Override
    public AsynchronousSocketChannel openAsynchronousSocketChannel(AsynchronousChannelGroup group) throws IOException {
        return new WindowsAsynchronousSocketChannelImpl(this.toIocp(group));
    }
}

