/*
 * Decompiled with CFR 0.152.
 */
package sun.net;

import java.io.FileDescriptor;
import java.net.SocketOption;
import java.security.AccessController;
import jdk.net.NetworkPermission;
import jdk.net.SocketFlow;

public class ExtendedOptionsImpl {
    private ExtendedOptionsImpl() {
    }

    public static void checkSetOptionPermission(SocketOption<?> option) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return;
        }
        String check = "setOption." + option.name();
        sm.checkPermission(new NetworkPermission(check));
    }

    public static void checkGetOptionPermission(SocketOption<?> option) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return;
        }
        String check = "getOption." + option.name();
        sm.checkPermission(new NetworkPermission(check));
    }

    public static void checkValueType(Object value, Class<?> type) {
        if (!type.isAssignableFrom(value.getClass())) {
            String s = "Found: " + value.getClass().toString() + " Expected: " + type.toString();
            throw new IllegalArgumentException(s);
        }
    }

    private static native void init();

    public static native void setFlowOption(FileDescriptor var0, SocketFlow var1);

    public static native void getFlowOption(FileDescriptor var0, SocketFlow var1);

    public static native boolean flowSupported();

    static {
        AccessController.doPrivileged(() -> {
            System.loadLibrary("net");
            return null;
        });
        ExtendedOptionsImpl.init();
    }
}

