/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.im.InputMethodRequests;
import java.awt.peer.TextFieldPeer;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WTextComponentPeer;

final class WTextFieldPeer
extends WTextComponentPeer
implements TextFieldPeer {
    @Override
    public Dimension getMinimumSize() {
        FontMetrics fm = this.getFontMetrics(((TextField)this.target).getFont());
        return new Dimension(fm.stringWidth(this.getText()) + 24, fm.getHeight() + 8);
    }

    @Override
    public boolean handleJavaKeyEvent(KeyEvent e) {
        switch (e.getID()) {
            case 400: {
                if (e.getKeyChar() != '\n' || e.isAltDown() || e.isControlDown()) break;
                this.postEvent(new ActionEvent(this.target, 1001, this.getText(), e.getWhen(), e.getModifiers()));
                return true;
            }
        }
        return false;
    }

    @Override
    public native void setEchoChar(char var1);

    @Override
    public Dimension getPreferredSize(int cols) {
        return this.getMinimumSize(cols);
    }

    @Override
    public Dimension getMinimumSize(int cols) {
        FontMetrics fm = this.getFontMetrics(((TextField)this.target).getFont());
        return new Dimension(fm.charWidth('0') * cols + 24, fm.getHeight() + 8);
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return null;
    }

    WTextFieldPeer(TextField target) {
        super(target);
    }

    @Override
    native void create(WComponentPeer var1);

    @Override
    void initialize() {
        TextField tf = (TextField)this.target;
        if (tf.echoCharIsSet()) {
            this.setEchoChar(tf.getEchoChar());
        }
        super.initialize();
    }
}

