/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.nio.ByteBuffer;
import java.util.zip.Checksum;
import sun.nio.ch.DirectBuffer;

public class CRC32
implements Checksum {
    private int crc;

    @Override
    public void update(int b) {
        this.crc = CRC32.update(this.crc, b);
    }

    @Override
    public void update(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.crc = CRC32.updateBytes(this.crc, b, off, len);
    }

    public void update(byte[] b) {
        this.crc = CRC32.updateBytes(this.crc, b, 0, b.length);
    }

    public void update(ByteBuffer buffer) {
        int pos = buffer.position();
        int limit = buffer.limit();
        assert (pos <= limit);
        int rem = limit - pos;
        if (rem <= 0) {
            return;
        }
        if (buffer instanceof DirectBuffer) {
            this.crc = CRC32.updateByteBuffer(this.crc, ((DirectBuffer)((Object)buffer)).address(), pos, rem);
        } else if (buffer.hasArray()) {
            this.crc = CRC32.updateBytes(this.crc, buffer.array(), pos + buffer.arrayOffset(), rem);
        } else {
            byte[] b = new byte[rem];
            buffer.get(b);
            this.crc = CRC32.updateBytes(this.crc, b, 0, b.length);
        }
        buffer.position(limit);
    }

    @Override
    public void reset() {
        this.crc = 0;
    }

    @Override
    public long getValue() {
        return (long)this.crc & 0xFFFFFFFFL;
    }

    private static native int update(int var0, int var1);

    private static native int updateBytes(int var0, byte[] var1, int var2, int var3);

    private static native int updateByteBuffer(int var0, long var1, int var3, int var4);
}

