/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import java.util.logging.XMLFormatter;

public class SocketHandler
extends StreamHandler {
    private Socket sock;
    private String host;
    private int port;

    private void configure() {
        LogManager manager = LogManager.getLogManager();
        String cname = this.getClass().getName();
        this.setLevel(manager.getLevelProperty(cname + ".level", Level.ALL));
        this.setFilter(manager.getFilterProperty(cname + ".filter", null));
        this.setFormatter(manager.getFormatterProperty(cname + ".formatter", new XMLFormatter()));
        try {
            this.setEncoding(manager.getStringProperty(cname + ".encoding", null));
        }
        catch (Exception ex) {
            try {
                this.setEncoding(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.port = manager.getIntProperty(cname + ".port", 0);
        this.host = manager.getStringProperty(cname + ".host", null);
    }

    public SocketHandler() throws IOException {
        this.sealed = false;
        this.configure();
        try {
            this.connect();
        }
        catch (IOException ix) {
            System.err.println("SocketHandler: connect failed to " + this.host + ":" + this.port);
            throw ix;
        }
        this.sealed = true;
    }

    public SocketHandler(String host, int port) throws IOException {
        this.sealed = false;
        this.configure();
        this.sealed = true;
        this.port = port;
        this.host = host;
        this.connect();
    }

    private void connect() throws IOException {
        if (this.port == 0) {
            throw new IllegalArgumentException("Bad port: " + this.port);
        }
        if (this.host == null) {
            throw new IllegalArgumentException("Null host name: " + this.host);
        }
        this.sock = new Socket(this.host, this.port);
        OutputStream out = this.sock.getOutputStream();
        BufferedOutputStream bout = new BufferedOutputStream(out);
        this.setOutputStream(bout);
    }

    @Override
    public synchronized void close() throws SecurityException {
        super.close();
        if (this.sock != null) {
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.sock = null;
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        super.publish(record);
        this.flush();
    }
}

