/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import sun.misc.SharedSecrets;

public class ArrayList<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8683452581122892189L;
    private static final int DEFAULT_CAPACITY = 10;
    private static final Object[] EMPTY_ELEMENTDATA = new Object[0];
    private static final Object[] DEFAULTCAPACITY_EMPTY_ELEMENTDATA = new Object[0];
    transient Object[] elementData;
    private int size;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public ArrayList(int initialCapacity) {
        if (initialCapacity > 0) {
            this.elementData = new Object[initialCapacity];
        } else if (initialCapacity == 0) {
            this.elementData = EMPTY_ELEMENTDATA;
        } else {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
    }

    public ArrayList() {
        this.elementData = DEFAULTCAPACITY_EMPTY_ELEMENTDATA;
    }

    public ArrayList(Collection<? extends E> c) {
        this.elementData = c.toArray();
        this.size = this.elementData.length;
        if (this.size != 0) {
            if (this.elementData.getClass() != Object[].class) {
                this.elementData = Arrays.copyOf(this.elementData, this.size, Object[].class);
            }
        } else {
            this.elementData = EMPTY_ELEMENTDATA;
        }
    }

    public void trimToSize() {
        ++this.modCount;
        if (this.size < this.elementData.length) {
            this.elementData = this.size == 0 ? EMPTY_ELEMENTDATA : Arrays.copyOf(this.elementData, this.size);
        }
    }

    public void ensureCapacity(int minCapacity) {
        int minExpand;
        int n = minExpand = this.elementData != DEFAULTCAPACITY_EMPTY_ELEMENTDATA ? 0 : 10;
        if (minCapacity > minExpand) {
            this.ensureExplicitCapacity(minCapacity);
        }
    }

    private static int calculateCapacity(Object[] elementData, int minCapacity) {
        if (elementData == DEFAULTCAPACITY_EMPTY_ELEMENTDATA) {
            return Math.max(10, minCapacity);
        }
        return minCapacity;
    }

    private void ensureCapacityInternal(int minCapacity) {
        this.ensureExplicitCapacity(ArrayList.calculateCapacity(this.elementData, minCapacity));
    }

    private void ensureExplicitCapacity(int minCapacity) {
        ++this.modCount;
        if (minCapacity - this.elementData.length > 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.elementData.length;
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = ArrayList.hugeCapacity(minCapacity);
        }
        this.elementData = Arrays.copyOf(this.elementData, newCapacity);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!o.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!o.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            ArrayList v = (ArrayList)super.clone();
            v.elementData = Arrays.copyOf(this.elementData, this.size);
            v.modCount = 0;
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.elementData, this.size);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            return Arrays.copyOf(this.elementData, this.size, a.getClass());
        }
        System.arraycopy(this.elementData, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    E elementData(int index) {
        return (E)this.elementData[index];
    }

    @Override
    public E get(int index) {
        this.rangeCheck(index);
        return this.elementData(index);
    }

    @Override
    public E set(int index, E element) {
        this.rangeCheck(index);
        E oldValue = this.elementData(index);
        this.elementData[index] = element;
        return oldValue;
    }

    @Override
    public boolean add(E e) {
        this.ensureCapacityInternal(this.size + 1);
        this.elementData[this.size++] = e;
        return true;
    }

    @Override
    public void add(int index, E element) {
        this.rangeCheckForAdd(index);
        this.ensureCapacityInternal(this.size + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.size - index);
        this.elementData[index] = element;
        ++this.size;
    }

    @Override
    public E remove(int index) {
        this.rangeCheck(index);
        ++this.modCount;
        E oldValue = this.elementData(index);
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.size] = null;
        return oldValue;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            for (int index = 0; index < this.size; ++index) {
                if (this.elementData[index] != null) continue;
                this.fastRemove(index);
                return true;
            }
        } else {
            for (int index = 0; index < this.size; ++index) {
                if (!o.equals(this.elementData[index])) continue;
                this.fastRemove(index);
                return true;
            }
        }
        return false;
    }

    private void fastRemove(int index) {
        ++this.modCount;
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.size] = null;
    }

    @Override
    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Object[] a = c.toArray();
        int numNew = a.length;
        this.ensureCapacityInternal(this.size + numNew);
        System.arraycopy(a, 0, this.elementData, this.size, numNew);
        this.size += numNew;
        return numNew != 0;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.rangeCheckForAdd(index);
        Object[] a = c.toArray();
        int numNew = a.length;
        this.ensureCapacityInternal(this.size + numNew);
        int numMoved = this.size - index;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index, this.elementData, index + numNew, numMoved);
        }
        System.arraycopy(a, 0, this.elementData, index, numNew);
        this.size += numNew;
        return numNew != 0;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        int newSize;
        ++this.modCount;
        int numMoved = this.size - toIndex;
        System.arraycopy(this.elementData, toIndex, this.elementData, fromIndex, numMoved);
        for (int i = newSize = this.size - (toIndex - fromIndex); i < this.size; ++i) {
            this.elementData[i] = null;
        }
        this.size = newSize;
    }

    private void rangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private void rangeCheckForAdd(int index) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.size;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return this.batchRemove(c, false);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return this.batchRemove(c, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean batchRemove(Collection<?> c, boolean complement) {
        boolean modified;
        int w;
        block8: {
            int r;
            Object[] elementData = this.elementData;
            w = 0;
            modified = false;
            try {
                for (r = 0; r < this.size; ++r) {
                    if (c.contains(elementData[r]) != complement) continue;
                    elementData[w++] = elementData[r];
                }
                if (r == this.size) break block8;
            }
            catch (Throwable throwable) {
                if (r != this.size) {
                    System.arraycopy(elementData, r, elementData, w, this.size - r);
                    w += this.size - r;
                }
                if (w != this.size) {
                    for (int i = w; i < this.size; ++i) {
                        elementData[i] = null;
                    }
                    this.modCount += this.size - w;
                    this.size = w;
                    modified = true;
                }
                throw throwable;
            }
            System.arraycopy(elementData, r, elementData, w, this.size - r);
            w += this.size - r;
        }
        if (w != this.size) {
            for (int i = w; i < this.size; ++i) {
                elementData[i] = null;
            }
            this.modCount += this.size - w;
            this.size = w;
            modified = true;
        }
        return modified;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int expectedModCount = this.modCount;
        s.defaultWriteObject();
        s.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            s.writeObject(this.elementData[i]);
        }
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.elementData = EMPTY_ELEMENTDATA;
        s.defaultReadObject();
        s.readInt();
        if (this.size > 0) {
            int capacity = ArrayList.calculateCapacity(this.elementData, this.size);
            SharedSecrets.getJavaOISAccess().checkArray(s, Object[].class, capacity);
            this.ensureCapacityInternal(this.size);
            Object[] a = this.elementData;
            for (int i = 0; i < this.size; ++i) {
                a[i] = s.readObject();
            }
        }
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListItr(index);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListItr(0);
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        ArrayList.subListRangeCheck(fromIndex, toIndex, this.size);
        return new SubList(this, 0, fromIndex, toIndex);
    }

    static void subListRangeCheck(int fromIndex, int toIndex, int size) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > size) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        int expectedModCount = this.modCount;
        Object[] elementData = this.elementData;
        int size = this.size;
        for (int i = 0; this.modCount == expectedModCount && i < size; ++i) {
            action.accept(elementData[i]);
        }
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Spliterator<E> spliterator() {
        return new ArrayListSpliterator(this, 0, -1, 0);
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        boolean anyToRemove;
        Objects.requireNonNull(filter);
        int removeCount = 0;
        BitSet removeSet = new BitSet(this.size);
        int expectedModCount = this.modCount;
        int size = this.size;
        for (int i = 0; this.modCount == expectedModCount && i < size; ++i) {
            Object element = this.elementData[i];
            if (!filter.test(element)) continue;
            removeSet.set(i);
            ++removeCount;
        }
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
        boolean bl = anyToRemove = removeCount > 0;
        if (anyToRemove) {
            int newSize = size - removeCount;
            int i = 0;
            for (int j = 0; i < size && j < newSize; ++i, ++j) {
                i = removeSet.nextClearBit(i);
                this.elementData[j] = this.elementData[i];
            }
            for (int k = newSize; k < size; ++k) {
                this.elementData[k] = null;
            }
            this.size = newSize;
            if (this.modCount != expectedModCount) {
                throw new ConcurrentModificationException();
            }
            ++this.modCount;
        }
        return anyToRemove;
    }

    @Override
    public void replaceAll(UnaryOperator<E> operator) {
        Objects.requireNonNull(operator);
        int expectedModCount = this.modCount;
        int size = this.size;
        for (int i = 0; this.modCount == expectedModCount && i < size; ++i) {
            this.elementData[i] = operator.apply(this.elementData[i]);
        }
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
        ++this.modCount;
    }

    @Override
    public void sort(Comparator<? super E> c) {
        int expectedModCount = this.modCount;
        Arrays.sort(this.elementData, 0, this.size, c);
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
        ++this.modCount;
    }

    static final class ArrayListSpliterator<E>
    implements Spliterator<E> {
        private final ArrayList<E> list;
        private int index;
        private int fence;
        private int expectedModCount;

        ArrayListSpliterator(ArrayList<E> list, int origin, int fence, int expectedModCount) {
            this.list = list;
            this.index = origin;
            this.fence = fence;
            this.expectedModCount = expectedModCount;
        }

        private int getFence() {
            int hi = this.fence;
            if (hi < 0) {
                ArrayList<E> lst = this.list;
                if (lst == null) {
                    this.fence = 0;
                    hi = 0;
                } else {
                    this.expectedModCount = lst.modCount;
                    hi = this.fence = ((ArrayList)lst).size;
                }
            }
            return hi;
        }

        @Override
        public ArrayListSpliterator<E> trySplit() {
            ArrayListSpliterator<E> arrayListSpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid) {
                arrayListSpliterator = null;
            } else {
                this.index = mid;
                ArrayListSpliterator<E> arrayListSpliterator2 = new ArrayListSpliterator<E>(this.list, lo, this.index, this.expectedModCount);
                arrayListSpliterator = arrayListSpliterator2;
            }
            return arrayListSpliterator;
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int i = this.index;
            int hi = this.getFence();
            if (i < hi) {
                this.index = i + 1;
                Object e = this.list.elementData[i];
                action.accept(e);
                if (this.list.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            ArrayList<E> lst = this.list;
            if (lst != null) {
                Object[] a = lst.elementData;
                if (lst.elementData != null) {
                    int i;
                    int mc;
                    int hi = this.fence;
                    if (hi < 0) {
                        mc = lst.modCount;
                        hi = ((ArrayList)lst).size;
                    } else {
                        mc = this.expectedModCount;
                    }
                    if (i >= 0 && (this.index = hi) <= a.length) {
                        for (i = this.index; i < hi; ++i) {
                            Object e = a[i];
                            action.accept(e);
                        }
                        if (lst.modCount == mc) {
                            return;
                        }
                    }
                }
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public long estimateSize() {
            return this.getFence() - this.index;
        }

        @Override
        public int characteristics() {
            return 16464;
        }
    }

    private class SubList
    extends AbstractList<E>
    implements RandomAccess {
        private final AbstractList<E> parent;
        private final int parentOffset;
        private final int offset;
        int size;

        SubList(AbstractList<E> parent, int offset, int fromIndex, int toIndex) {
            this.parent = parent;
            this.parentOffset = fromIndex;
            this.offset = offset + fromIndex;
            this.size = toIndex - fromIndex;
            this.modCount = ArrayList.this.modCount;
        }

        @Override
        public E set(int index, E e) {
            this.rangeCheck(index);
            this.checkForComodification();
            Object oldValue = ArrayList.this.elementData(this.offset + index);
            ArrayList.this.elementData[this.offset + index] = e;
            return oldValue;
        }

        @Override
        public E get(int index) {
            this.rangeCheck(index);
            this.checkForComodification();
            return ArrayList.this.elementData(this.offset + index);
        }

        @Override
        public int size() {
            this.checkForComodification();
            return this.size;
        }

        @Override
        public void add(int index, E e) {
            this.rangeCheckForAdd(index);
            this.checkForComodification();
            this.parent.add(this.parentOffset + index, e);
            this.modCount = this.parent.modCount;
            ++this.size;
        }

        @Override
        public E remove(int index) {
            this.rangeCheck(index);
            this.checkForComodification();
            Object result = this.parent.remove(this.parentOffset + index);
            this.modCount = this.parent.modCount;
            --this.size;
            return result;
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            this.checkForComodification();
            this.parent.removeRange(this.parentOffset + fromIndex, this.parentOffset + toIndex);
            this.modCount = this.parent.modCount;
            this.size -= toIndex - fromIndex;
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            return this.addAll(this.size, c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            this.rangeCheckForAdd(index);
            int cSize = c.size();
            if (cSize == 0) {
                return false;
            }
            this.checkForComodification();
            this.parent.addAll(this.parentOffset + index, c);
            this.modCount = this.parent.modCount;
            this.size += cSize;
            return true;
        }

        @Override
        public Iterator<E> iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(final int index) {
            this.checkForComodification();
            this.rangeCheckForAdd(index);
            final int offset = this.offset;
            return new ListIterator<E>(){
                int cursor;
                int lastRet;
                int expectedModCount;
                {
                    this.cursor = index;
                    this.lastRet = -1;
                    this.expectedModCount = ArrayList.this.modCount;
                }

                @Override
                public boolean hasNext() {
                    return this.cursor != SubList.this.size;
                }

                @Override
                public E next() {
                    this.checkForComodification();
                    int i = this.cursor;
                    if (i >= SubList.this.size) {
                        throw new NoSuchElementException();
                    }
                    Object[] elementData = ArrayList.this.elementData;
                    if (offset + i >= elementData.length) {
                        throw new ConcurrentModificationException();
                    }
                    this.cursor = i + 1;
                    this.lastRet = i;
                    return elementData[offset + this.lastRet];
                }

                @Override
                public boolean hasPrevious() {
                    return this.cursor != 0;
                }

                @Override
                public E previous() {
                    this.checkForComodification();
                    int i = this.cursor - 1;
                    if (i < 0) {
                        throw new NoSuchElementException();
                    }
                    Object[] elementData = ArrayList.this.elementData;
                    if (offset + i >= elementData.length) {
                        throw new ConcurrentModificationException();
                    }
                    this.cursor = i;
                    this.lastRet = i;
                    return elementData[offset + this.lastRet];
                }

                @Override
                public void forEachRemaining(Consumer<? super E> consumer) {
                    Objects.requireNonNull(consumer);
                    int size = SubList.this.size;
                    int i = this.cursor;
                    if (i >= size) {
                        return;
                    }
                    Object[] elementData = ArrayList.this.elementData;
                    if (offset + i >= elementData.length) {
                        throw new ConcurrentModificationException();
                    }
                    while (i != size && SubList.this.modCount == this.expectedModCount) {
                        consumer.accept(elementData[offset + i++]);
                    }
                    this.lastRet = this.cursor = i;
                    this.checkForComodification();
                }

                @Override
                public int nextIndex() {
                    return this.cursor;
                }

                @Override
                public int previousIndex() {
                    return this.cursor - 1;
                }

                @Override
                public void remove() {
                    if (this.lastRet < 0) {
                        throw new IllegalStateException();
                    }
                    this.checkForComodification();
                    try {
                        SubList.this.remove(this.lastRet);
                        this.cursor = this.lastRet;
                        this.lastRet = -1;
                        this.expectedModCount = ArrayList.this.modCount;
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new ConcurrentModificationException();
                    }
                }

                @Override
                public void set(E e) {
                    if (this.lastRet < 0) {
                        throw new IllegalStateException();
                    }
                    this.checkForComodification();
                    try {
                        ArrayList.this.set(offset + this.lastRet, e);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new ConcurrentModificationException();
                    }
                }

                @Override
                public void add(E e) {
                    this.checkForComodification();
                    try {
                        int i = this.cursor;
                        SubList.this.add(i, e);
                        this.cursor = i + 1;
                        this.lastRet = -1;
                        this.expectedModCount = ArrayList.this.modCount;
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new ConcurrentModificationException();
                    }
                }

                final void checkForComodification() {
                    if (this.expectedModCount != ArrayList.this.modCount) {
                        throw new ConcurrentModificationException();
                    }
                }
            };
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            ArrayList.subListRangeCheck(fromIndex, toIndex, this.size);
            return new SubList(this, this.offset, fromIndex, toIndex);
        }

        private void rangeCheck(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
            }
        }

        private void rangeCheckForAdd(int index) {
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
            }
        }

        private String outOfBoundsMsg(int index) {
            return "Index: " + index + ", Size: " + this.size;
        }

        private void checkForComodification() {
            if (ArrayList.this.modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public Spliterator<E> spliterator() {
            this.checkForComodification();
            return new ArrayListSpliterator(ArrayList.this, this.offset, this.offset + this.size, this.modCount);
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            int i = this.cursor - 1;
            if (i < 0) {
                throw new NoSuchElementException();
            }
            Object[] elementData = ArrayList.this.elementData;
            if (i >= elementData.length) {
                throw new ConcurrentModificationException();
            }
            this.cursor = i;
            this.lastRet = i;
            return elementData[this.lastRet];
        }

        @Override
        public void set(E e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ArrayList.this.set(this.lastRet, e);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            try {
                int i = this.cursor;
                ArrayList.this.add(i, e);
                this.cursor = i + 1;
                this.lastRet = -1;
                this.expectedModCount = ArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator<E> {
        int cursor;
        int lastRet = -1;
        int expectedModCount;

        Itr() {
            this.expectedModCount = ArrayList.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ArrayList.this.size;
        }

        @Override
        public E next() {
            this.checkForComodification();
            int i = this.cursor;
            if (i >= ArrayList.this.size) {
                throw new NoSuchElementException();
            }
            Object[] elementData = ArrayList.this.elementData;
            if (i >= elementData.length) {
                throw new ConcurrentModificationException();
            }
            this.cursor = i + 1;
            this.lastRet = i;
            return elementData[this.lastRet];
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ArrayList.this.remove(this.lastRet);
                this.cursor = this.lastRet;
                this.lastRet = -1;
                this.expectedModCount = ArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super E> consumer) {
            Objects.requireNonNull(consumer);
            int size = ArrayList.this.size;
            int i = this.cursor;
            if (i >= size) {
                return;
            }
            Object[] elementData = ArrayList.this.elementData;
            if (i >= elementData.length) {
                throw new ConcurrentModificationException();
            }
            while (i != size && ArrayList.this.modCount == this.expectedModCount) {
                consumer.accept(elementData[i++]);
            }
            this.cursor = i;
            this.lastRet = i - 1;
            this.checkForComodification();
        }

        final void checkForComodification() {
            if (ArrayList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

