/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth;

import java.io.Serializable;
import java.security.Principal;
import java.text.MessageFormat;
import jdk.Exported;
import sun.security.util.ResourcesMgr;

@Exported
public class UnixNumericGroupPrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = 3941535899328403223L;
    private String name;
    private boolean primaryGroup;

    public UnixNumericGroupPrincipal(String name, boolean primaryGroup) {
        if (name == null) {
            MessageFormat form = new MessageFormat(ResourcesMgr.getString("invalid.null.input.value", "sun.security.util.AuthResources"));
            Object[] source = new Object[]{"name"};
            throw new NullPointerException(form.format(source));
        }
        this.name = name;
        this.primaryGroup = primaryGroup;
    }

    public UnixNumericGroupPrincipal(long name, boolean primaryGroup) {
        this.name = new Long(name).toString();
        this.primaryGroup = primaryGroup;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public long longValue() {
        return new Long(this.name);
    }

    public boolean isPrimaryGroup() {
        return this.primaryGroup;
    }

    @Override
    public String toString() {
        if (this.primaryGroup) {
            MessageFormat form = new MessageFormat(ResourcesMgr.getString("UnixNumericGroupPrincipal.Primary.Group.name", "sun.security.util.AuthResources"));
            Object[] source = new Object[]{this.name};
            return form.format(source);
        }
        MessageFormat form = new MessageFormat(ResourcesMgr.getString("UnixNumericGroupPrincipal.Supplementary.Group.name", "sun.security.util.AuthResources"));
        Object[] source = new Object[]{this.name};
        return form.format(source);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnixNumericGroupPrincipal)) {
            return false;
        }
        UnixNumericGroupPrincipal that = (UnixNumericGroupPrincipal)o;
        return this.getName().equals(that.getName()) && this.isPrimaryGroup() == that.isPrimaryGroup();
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }
}

