/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tingeltangel.core.Translator;
import tingeltangel.gui.EditorFrame;

public class TranslatorFrame
extends JInternalFrame
implements ActionListener {
    private JTextField tingID = new JTextField();
    private JTextField codeID = new JTextField();
    private JButton code2ting = new JButton("Ting ID berechnen");
    private JButton ting2code = new JButton("Code ID berechnen");
    private final EditorFrame frame;

    public TranslatorFrame(EditorFrame frame) {
        super("", true, true, true, true);
        this.frame = frame;
        this.setTitle("ID Rechner");
        this.setVisible(false);
        this.setBounds(325, 15, 300, 300);
        this.setDefaultCloseOperation(1);
        JPanel gridPanel = new JPanel();
        gridPanel.setLayout(new GridLayout(2, 2));
        gridPanel.add(new JLabel("Ting ID"));
        gridPanel.add(this.tingID);
        gridPanel.add(new JLabel("Code ID"));
        gridPanel.add(this.codeID);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        bottomPanel.add((Component)this.ting2code, "West");
        bottomPanel.add((Component)this.code2ting, "East");
        this.ting2code.setActionCommand("ting2code");
        this.ting2code.addActionListener(this);
        this.code2ting.setActionCommand("code2ting");
        this.code2ting.addActionListener(this);
        JPanel main = new JPanel();
        main.setLayout(new BorderLayout());
        main.add((Component)gridPanel, "Center");
        main.add((Component)bottomPanel, "South");
        this.setContentPane(main);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("ting2code")) {
            try {
                int ting = Integer.parseInt(this.tingID.getText().trim());
                if (ting < 0 || ting >= 65536) {
                    throw new NumberFormatException();
                }
                int code = Translator.ting2code(ting);
                this.codeID.setText(Integer.toString(code));
                if (code < 0) {
                    JOptionPane.showMessageDialog(this.frame, "Die Code-ID zur Ting-ID " + ting + " ist unbekannt", "Warnung", 2);
                }
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this.frame, "Keine g\u00fcltige Ting-ID angegeben", "Fehler", 2);
            }
        } else if (action.equals("code2ting")) {
            try {
                int code = Integer.parseInt(this.codeID.getText().trim());
                if (code < 0 || code >= 65536) {
                    throw new NumberFormatException();
                }
                int ting = Translator.code2ting(code);
                this.tingID.setText(Integer.toString(ting));
                if (ting < 0) {
                    JOptionPane.showMessageDialog(this.frame, "Die Ting-ID zur Code-ID " + code + " ist unbekannt", "Warnung", 2);
                }
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this.frame, "Keine g\u00fcltige Code-ID angegeben", "Fehler", 2);
            }
        }
    }
}

