/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import tingeltangel.core.Repository;
import tingeltangel.gui.EditorFrame;
import tingeltangel.tools.Progress;
import tingeltangel.tools.ProgressDialog;

public class RepositoryManager
extends JInternalFrame {
    private final MyListModel model = new MyListModel();
    private final EditorFrame masterFrame;
    private final JScrollPane jScrollPane1 = new JScrollPane();
    private final JMenuBar jMenuBar1 = new JMenuBar();
    private final JMenu jMenu1 = new JMenu();
    private final JMenuItem update = new JMenuItem();
    private final JMenuItem search = new JMenuItem();
    private final JList list = new JList();
    private static final Logger log = LogManager.getLogger(RepositoryManager.class);

    public RepositoryManager(EditorFrame frame) {
        super("", true, true, true, true);
        this.list.setModel(this.model);
        this.jMenu1.add(this.update);
        this.jMenu1.add(this.search);
        this.jMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar1);
        this.jScrollPane1.setViewportView(this.list);
        this.setContentPane(this.jScrollPane1);
        this.jMenu1.setText("Aktionen");
        this.update.setText("aktualisieren");
        this.search.setText("neue B\u00fccher suchen");
        this.update.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepositoryManager.this.updateActionPerformed(evt);
            }
        });
        this.search.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepositoryManager.this.searchActionPerformed(evt);
            }
        });
        this.masterFrame = frame;
        this.list.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Map txt = (Map)value;
                JLabel label = new JLabel((String)txt.get("ID") + ": " + (String)txt.get("Name") + " (" + (String)txt.get("Author") + ")");
                if (Repository.exists(Integer.parseInt((String)txt.get("ID")))) {
                    label.setBackground(Color.green);
                    label.setOpaque(true);
                }
                return label;
            }
        });
        final JList _list = this.list;
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(final MouseEvent evt) {
                JList list = (JList)evt.getSource();
                if (evt.getClickCount() == 2) {
                    new Progress(RepositoryManager.this.masterFrame, "Suche nach Aktualisierungen"){

                        @Override
                        public void action(ProgressDialog progressDialog) {
                            try {
                                int index = _list.locationToIndex(evt.getPoint());
                                Map txt = (Map)RepositoryManager.this.model.getElementAt(index);
                                int id = Integer.parseInt((String)txt.get("ID"));
                                if (Repository.exists(id)) {
                                    Repository.update(id, progressDialog);
                                } else {
                                    Repository.download(id, progressDialog);
                                }
                            }
                            catch (IOException e) {
                                JOptionPane.showMessageDialog(RepositoryManager.this, "Download fehlgeschlagen: " + e.toString());
                                log.error("download failed", e);
                            }
                            RepositoryManager.this.update();
                        }
                    };
                    int index = list.locationToIndex(evt.getPoint());
                    Map txt = (Map)RepositoryManager.this.model.getElementAt(index);
                    int id = Integer.parseInt((String)txt.get("ID"));
                    try {
                        if (Repository.exists(id)) {
                            Repository.download(id, null);
                        } else {
                            Repository.update(id, null);
                        }
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(RepositoryManager.this, "Download fehlgeschlagen: " + ioe.getMessage());
                    }
                }
            }
        });
        this.update();
        this.setBounds(100, 100, 400, 600);
    }

    private void updateActionPerformed(ActionEvent evt) {
        new Progress(this.masterFrame, "Suche nach Aktualisierungen"){

            @Override
            public void action(ProgressDialog progressDialog) {
                try {
                    Repository.update(progressDialog);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(RepositoryManager.this, "Suche nach Aktualisierungen fehlgeschlagen");
                    log.error("unable to search for updates", e);
                }
                catch (IllegalArgumentException e) {
                    JOptionPane.showMessageDialog(RepositoryManager.this, "Suche nach Aktualisierungen fehlgeschlagen: " + e.getMessage());
                    log.error("unable to search for updates", e);
                }
                RepositoryManager.this.update();
            }
        };
    }

    private void searchActionPerformed(ActionEvent evt) {
        new Progress(this.masterFrame, "Suche nach neuen B\u00fcchern"){

            @Override
            public void action(ProgressDialog progressDialog) {
                try {
                    Repository.search(progressDialog);
                }
                catch (IllegalArgumentException e) {
                    JOptionPane.showMessageDialog(RepositoryManager.this, "Suche nach neuen B\u00fcchern fehlgeschlagen: " + e.getMessage());
                }
                RepositoryManager.this.update();
            }
        };
    }

    private void update() {
        this.model.update();
    }

    class MyListModel
    implements ListModel {
        private Set<ListDataListener> listeners = new HashSet<ListDataListener>();

        MyListModel() {
        }

        @Override
        public int getSize() {
            Integer[] ids = Repository.getIDs();
            return ids.length;
        }

        public Object getElementAt(int index) {
            int id = Repository.getIDs()[index];
            HashMap<String, String> txt = Repository.getBookTxt(id);
            String _id = Integer.toString(id);
            while (_id.length() < 5) {
                _id = "0" + _id;
            }
            txt.put("ID", _id);
            return txt;
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }

        void update() {
            Iterator<ListDataListener> i = this.listeners.iterator();
            while (i.hasNext()) {
                i.next().contentsChanged(null);
            }
        }
    }
}

