/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.andersicht.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import tingeltangel.andersicht.AndersichtBook;
import tingeltangel.andersicht.AndersichtDescriptionLayer;
import tingeltangel.andersicht.AndersichtGroup;
import tingeltangel.andersicht.AndersichtLanguageLayer;
import tingeltangel.andersicht.AndersichtObject;
import tingeltangel.andersicht.AndersichtTrack;
import tingeltangel.andersicht.gui.AndersichtChooseLabel;
import tingeltangel.andersicht.gui.AndersichtMainFrame;
import tingeltangel.andersicht.gui.DocumentAdapter;
import tingeltangel.core.TingStick;
import tingeltangel.tools.Callback;
import tingeltangel.tools.FileEnvironment;

class AndersichtPanel
extends JPanel {
    private final AndersichtMainFrame mainFrame;
    private static final Logger LOG = LogManager.getLogger(AndersichtPanel.class);
    private final JComboBox languageChooser;
    private final DefaultComboBoxModel languageChooserModel = new DefaultComboBoxModel();
    private JTree tree;
    private final JSplitPane splitPane;
    private JPanel optionPanel;
    private JPanel bookOptionPanel = new JPanel();
    private JLabel bookIdLabel = new JLabel();
    private JTextField bookNameField = new JTextField();
    private JTextArea bookDescriptionField = new JTextArea();
    private JPanel groupOptionPanel = new JPanel();
    private JTextField groupNameField = new JTextField();
    private JTextArea groupDescriptionField = new JTextArea();
    private JPanel objectOptionPanel = new JPanel();
    private JTextField objectNameField = new JTextField();
    private JTextArea objectDescriptionField = new JTextArea();
    private JPanel trackOptionPanel = new JPanel();
    private JTextArea trackTranscriptField = new JTextArea();
    private JLabel trackMp3Label = new JLabel();
    private JButton trackLabelButton = new JButton();
    private JButton deploymentButton = new JButton();
    private File lastMp3Dir = null;
    private final int ACTION_ADD_GROUP = 1;
    private final int ACTION_ADD_OBJECT = 2;
    private final int ACTION_ADD_MP3 = 3;
    private boolean online = false;

    AndersichtPanel(final AndersichtMainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.bookDescriptionField.setRows(10);
        this.groupDescriptionField.setRows(10);
        this.objectDescriptionField.setRows(10);
        this.trackTranscriptField.setRows(10);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(3, 3, 3, 3);
        this.bookOptionPanel.setLayout(new GridBagLayout());
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 2.0;
        gbc.anchor = 13;
        this.bookOptionPanel.add((Component)this.newActionButton(1, "Gruppe hinzuf\u00fcgen"), gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.3;
        gbc.anchor = 18;
        this.bookOptionPanel.add((Component)new JLabel("Buch ID"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 2.0;
        this.bookOptionPanel.add((Component)this.bookIdLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.3;
        this.bookOptionPanel.add((Component)new JLabel("Buchname"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 2.0;
        this.bookOptionPanel.add((Component)this.bookNameField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 0.3;
        this.bookOptionPanel.add((Component)new JLabel("Buchbeschreibung"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 2.0;
        this.bookOptionPanel.add((Component)this.bookDescriptionField, gbc);
        this.bookNameField.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            public void change() {
                TreePath selectionPath = AndersichtPanel.this.tree.getSelectionPath();
                if (selectionPath != null) {
                    AndersichtBook book = (AndersichtBook)selectionPath.getLastPathComponent();
                    book.setName(AndersichtPanel.this.bookNameField.getText());
                    ((DefaultTreeModel)AndersichtPanel.this.tree.getModel()).nodeChanged(book);
                }
            }
        });
        this.groupOptionPanel.setLayout(new GridBagLayout());
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 2.0;
        gbc.anchor = 13;
        this.groupOptionPanel.add((Component)this.newActionButton(2, "Objekt hinzuf\u00fcgen"), gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.3;
        gbc.anchor = 18;
        this.groupOptionPanel.add((Component)new JLabel("Guppenname"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 2.0;
        this.groupOptionPanel.add((Component)this.groupNameField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.3;
        this.groupOptionPanel.add((Component)new JLabel("Guppenbeschreibung"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 2.0;
        this.groupOptionPanel.add((Component)this.groupDescriptionField, gbc);
        this.groupNameField.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            public void change() {
                TreePath selectionPath = AndersichtPanel.this.tree.getSelectionPath();
                if (selectionPath != null) {
                    AndersichtGroup group = (AndersichtGroup)selectionPath.getLastPathComponent();
                    group.setName(AndersichtPanel.this.groupNameField.getText());
                    ((DefaultTreeModel)AndersichtPanel.this.tree.getModel()).nodeChanged(group);
                }
            }
        });
        this.groupDescriptionField.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            public void change() {
                TreePath selectionPath = AndersichtPanel.this.tree.getSelectionPath();
                if (selectionPath != null) {
                    AndersichtGroup group = (AndersichtGroup)selectionPath.getLastPathComponent();
                    group.setDescription(AndersichtPanel.this.groupDescriptionField.getText());
                }
            }
        });
        this.objectOptionPanel.setLayout(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.3;
        this.objectOptionPanel.add((Component)new JLabel("Objektname"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 2.0;
        this.objectOptionPanel.add((Component)this.objectNameField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.3;
        this.objectOptionPanel.add((Component)new JLabel("Objektbeschreibung"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 2.0;
        this.objectOptionPanel.add((Component)this.objectDescriptionField, gbc);
        this.objectNameField.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            public void change() {
                TreePath selectionPath = AndersichtPanel.this.tree.getSelectionPath();
                if (selectionPath != null) {
                    AndersichtObject object = (AndersichtObject)selectionPath.getLastPathComponent();
                    object.setName(AndersichtPanel.this.objectNameField.getText());
                    ((DefaultTreeModel)AndersichtPanel.this.tree.getModel()).nodeChanged(object);
                }
            }
        });
        this.objectDescriptionField.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            public void change() {
                TreePath selectionPath = AndersichtPanel.this.tree.getSelectionPath();
                if (selectionPath != null) {
                    AndersichtObject object = (AndersichtObject)selectionPath.getLastPathComponent();
                    object.setDescription(AndersichtPanel.this.objectDescriptionField.getText());
                }
            }
        });
        this.trackOptionPanel.setLayout(new GridBagLayout());
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 2.0;
        this.trackOptionPanel.add((Component)this.newActionButton(3, "MP3 ausw\u00e4hlen"), gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.3;
        this.trackOptionPanel.add((Component)new JLabel("Transkript"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 2.0;
        this.trackOptionPanel.add((Component)this.trackTranscriptField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.3;
        this.trackOptionPanel.add((Component)new JLabel("MP3"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 2.0;
        this.trackOptionPanel.add((Component)this.trackMp3Label, gbc);
        this.trackTranscriptField.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            public void change() {
                TreePath selectionPath = AndersichtPanel.this.tree.getSelectionPath();
                if (selectionPath != null) {
                    AndersichtTrack track = (AndersichtTrack)selectionPath.getLastPathComponent();
                    track.setTranscript(AndersichtPanel.this.trackTranscriptField.getText());
                }
            }
        });
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 0.3;
        this.trackOptionPanel.add((Component)new JLabel("Label"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 2.0;
        this.trackOptionPanel.add((Component)this.trackLabelButton, gbc);
        this.trackLabelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new AndersichtChooseLabel((Frame)mainFrame, mainFrame.getBook().getPen(), new Callback<Integer>(){

                    @Override
                    public void callback(Integer label) {
                        TreePath selectionPath = AndersichtPanel.this.tree.getSelectionPath();
                        if (selectionPath != null) {
                            AndersichtTrack track = (AndersichtTrack)selectionPath.getLastPathComponent();
                            AndersichtDescriptionLayer dl = track.getObject().getDescriptionLayer(track);
                            track.getObject().setLabel(dl, label);
                            AndersichtPanel.this.trackLabelButton.setText(track.getObject().getLabelAsString(dl));
                        }
                    }
                });
            }
        });
        this.setLayout(new BorderLayout());
        this.tree = new JTree(new DefaultTreeModel(mainFrame.getBook()));
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Object selectedObject = e.getPath().getLastPathComponent();
                AndersichtPanel.this.optionPanel.removeAll();
                if (selectedObject instanceof AndersichtBook) {
                    AndersichtBook book = (AndersichtBook)selectedObject;
                    AndersichtPanel.this.optionPanel.add((Component)AndersichtPanel.this.bookOptionPanel, "North");
                    AndersichtPanel.this.bookIdLabel.setText(Integer.toString(book.getBookId()));
                    AndersichtPanel.this.bookNameField.setText(book.getName());
                    AndersichtPanel.this.bookDescriptionField.setText(book.getDescription());
                } else if (selectedObject instanceof AndersichtGroup) {
                    AndersichtGroup group = (AndersichtGroup)selectedObject;
                    AndersichtPanel.this.optionPanel.add((Component)AndersichtPanel.this.groupOptionPanel, "North");
                    AndersichtPanel.this.groupNameField.setText(group.getName());
                    AndersichtPanel.this.groupDescriptionField.setText(group.getDescription());
                } else if (selectedObject instanceof AndersichtObject) {
                    AndersichtObject object = (AndersichtObject)selectedObject;
                    AndersichtPanel.this.optionPanel.add((Component)AndersichtPanel.this.objectOptionPanel, "North");
                    AndersichtPanel.this.objectNameField.setText(object.getName());
                    AndersichtPanel.this.objectDescriptionField.setText(object.getDescription());
                } else if (selectedObject instanceof AndersichtTrack) {
                    AndersichtTrack track = (AndersichtTrack)selectedObject;
                    AndersichtPanel.this.optionPanel.add((Component)AndersichtPanel.this.trackOptionPanel, "North");
                    AndersichtPanel.this.trackTranscriptField.setText(track.getTranscript());
                    File mp3 = track.getInternalMP3();
                    if (mp3 == null) {
                        AndersichtPanel.this.trackMp3Label.setText("<kein MP3>");
                    } else {
                        AndersichtPanel.this.trackMp3Label.setText(mp3.getName());
                    }
                    AndersichtPanel.this.trackLabelButton.setText(track.getObject().getLabelAsString(track.getObject().getDescriptionLayer(track)));
                }
                AndersichtPanel.this.optionPanel.revalidate();
                AndersichtPanel.this.optionPanel.repaint();
            }
        });
        this.languageChooser = new JComboBox(this.languageChooserModel);
        this.languageChooser.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AndersichtBook book;
                if (e.getStateChange() == 1 && (book = mainFrame.getBook()) != null) {
                    AndersichtLanguageLayer lLayer = (AndersichtLanguageLayer)e.getItem();
                    book.setActiveLanguageLayer(lLayer);
                    TreePath path = AndersichtPanel.this.tree.getSelectionPath();
                    if (path != null && path.getLastPathComponent() instanceof AndersichtTrack) {
                        AndersichtTrack track = (AndersichtTrack)path.getLastPathComponent();
                        path = path.getParentPath();
                        AndersichtObject object = (AndersichtObject)path.getLastPathComponent();
                        AndersichtDescriptionLayer dLayer = object.getDescriptionLayer(track);
                        path = path.pathByAddingChild(object.getTrack(lLayer, dLayer));
                    }
                    DefaultTreeModel model = (DefaultTreeModel)AndersichtPanel.this.tree.getModel();
                    model.setRoot(book);
                    if (path != null) {
                        AndersichtPanel.this.tree.setSelectionPath(path);
                    }
                }
            }
        });
        this.optionPanel = new JPanel();
        this.optionPanel.setLayout(new BorderLayout());
        this.splitPane = new JSplitPane(1, this.tree, this.optionPanel);
        this.add((Component)this.splitPane, "Center");
        this.splitPane.setDividerLocation(500);
        this.deploymentButton.setText("keinen Stift gefunden");
        this.deploymentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AndersichtBook book = mainFrame.getBook();
                    book.save();
                    try {
                        String fileName = Integer.toString(book.getBookId());
                        while (fileName.length() < 5) {
                            fileName = "0" + fileName;
                        }
                        fileName = fileName + "_en.ouf";
                        File file = new File(FileEnvironment.getAndersichtBookDirectory(Integer.toString(book.getBookId())), fileName);
                        book.generate(file);
                        try {
                            TingStick stick = TingStick.getStick();
                            if (stick != null) {
                                File dest = stick.getBookDir();
                                if (!dest.getAbsolutePath().contains("$ting")) {
                                    dest = new File(stick.getBookDir(), "$ting");
                                }
                                FileEnvironment.copy(file, new File(dest, file.getName()));
                                stick.activateBook(book.getBookId());
                                JOptionPane.showMessageDialog(mainFrame, "Buch auf den Stift kopiert");
                            } else {
                                JOptionPane.showMessageDialog(mainFrame, "Stift nicht gefunden");
                            }
                        }
                        catch (IOException e3) {
                            JOptionPane.showMessageDialog(mainFrame, "Fehler beim Kopieren des Buches auf den Stift: " + e3.getMessage());
                        }
                    }
                    catch (IOException e2) {
                        JOptionPane.showMessageDialog(mainFrame, "Fehler beim Generieren des Buches: " + e2.getMessage());
                    }
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(mainFrame, "Fehler beim Speichern des Buches: " + e1.getMessage());
                }
            }
        });
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    TingStick stick = TingStick.getStick();
                    if (AndersichtPanel.this.online && stick == null) {
                        AndersichtPanel.this.online = false;
                        AndersichtPanel.this.deploymentButton.setEnabled(false);
                        AndersichtPanel.this.deploymentButton.setText("keinen Stift gefunden");
                    } else if (!AndersichtPanel.this.online && stick != null && mainFrame.getBook() != null) {
                        AndersichtPanel.this.online = true;
                        AndersichtPanel.this.deploymentButton.setEnabled(true);
                        AndersichtPanel.this.deploymentButton.setText("auf den Stift kopieren");
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        };
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        scheduler.scheduleAtFixedRate(task, 3L, 3L, TimeUnit.SECONDS);
        this.deploymentButton.setEnabled(false);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new GridBagLayout());
        gbc.fill = 2;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.gridy = 0;
        gbc.gridx = 0;
        topPanel.add((Component)this.languageChooser, gbc);
        gbc.gridx = 1;
        topPanel.add((Component)this.deploymentButton, gbc);
        this.add((Component)topPanel, "North");
    }

    public DefaultComboBoxModel getLanguageChooserModel() {
        return this.languageChooserModel;
    }

    private JButton newActionButton(final int action, String label) {
        JButton button = new JButton(label);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndersichtPanel.this.action(action);
            }
        });
        return button;
    }

    void action(int action) {
        TreePath path = this.tree.getSelectionPath();
        Object selectedObject = path.getLastPathComponent();
        int[] childIndices = new int[1];
        switch (action) {
            case 1: {
                AndersichtBook book = (AndersichtBook)selectedObject;
                book.addGroup("neue Gruppe", "");
                childIndices[0] = book.getChildCount() - 1;
                ((DefaultTreeModel)this.tree.getModel()).nodesWereInserted(book, childIndices);
                break;
            }
            case 2: {
                AndersichtGroup group = (AndersichtGroup)selectedObject;
                group.addObject("neues Objekt", "");
                childIndices[0] = group.getChildCount() - 1;
                ((DefaultTreeModel)this.tree.getModel()).nodesWereInserted(group, childIndices);
                break;
            }
            case 3: {
                AndersichtTrack track = (AndersichtTrack)selectedObject;
                JFileChooser fc = new JFileChooser();
                fc.setFileFilter(new FileNameExtensionFilter("MP3 (*.mp3)", "mp3"));
                if (this.lastMp3Dir != null && this.lastMp3Dir.isDirectory()) {
                    fc.setCurrentDirectory(this.lastMp3Dir);
                }
                if (fc.showOpenDialog(this) != 0) break;
                int bookId = track.getObject().getGroup().getBook().getBookId();
                File source = fc.getSelectedFile();
                this.lastMp3Dir = source.getParentFile();
                File targetDir = FileEnvironment.getAndersichtAudioDirectory(Integer.toString(bookId));
                String uid = Integer.toString(targetDir.list().length);
                File target = new File(targetDir, uid + "-" + source.getName());
                try {
                    FileEnvironment.copy(source, target);
                    track.setMP3(target);
                    this.trackMp3Label.setText(track.getInternalMP3().getName());
                    break;
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog(this, "Fehler beim Importieren des MP3: " + ioe.getMessage());
                }
            }
        }
    }

    public void refresh() {
        AndersichtBook book = this.mainFrame.getBook();
        if (book != null) {
            LOG.info("refresh()");
            DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
            model.setRoot(book);
            this.languageChooserModel.removeAllElements();
            for (int i = 0; i < book.getLanguageLayerCount(); ++i) {
                this.languageChooserModel.addElement(book.getLanguageLayer(i));
            }
            LOG.info("refresh finished");
        }
    }
}

