/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import sun.awt.CustomCursor;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.IntegerComponentRaster;
import sun.awt.image.ToolkitImage;

final class WCustomCursor
extends CustomCursor {
    WCustomCursor(Image cursor, Point hotSpot, String name) throws IndexOutOfBoundsException {
        super(cursor, hotSpot, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createNativeCursor(Image im, int[] pixels, int w, int h, int xHotSpot, int yHotSpot) {
        BufferedImage bimage = new BufferedImage(w, h, 1);
        Graphics g = bimage.getGraphics();
        try {
            if (im instanceof ToolkitImage) {
                ImageRepresentation ir = ((ToolkitImage)im).getImageRep();
                ir.reconstruct(32);
            }
            g.drawImage(im, 0, 0, w, h, null);
        }
        finally {
            g.dispose();
        }
        WritableRaster raster = bimage.getRaster();
        DataBuffer buffer = raster.getDataBuffer();
        int[] data = ((DataBufferInt)buffer).getData();
        byte[] andMask = new byte[w * h / 8];
        int npixels = pixels.length;
        for (int i = 0; i < npixels; ++i) {
            int ibyte = i / 8;
            int omask = 1 << 7 - i % 8;
            if ((pixels[i] & 0xFF000000) != 0) continue;
            int n = ibyte;
            andMask[n] = (byte)(andMask[n] | omask);
        }
        int ficW = raster.getWidth();
        if (raster instanceof IntegerComponentRaster) {
            ficW = ((IntegerComponentRaster)raster).getScanlineStride();
        }
        this.createCursorIndirect(((DataBufferInt)bimage.getRaster().getDataBuffer()).getData(), andMask, ficW, raster.getWidth(), raster.getHeight(), xHotSpot, yHotSpot);
    }

    private native void createCursorIndirect(int[] var1, byte[] var2, int var3, int var4, int var5, int var6, int var7);

    static native int getCursorWidth();

    static native int getCursorHeight();
}

