/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import com.sun.jmx.remote.internal.RMIExporter;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.IOException;
import java.io.ObjectStreamClass;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIConnectionImpl;
import javax.management.remote.rmi.RMIServer;
import javax.management.remote.rmi.RMIServerImpl;
import javax.security.auth.Subject;
import sun.reflect.misc.ReflectUtil;
import sun.rmi.server.DeserializationChecker;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.server.UnicastServerRef2;

public class RMIJRMPServerImpl
extends RMIServerImpl {
    private final ExportedWrapper exportedWrapper;
    private final int port;
    private final RMIClientSocketFactory csf;
    private final RMIServerSocketFactory ssf;
    private final Map<String, ?> env;

    public RMIJRMPServerImpl(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf, Map<String, ?> env) throws IOException {
        super(env);
        if (port < 0) {
            throw new IllegalArgumentException("Negative port: " + port);
        }
        this.port = port;
        this.csf = csf;
        this.ssf = ssf;
        this.env = env == null ? Collections.emptyMap() : env;
        String[] credentialsTypes = (String[])this.env.get("jmx.remote.rmi.server.credential.types");
        ArrayList<String> types = null;
        if (credentialsTypes != null) {
            types = new ArrayList<String>();
            for (String type : credentialsTypes) {
                if (type == null) {
                    throw new IllegalArgumentException("A credential type is null.");
                }
                ReflectUtil.checkPackageAccess(type);
                types.add(type);
            }
        }
        this.exportedWrapper = types != null ? new ExportedWrapper(this, types) : null;
    }

    @Override
    protected void export() throws IOException {
        if (this.exportedWrapper != null) {
            this.export(this.exportedWrapper);
        } else {
            this.export(this);
        }
    }

    private void export(Remote obj) throws RemoteException {
        RMIExporter exporter = (RMIExporter)this.env.get("com.sun.jmx.remote.rmi.exporter");
        boolean daemon = EnvHelp.isServerDaemon(this.env);
        if (daemon && exporter != null) {
            throw new IllegalArgumentException("If jmx.remote.x.daemon is specified as true, com.sun.jmx.remote.rmi.exporter cannot be used to specify an exporter!");
        }
        if (daemon) {
            if (this.csf == null && this.ssf == null) {
                new UnicastServerRef(this.port).exportObject(obj, null, true);
            } else {
                new UnicastServerRef2(this.port, this.csf, this.ssf).exportObject(obj, null, true);
            }
        } else if (exporter != null) {
            exporter.exportObject(obj, this.port, this.csf, this.ssf);
        } else {
            UnicastRemoteObject.exportObject(obj, this.port, this.csf, this.ssf);
        }
    }

    private void unexport(Remote obj, boolean force) throws NoSuchObjectException {
        RMIExporter exporter = (RMIExporter)this.env.get("com.sun.jmx.remote.rmi.exporter");
        if (exporter == null) {
            UnicastRemoteObject.unexportObject(obj, force);
        } else {
            exporter.unexportObject(obj, force);
        }
    }

    @Override
    protected String getProtocol() {
        return "rmi";
    }

    @Override
    public Remote toStub() throws IOException {
        if (this.exportedWrapper != null) {
            return RemoteObject.toStub(this.exportedWrapper);
        }
        return RemoteObject.toStub(this);
    }

    @Override
    protected RMIConnection makeClient(String connectionId, Subject subject) throws IOException {
        if (connectionId == null) {
            throw new NullPointerException("Null connectionId");
        }
        RMIConnectionImpl client = new RMIConnectionImpl(this, connectionId, this.getDefaultClassLoader(), subject, this.env);
        this.export(client);
        return client;
    }

    @Override
    protected void closeClient(RMIConnection client) throws IOException {
        this.unexport(client, true);
    }

    @Override
    protected void closeServer() throws IOException {
        if (this.exportedWrapper != null) {
            this.unexport(this.exportedWrapper, true);
        } else {
            this.unexport(this, true);
        }
    }

    private static class ExportedWrapper
    implements RMIServer,
    DeserializationChecker {
        private final RMIServer impl;
        private final List<String> allowedTypes;

        private ExportedWrapper(RMIServer impl, List<String> credentialsTypes) {
            this.impl = impl;
            this.allowedTypes = credentialsTypes;
        }

        @Override
        public String getVersion() throws RemoteException {
            return this.impl.getVersion();
        }

        @Override
        public RMIConnection newClient(Object credentials) throws IOException {
            return this.impl.newClient(credentials);
        }

        @Override
        public void check(Method method, ObjectStreamClass descriptor, int paramIndex, int callID) {
            String type = descriptor.getName();
            if (!this.allowedTypes.contains(type)) {
                throw new ClassCastException("Unsupported type: " + type);
            }
        }

        @Override
        public void checkProxyClass(Method method, String[] ifaces, int paramIndex, int callID) {
            if (ifaces != null && ifaces.length > 0) {
                for (String iface : ifaces) {
                    if (this.allowedTypes.contains(iface)) continue;
                    throw new ClassCastException("Unsupported type: " + iface);
                }
            }
        }
    }
}

