/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.core;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import tingeltangel.core.Book;
import tingeltangel.core.Entry;
import tingeltangel.core.scripting.Command;
import tingeltangel.core.scripting.Commands;
import tingeltangel.core.scripting.Disassembler;
import tingeltangel.core.scripting.Emulator;
import tingeltangel.core.scripting.Instance;
import tingeltangel.core.scripting.SyntaxError;
import tingeltangel.core.scripting.Template;

public class Script {
    private final Entry entry;
    private String code;
    private boolean kill = false;
    private LinkedList<Instance> script = null;
    private HashMap<String, Integer> instanceLabelsSI = null;
    private HashMap<Integer, Integer> instanceLabelsII = null;
    private HashSet<Integer> usedRegisters = null;
    private static int labelCounter = 0;
    private static final Logger compilerLog = LogManager.getLogger("compiler");
    private static final Logger emulatorLog = LogManager.getLogger("emulator");

    public Script(String code, Entry entry) {
        this.entry = entry;
        this.code = code;
    }

    public Script(byte[] binary, Entry entry) throws SyntaxError {
        this.entry = entry;
        this.code = new Disassembler().disassemble(binary);
    }

    void changeMade() {
        this.entry.changeMade();
        this.usedRegisters = null;
    }

    public void setCode(String code) {
        this.code = code;
        this.changeMade();
    }

    public String toString() {
        return this.code;
    }

    public int getSize(boolean calledFromScript) throws SyntaxError {
        return this.compile().length;
    }

    public boolean isSub() {
        try {
            String row;
            BufferedReader in = new BufferedReader(new StringReader(this.code));
            while ((row = in.readLine()) != null) {
                if (!row.trim().startsWith("return")) continue;
                in.close();
                return true;
            }
            in.close();
        }
        catch (IOException e) {
            throw new Error(e);
        }
        return false;
    }

    public void kill() {
        this.kill = true;
    }

    public void execute() throws SyntaxError {
        this.execute(false);
    }

    private void execute(boolean subCall) throws SyntaxError {
        this.compile();
        emulatorLog.trace("ID=" + Integer.toString(this.entry.getTingID()));
        if (!subCall) {
            this.entry.getBook().getEmulator().setLastOID(this.entry.getTingID());
        }
        int pc = 0;
        this.kill = false;
        while (!this.kill) {
            if (pc >= this.script.size()) {
                SyntaxError error = new SyntaxError("missing 'end' command");
                error.setTingID(this.entry.getTingID());
                error.setRow(-1);
                throw error;
            }
            Instance instance = this.script.get(pc);
            emulatorLog.trace("\t" + pc + ": " + instance.toString(this.entry.getBook().getEmulator()));
            if (instance.getCommand().getAsm().equals("end")) {
                return;
            }
            if (instance.getCommand().getAsm().equals("call") || instance.getCommand().getAsm().equals("callid")) {
                int oid = instance.getFirstArgument();
                this.entry.getBook().getEntryByOID(oid).getScript().execute(true);
                ++pc;
                continue;
            }
            if (instance.getCommand().getAsm().equals("return")) {
                return;
            }
            int action = instance.execute(this.entry.getBook().getEmulator());
            if (action == 1) {
                pc = this.instanceLabelsII.get(instance.getLabel());
                continue;
            }
            ++pc;
        }
    }

    public HashSet<Integer> getAllUsedRegisters() throws IOException, SyntaxError {
        String row;
        if (this.usedRegisters != null) {
            return this.usedRegisters;
        }
        BufferedReader in = new BufferedReader(new StringReader(this.mergeCodeOnCalls(false).toString()));
        HashSet<Integer> registers = new HashSet<Integer>();
        while ((row = in.readLine()) != null) {
            int p;
            if ((row = row.trim()).isEmpty() || row.startsWith("//") || (p = row.indexOf(" ")) == -1) continue;
            row = row.substring(p).trim();
            String[] vals = row.split(",");
            for (int i = 0; i < vals.length; ++i) {
                String val = vals[i].trim().toLowerCase();
                if (!val.startsWith("v")) continue;
                val = val.substring(1);
                registers.add(Integer.parseInt(val));
            }
        }
        this.usedRegisters = registers;
        return registers;
    }

    private String mergeCodeOnCalls(boolean subCall) throws IOException, SyntaxError {
        String row;
        String returnLabel = "return_" + ++labelCounter;
        StringBuilder mergedCode = new StringBuilder();
        BufferedReader in = new BufferedReader(new StringReader(this.code));
        String labelPrefix = "sub_" + labelCounter + "_";
        int rc = 0;
        while ((row = in.readLine()) != null) {
            ++rc;
            if ((row = row.trim().toLowerCase()).isEmpty() || row.startsWith("//")) continue;
            int p = row.indexOf("//");
            if (p != -1) {
                row = row.substring(0, p).trim();
            }
            p = row.indexOf(" ");
            boolean jump = false;
            if (p != -1) {
                jump = Commands.isJump(row.substring(0, p));
            }
            if (row.startsWith(":")) {
                mergedCode.append(":").append(labelPrefix + row.substring(1)).append("\n");
                continue;
            }
            if (jump) {
                p = row.indexOf(" ");
                String cmd = row.substring(0, p);
                String label = labelPrefix + row.substring(p + 1);
                mergedCode.append(cmd).append(" ").append(label).append("\n");
                continue;
            }
            if (row.startsWith("call ")) {
                try {
                    int oid = Integer.parseInt(row.substring("call".length()).trim());
                    String subCode = this.entry.getBook().getEntryByOID(oid).getScript().mergeCodeOnCalls(true);
                    mergedCode.append(subCode);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    SyntaxError error = new SyntaxError("call needs a value as argument");
                    error.setRow(rc);
                    error.setTingID(this.entry.getTingID());
                    throw error;
                }
            }
            if (row.equals("return")) {
                if (subCall) {
                    mergedCode.append("jmp ").append(returnLabel).append("\n");
                    continue;
                }
                mergedCode.append("return").append("\n");
                continue;
            }
            mergedCode.append(row).append("\n");
        }
        in.close();
        mergedCode.append(":").append(returnLabel).append("\n");
        return mergedCode.toString();
    }

    public byte[] compile() throws SyntaxError {
        HashMap<String, Integer> labels = new HashMap<String, Integer>();
        this.instanceLabelsSI = new HashMap();
        this.instanceLabelsII = new HashMap();
        this.script = new LinkedList();
        int rc = 0;
        try {
            String cmd;
            int p;
            String row;
            String mergedCode = this.replaceTemplatesAndResolveNames(this.mergeCodeOnCalls(false));
            compilerLog.trace("ID=" + Integer.toString(this.entry.getTingID()));
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bout);
            BufferedReader in = new BufferedReader(new StringReader(mergedCode));
            int position = 0;
            int instancePos = 0;
            while ((row = in.readLine()) != null) {
                compilerLog.trace("\t" + row);
                ++rc;
                if ((row = row.trim().toLowerCase()).isEmpty() || row.startsWith("//")) continue;
                if (row.startsWith(":")) {
                    labels.put(row.substring(1).trim(), position);
                    this.instanceLabelsSI.put(row.substring(1).trim(), instancePos);
                    continue;
                }
                p = row.indexOf(" ");
                cmd = row;
                if (p != -1) {
                    cmd = row.substring(0, p);
                }
                position += Commands.getSize(cmd);
                ++instancePos;
            }
            in.close();
            in = new BufferedReader(new StringReader(mergedCode));
            rc = 0;
            while ((row = in.readLine()) != null) {
                ++rc;
                if ((row = row.trim().toLowerCase()).isEmpty() || row.startsWith("//") || row.startsWith(":")) continue;
                p = row.indexOf("//");
                if (p != -1) {
                    row = row.substring(0, p).trim();
                }
                p = row.indexOf(" ");
                cmd = row;
                String args = null;
                if (p != -1) {
                    cmd = row.substring(0, p).trim();
                    args = row.substring(p).trim();
                }
                Command command = null;
                String arg1 = null;
                String arg2 = null;
                switch (Commands.getArguments(cmd)) {
                    case 0: {
                        command = Commands.getCommand(cmd);
                        break;
                    }
                    case 1: {
                        arg1 = args;
                        command = Commands.getCommand(cmd, arg1);
                        break;
                    }
                    case 2: {
                        p = args.indexOf(",");
                        arg1 = args.substring(0, p).trim();
                        arg2 = args.substring(p + 1).trim();
                        command = Commands.getCommand(cmd, arg1, arg2);
                    }
                }
                Instance instance = new Instance(command);
                if (command.firstArgumentIsLabel()) {
                    Integer label = (Integer)labels.get(arg1);
                    if (label == null) {
                        throw new SyntaxError("unknown label: " + arg1);
                    }
                    instance.setLabel(label);
                    this.instanceLabelsII.put(instance.getLabel(), this.instanceLabelsSI.get(arg1));
                } else {
                    if (Commands.getArguments(cmd) > 0) {
                        instance.setFirstArgument(arg1);
                    }
                    if (Commands.getArguments(cmd) > 1) {
                        instance.setSecondArgument(arg2);
                    }
                }
                instance.compile(out);
                this.script.add(instance);
            }
            in.close();
            out.write(0);
            out.flush();
            byte[] result = bout.toByteArray();
            out.close();
            return result;
        }
        catch (IOException ioe) {
            throw new Error(ioe);
        }
        catch (SyntaxError se) {
            if (se.getRow() < 0) {
                se.setRow(rc);
                se.setTingID(this.entry.getTingID());
            }
            throw se;
        }
    }

    public String toStringWithoutTemplatesAndNames() throws IOException, SyntaxError {
        return this.replaceTemplatesAndResolveNames(this.code);
    }

    private String replaceTemplatesAndResolveNames(String code) throws IOException, SyntaxError {
        String row;
        BufferedReader in = new BufferedReader(new StringReader(code));
        StringBuilder out = new StringBuilder();
        Book book = this.entry.getBook();
        HashSet<Object> usedRegs = new HashSet();
        if (book != null) {
            usedRegs = book.getAllUsedRegisters();
        }
        HashSet<Integer> registersUsedByTemplate = new HashSet<Integer>();
        Pattern pattern = Pattern.compile("\\s");
        while ((row = in.readLine()) != null) {
            row = row.trim().toLowerCase();
            String args = "";
            Matcher matcher = pattern.matcher(row);
            if (matcher.find()) {
                int p = matcher.start();
                args = row.substring(p + 1).trim();
                row = row.substring(0, p);
            }
            String[] _as = args.split(",");
            args = "";
            for (int i = 0; i < _as.length; ++i) {
                _as[i] = _as[i].trim();
                if (_as[i].startsWith("@")) {
                    Entry e = book.getEntryByName(_as[i].substring(1));
                    if (e == null) {
                        throw new SyntaxError("OID Name '" + _as[i].substring(1) + "' nicht gefunden");
                    }
                    args = args + "," + Integer.toString(e.getTingID());
                    continue;
                }
                args = args + "," + _as[i];
            }
            args = args.substring(1);
            Template t = Template.getTemplate(row);
            if (t != null) {
                LinkedList<String> as = new LinkedList<String>();
                if (!args.isEmpty()) {
                    _as = args.split(",");
                    for (int i = 0; i < _as.length; ++i) {
                        as.add(_as[i].toLowerCase().trim());
                    }
                }
                for (int r = 0; r <= Emulator.getMaxBasicRegister(); ++r) {
                    if (usedRegs.contains(r)) continue;
                    registersUsedByTemplate.add(r);
                }
                out.append(t.getCode(as, registersUsedByTemplate));
                continue;
            }
            out.append(row);
            if (!args.isEmpty()) {
                out.append(" ").append(args);
            }
            out.append("\n");
        }
        return out.toString();
    }
}

