/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.cli_ng;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import tingeltangel.cli_ng.CLI;
import tingeltangel.cli_ng.CliCmd;
import tingeltangel.core.Book;
import tingeltangel.core.Importer;
import tingeltangel.core.Repository;

class ImportManual
extends CliCmd {
    ImportManual() {
    }

    @Override
    public String getName() {
        return "import-manual";
    }

    @Override
    public String getDescription() {
        return "import-manual [src <src file>] [ouf <ouf file>] [txt <txt file>] [png <png-file>] [mid <mid>]";
    }

    @Override
    public int execute(String[] args) {
        String src = null;
        String ouf = null;
        String txt = null;
        String png = null;
        String mid = null;
        for (int p = 0; p < args.length - 1; p += 2) {
            String a = args[p].trim().toLowerCase();
            if (a.equals("src")) {
                src = args[p + 1].trim();
                continue;
            }
            if (a.equals("ouf")) {
                ouf = args[p + 1].trim();
                continue;
            }
            if (a.equals("txt")) {
                txt = args[p + 1].trim();
                continue;
            }
            if (a.equals("png")) {
                png = args[p + 1].trim();
                continue;
            }
            if (a.equals("mid")) {
                mid = args[p + 1].trim();
                continue;
            }
            return this.error("syntax error");
        }
        if (src != null && !new File(src).canRead()) {
            return this.error("Die Datei " + src + " konnte nicht gelesen werden");
        }
        if (ouf != null && !new File(ouf).canRead()) {
            return this.error("Die Datei " + ouf + " konnte nicht gelesen werden");
        }
        if (txt != null && !new File(txt).canRead()) {
            return this.error("Die Datei " + txt + " konnte nicht gelesen werden");
        }
        if (png != null && !new File(png).canRead()) {
            return this.error("Die Datei " + png + " konnte nicht gelesen werden");
        }
        int id = -1;
        if (mid != null) {
            try {
                id = Integer.parseInt(mid);
            }
            catch (NumberFormatException e) {
                return this.error("Fehlerhafte mid angegeben");
            }
            if (id < 1 || id > 9999) {
                return this.error("Fehlerhafte mid angegeben (1-9999)");
            }
        }
        if (id < 0 && ouf != null) {
            try {
                DataInputStream in = new DataInputStream(new FileInputStream(ouf));
                in.skipBytes(20);
                id = in.readInt();
                in.close();
            }
            catch (IOException e) {
                return this.error("Fehler beim Lesen der ouf-Datei", e);
            }
        }
        if (id < 0) {
            return this.error("MID konnte nicht ermittelt werden");
        }
        if (ouf == null && src == null) {
            return this.error("Es muss mindestens eine ouf Datei oder eine src Datei angegeben werden");
        }
        Book book = CLI.getBook();
        book.setID(id);
        book.clear();
        try {
            Importer.importBook(new File(ouf), Repository.getBook(new File(txt)), new File(src), new File(png), book, null);
        }
        catch (Exception e) {
            return this.error("Das Buch konnte nicht importiert werden.", e);
        }
        return this.ok();
    }
}

