/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.cli_ng;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import tingeltangel.cli_ng.CLI;
import tingeltangel.cli_ng.CliCmd;
import tingeltangel.core.Entry;
import tingeltangel.core.MP3Player;
import tingeltangel.core.scripting.SyntaxError;
import tingeltangel.tools.Callback;

class Play
extends CliCmd {
    Play() {
    }

    @Override
    String getName() {
        return "play";
    }

    @Override
    String getDescription() {
        return "play <oid>";
    }

    @Override
    int execute(String[] args) {
        int oid;
        if (args.length != 1) {
            return this.error("falsche Anzahl von Parametern");
        }
        try {
            oid = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            return this.error("OID keine Zahl zw. 15001 und 65535");
        }
        if (oid < 15001 || oid > 65535) {
            return this.error("OID keine Zahl zw. 15001 und 65535");
        }
        if (!CLI.bookOpened()) {
            return this.error("kein Buch ge\u00f6ffnet");
        }
        if (!CLI.getBook().entryForTingIDExists(oid)) {
            return this.error("OID nicht gefunden");
        }
        final Entry entry = CLI.getBook().getEntryByOID(oid);
        if (entry.isSub()) {
            return this.error("OID ist ein Sub-Skript");
        }
        if (entry.isMP3() && entry.getMP3() != null) {
            try {
                MP3Player.getPlayer().play(entry.getMP3(), new Callback<Exception>(){

                    @Override
                    public void callback(Exception t) {
                        System.err.println("Fehler bein Abspielen des MP3 (" + entry.getMP3().getAbsolutePath() + "): " + t.getMessage());
                    }
                });
            }
            catch (FileNotFoundException ex) {
                return this.error("konnte MP3 nicht abspielen", ex);
            }
        }
        if (entry.isCode()) {
            try {
                entry.getScript().execute();
            }
            catch (SyntaxError se) {
                return this.error("Syntax Fehler (OID " + se.getTingID() + " Zeile " + se.getRow() + "): " + se.getMessage());
            }
        }
        if (entry.isTTS()) {
            try {
                final File tts = entry.getTTS().generateTTS(entry);
                MP3Player.getPlayer().play(tts, new Callback<Exception>(){

                    @Override
                    public void callback(Exception t) {
                        System.err.println("Fehler bein Abspielen des MP3 (" + tts.getAbsolutePath() + "): " + t.getMessage());
                    }
                });
            }
            catch (IOException ioe) {
                return this.error("Es ist ein Fehelr aufgetreten: " + ioe.getMessage(), ioe);
            }
        }
        return this.ok();
    }
}

