/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.gui;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import tingeltangel.core.scripting.Constants;
import tingeltangel.gui.EditorFrame;

public class ConstantsPanel
extends JPanel {
    private final ConstantsTableModel model = new ConstantsTableModel();
    private final JTable table = new JTable(this.model);
    private final EditorFrame frame;

    public ConstantsPanel(EditorFrame frame) {
        this.frame = frame;
        this.setLayout(new GridLayout(1, 1));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(0);
        this.table.getColumnModel().getColumn(1).setMinWidth(20);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setPreferredSize(new Dimension(0, 100));
        this.add(jScrollPane);
    }

    class ConstantsTableModel
    implements TableModel {
        private final HashSet<TableModelListener> listeners = new HashSet();

        ConstantsTableModel() {
        }

        @Override
        public int getRowCount() {
            return ConstantsPanel.this.frame.getBook().getConstants().getNames().size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Wert";
                }
            }
            throw new Error();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
            throw new Error();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Constants constants = ConstantsPanel.this.frame.getBook().getConstants();
            String name = constants.getNameAt(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return name;
                }
                case 1: {
                    return constants.get(name);
                }
            }
            throw new Error();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            String value = (String)aValue;
            Constants constants = ConstantsPanel.this.frame.getBook().getConstants();
            switch (columnIndex) {
                case 1: {
                    String name = constants.getNameAt(rowIndex);
                    constants.set(name, value);
                }
            }
            this.pushEvent(new TableModelEvent(this, rowIndex, rowIndex, 1));
        }

        private void pushEvent(TableModelEvent event) {
            Iterator<TableModelListener> i = this.listeners.iterator();
            while (i.hasNext()) {
                i.next().tableChanged(event);
            }
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listeners.remove(l);
        }
    }
}

