/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.cli_ng;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import tingeltangel.cli_ng.CLI;
import tingeltangel.cli_ng.CliCmd;
import tingeltangel.core.Book;
import tingeltangel.core.Codes;
import tingeltangel.core.Translator;

class GenerateCode
extends CliCmd {
    GenerateCode() {
    }

    @Override
    public String getName() {
        return "generate-code";
    }

    @Override
    public String getDescription() {
        return "generate-code 600|1200 <size in mm> <ting id> <png file>";
    }

    @Override
    public int execute(String[] args) {
        if (args.length != 4) {
            return this.error("falsche Anzahl von Parametern angegeben");
        }
        File file = new File(args[3].trim());
        if (args[0].toLowerCase().equals("600")) {
            Codes.setResolution(0);
        } else if (args[0].toLowerCase().equals("1200")) {
            Codes.setResolution(1);
        } else {
            return this.error("Syntax Fehler");
        }
        int size = -1;
        try {
            size = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            return this.error("ung\u00fcltige Gro\u00dfe angegeben (5-500)");
        }
        if (size < 5 || size > 500) {
            return this.error("ung\u00fcltige Gro\u00dfe angegeben (5-500)");
        }
        int id = -1;
        try {
            id = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException e) {
            return this.error("ung\u00fcltige id angegeben (0-65535)");
        }
        id = Translator.ting2code(id);
        if (id < 0) {
            return this.error("unbekannte id angegeben");
        }
        Book book = CLI.getBook();
        try {
            FileOutputStream out = new FileOutputStream(file);
            Codes.drawPng(id, size, size, out);
            out.close();
        }
        catch (IOException e) {
            return this.error("Code konnten nicht erzeugt werden", e);
        }
        return this.ok();
    }
}

