/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.wimmelbuch;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import tingeltangel.wimmelbuch.Constraint;
import tingeltangel.wimmelbuch.Item;

public class Event
implements Comparable {
    public static final int IN_ORDER = 0;
    public static final int PERMUTATE = 1;
    private final String tts;
    private final LinkedList<Item> items = new LinkedList();
    private int mode = 0;
    private boolean clearQueueAfterEvent = false;
    private int audioTrack = 0;
    private final LinkedList<Constraint> setConstraints = new LinkedList();
    private final LinkedList<Constraint> unsetConstraints = new LinkedList();
    private final LinkedList<Constraint> resultingSetConstraints = new LinkedList();
    private final LinkedList<Constraint> resultingUnsetConstraints = new LinkedList();

    public Event(String tts) {
        this.tts = tts;
    }

    public void setClearQueueAfterEvent() {
        this.clearQueueAfterEvent = true;
    }

    public boolean clearQueueAfterEvent() {
        return this.clearQueueAfterEvent;
    }

    public LinkedList<Constraint> getSetConstraints() {
        return this.setConstraints;
    }

    public LinkedList<Constraint> getUnsetConstraints() {
        return this.unsetConstraints;
    }

    public LinkedList<Constraint> getResultingSetConstraints() {
        return this.resultingSetConstraints;
    }

    public LinkedList<Constraint> getResultingUnsetConstraints() {
        return this.resultingUnsetConstraints;
    }

    public int getAudioTrack() {
        return this.audioTrack;
    }

    public String getTTS() {
        return this.tts;
    }

    public void setAudioTrack(int audioTrack) {
        this.audioTrack = audioTrack;
    }

    public void addItem(Item item) throws Exception {
        if (this.items.size() == 6) {
            throw new Exception();
        }
        this.items.addFirst(item);
    }

    public List<Item> getItems() {
        return this.items;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public HashSet<Constraint> getAllConstraints() {
        HashSet<Constraint> constraints = new HashSet<Constraint>();
        constraints.addAll(this.setConstraints);
        constraints.addAll(this.unsetConstraints);
        constraints.addAll(this.resultingSetConstraints);
        constraints.addAll(this.resultingUnsetConstraints);
        return constraints;
    }

    public void addUnsetConstraint(Constraint constraint) {
        this.unsetConstraints.add(constraint);
    }

    public void addSetConstraint(Constraint constraint) {
        this.setConstraints.add(constraint);
    }

    public void addResultingSetConstraint(Constraint constraint) {
        this.resultingSetConstraints.add(constraint);
    }

    public void addResultingUnsetConstraint(Constraint constraint) {
        this.resultingUnsetConstraints.add(constraint);
    }

    public int compareTo(Object e) {
        if (e == null) {
            throw new Error();
        }
        if (!(e instanceof Event)) {
            throw new Error();
        }
        if (this.equals(e)) {
            return 0;
        }
        Event event = (Event)e;
        if (this.items.size() > event.items.size()) {
            return -1;
        }
        if (this.items.size() < event.items.size()) {
            return 1;
        }
        int c = this.getEventString().compareTo(event.getEventString());
        if (c != 0) {
            return c;
        }
        c = this.getConstraintString().compareTo(event.getConstraintString());
        if (c != 0) {
            return c;
        }
        throw new Error("found unique events");
    }

    private String getConstraintString() {
        String s = "";
        for (Constraint c : this.setConstraints) {
            s = s + "," + c.getRegister() + "." + c.getBit();
        }
        for (Constraint c : this.unsetConstraints) {
            s = s + ",!" + c.getRegister() + "." + c.getBit();
        }
        return s;
    }

    private String getEventString() {
        Iterator i = this.items.iterator();
        String s = "";
        while (i.hasNext()) {
            s = s + "," + ((Item)i.next()).getName();
        }
        return s;
    }
}

