/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import tingeltangel.core.Codes;
import tingeltangel.core.Entry;
import tingeltangel.core.MP3Player;
import tingeltangel.core.Translator;
import tingeltangel.core.scripting.SyntaxError;
import tingeltangel.gui.EditorPanel;
import tingeltangel.gui.MultipleChoiceDialog;
import tingeltangel.tools.Callback;
import tingeltangel.tools.Lang;

public class IndexListEntry
extends JPanel {
    private final int ICON_MP3 = 0;
    private final int ICON_SCRIPT = 1;
    private final int ICON_SUB_SCRIPT = 2;
    private final int ICON_TTS = 3;
    private final int ICON_PLAY = 4;
    private final int ICON_EJECT = 5;
    private final int ICON_TEST = 6;
    private final int ICON_DELETE = 7;
    private final int ICON_SAVE_PATTERN = 8;
    private final int ICON_COPY_PATTERN = 9;
    private final int ICON_SAVE_MP3 = 10;
    private final String[] ICONS = new String[]{"mp3.png", "code.png", "sub.png", "tts.png", "play.png", "eject.png", "compile.png", "delete.png", "save-code.png", "copy-code.png", "save-mp3.png"};
    private static final String MP3 = "mp3";
    private static final String SCRIPT = "script";
    private static final String SUB = "sub";
    private static final String TTS = "tts";
    private static String lastChooseMp3DialogPath = null;
    private JLabel trackInfo = new JLabel(" ");
    private final Entry entry;
    private final JTextArea hint = new JTextArea();
    private final JCheckBox codeCheckBox = new JCheckBox();
    private final JTextField name = new JTextField();
    private static final Logger log = LogManager.getLogger(IndexListEntry.class);

    private ImageIcon getIcon(int res) {
        try {
            return new ImageIcon(ImageIO.read(this.getClass().getResource("/icons/" + this.ICONS[res])));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public IndexListEntry(final Entry entry, final EditorPanel frame) {
        this.entry = entry;
        boolean unknownID = Translator.ting2code(entry.getTingID()) < 0;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel header = new JPanel();
        header.setLayout(new BoxLayout(header, 1));
        JPanel row = new JPanel();
        if (unknownID) {
            row.setBackground(Color.red);
        }
        final JButton sizeButton = new JButton("<");
        sizeButton.setMargin(new Insets(0, 0, 0, 0));
        sizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (IndexListEntry.this.hint.isVisible()) {
                    IndexListEntry.this.hint.setVisible(false);
                    sizeButton.setText(">");
                } else {
                    IndexListEntry.this.hint.setVisible(true);
                    sizeButton.setText("<");
                }
            }
        });
        row.add(sizeButton);
        JPanel space2 = new JPanel();
        Dimension spaceDim = new Dimension(20, 1);
        space2.setMinimumSize(spaceDim);
        space2.setMaximumSize(spaceDim);
        row.add(space2);
        JButton jboid = new JButton(Integer.toString(entry.getTingID()));
        jboid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
            }
        });
        row.add(jboid);
        int iconRes = -1;
        if (entry.isMP3()) {
            iconRes = 0;
        } else if (entry.isCode()) {
            iconRes = 1;
        } else if (entry.isSub()) {
            iconRes = 2;
        } else if (entry.isTTS()) {
            iconRes = 3;
        }
        JButton icon = new JButton(this.getIcon(iconRes));
        icon.setToolTipText("Type \u00e4ndern (MP3, Script, TTS)");
        icon.setMargin(new Insets(0, 0, 0, 0));
        icon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JComponent source = (JComponent)ae.getSource();
                int px = source.getX() + IndexListEntry.this.getX() + frame.getMainFrame().getX() - frame.getScrollX();
                int py = source.getY() + IndexListEntry.this.getY() + frame.getMainFrame().getY() - frame.getScrollY();
                String[] options = new String[]{Lang.get("indexFrame.dialog.mp3"), Lang.get("indexFrame.dialog.script"), Lang.get("indexFrame.dialog.sub"), Lang.get("indexFrame.dialog.tts")};
                String[] actions = new String[]{IndexListEntry.MP3, IndexListEntry.SCRIPT, IndexListEntry.SUB, IndexListEntry.TTS};
                Callback<String> callback = new Callback<String>(){

                    @Override
                    public void callback(String s) {
                        String oldVal = "";
                        if (entry.isCode() || entry.isSub()) {
                            oldVal = entry.getScript().toString();
                        } else if (entry.isMP3()) {
                            oldVal = entry.getHint();
                        } else if (entry.isTTS()) {
                            oldVal = entry.getTTS().text;
                        }
                        if (s.equals(IndexListEntry.MP3)) {
                            entry.setMP3();
                            entry.setHint(oldVal);
                        } else if (s.equals(IndexListEntry.SCRIPT)) {
                            entry.setCode();
                            entry.getScript().setCode(oldVal);
                        } else if (s.equals(IndexListEntry.SUB)) {
                            entry.setSub();
                            entry.getScript().setCode(oldVal);
                        } else if (s.equals(IndexListEntry.TTS)) {
                            entry.setTTS();
                            entry.getTTS().text = oldVal;
                        }
                        new Thread(){

                            @Override
                            public void run() {
                                JPanel p = frame.getListPanel();
                                int rowNr = -1;
                                for (int i = 0; i < p.getComponentCount(); ++i) {
                                    if (p.getComponent(i) != IndexListEntry.this) continue;
                                    rowNr = i;
                                    break;
                                }
                                if (rowNr < 0) {
                                    throw new Error();
                                }
                                p.remove(IndexListEntry.this);
                                p.add((Component)new IndexListEntry(entry, frame), rowNr);
                                p.revalidate();
                                p.repaint();
                            }
                        }.start();
                    }
                };
                int preselection = -1;
                if (entry.isMP3()) {
                    preselection = 0;
                } else if (entry.isCode()) {
                    preselection = 1;
                } else if (entry.isSub()) {
                    preselection = 2;
                } else if (entry.isTTS()) {
                    preselection = 3;
                } else {
                    throw new Error();
                }
                MultipleChoiceDialog.show(frame.getMainFrame(), "Frage...", "Typ \u00e4ndern", "OK", options, actions, preselection, callback, px, py);
            }
        });
        row.add(icon);
        JPanel space = new JPanel();
        space.setMinimumSize(spaceDim);
        space.setMaximumSize(spaceDim);
        row.add(space);
        JButton delete = new JButton(this.getIcon(7));
        delete.setToolTipText("l\u00f6schen");
        delete.setMargin(new Insets(0, 0, 0, 0));
        delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                entry.getBook().removeEntryByTingID(entry.getTingID());
                frame.stopTrack();
                new Thread(){

                    @Override
                    public void run() {
                        JPanel p = frame.getListPanel();
                        p.remove(IndexListEntry.this);
                        p.revalidate();
                        p.repaint();
                    }
                }.start();
            }
        });
        row.add(delete);
        JButton play = new JButton(this.getIcon(4));
        play.setToolTipText("abspielen");
        play.setMargin(new Insets(0, 0, 0, 0));
        play.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                frame.setCurrentTrack(entry);
                new Thread(){

                    @Override
                    public void run() {
                        if (entry.isMP3() && entry.getMP3() != null) {
                            try {
                                MP3Player.getPlayer().play(entry.getMP3(), new Callback<Exception>(){

                                    @Override
                                    public void callback(Exception t) {
                                        JOptionPane.showMessageDialog(frame, "Fehler bein Abspielen des MP3 (" + entry.getMP3().getAbsolutePath() + "): " + t.getMessage());
                                    }
                                });
                            }
                            catch (FileNotFoundException ex) {
                                JOptionPane.showMessageDialog(frame, "Fehler bein Abspielen des MP3: Die Datei " + entry.getMP3().getAbsolutePath() + " wurde nicht gefunden");
                            }
                        } else if (entry.isCode()) {
                            try {
                                entry.getScript().execute();
                            }
                            catch (SyntaxError se) {
                                JOptionPane.showMessageDialog(frame, "Syntax Fehler (OID " + se.getTingID() + " Zeile " + se.getRow() + "): " + se.getMessage());
                            }
                        } else if (entry.isTTS()) {
                            try {
                                File tts = entry.getTTS().generateTTS(entry);
                                frame.setCurrentTrack(entry);
                                MP3Player.getPlayer().play(tts, new Callback<Exception>(){

                                    @Override
                                    public void callback(Exception t) {
                                        JOptionPane.showMessageDialog(frame, "Es ist ein Fehelr aufgetreten: " + t.getMessage());
                                    }
                                });
                                frame.setCurrentTrack(null);
                            }
                            catch (IOException ioe) {
                                JOptionPane.showMessageDialog(frame, "Es ist ein Fehelr aufgetreten: " + ioe.getMessage());
                            }
                        }
                        frame.setCurrentTrack(null);
                    }
                }.start();
            }
        });
        row.add(play);
        JButton eject = new JButton(this.getIcon(5));
        eject.setToolTipText("mp3 \u00e4ndern");
        eject.setMargin(new Insets(0, 0, 0, 0));
        if (entry.isMP3()) {
            eject.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    MP3Player.getPlayer().stop();
                    JFileChooser fc = new JFileChooser(lastChooseMp3DialogPath);
                    fc.setFileFilter(new FileNameExtensionFilter(IndexListEntry.MP3, IndexListEntry.MP3));
                    if (fc.showOpenDialog(frame) == 0) {
                        try {
                            File file = fc.getSelectedFile();
                            if (file.getParent() != null) {
                                lastChooseMp3DialogPath = file.getParent();
                            }
                            entry.setMP3(file);
                            IndexListEntry.this.trackInfo.setText(IndexListEntry.this.getTrackInfo(entry));
                        }
                        catch (FileNotFoundException ex) {
                            JOptionPane.showMessageDialog(frame, "Die Datei '" + fc.getSelectedFile() + "' konnte nicht gefunden werden.");
                            log.error("unable to find mp3", ex);
                        }
                        catch (IOException ex) {
                            JOptionPane.showMessageDialog(frame, "Die Datei '" + fc.getSelectedFile() + "' konnte nicht gelesen werden.");
                            log.error("unable to read mp3", ex);
                        }
                    }
                }
            });
        } else {
            eject.setEnabled(false);
        }
        row.add(eject);
        JButton compile = new JButton(this.getIcon(6));
        compile.setToolTipText("compilieren");
        compile.setMargin(new Insets(0, 0, 0, 0));
        if (entry.isCode() || entry.isSub()) {
            compile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    try {
                        entry.getScript().compile();
                        JOptionPane.showMessageDialog(frame, "Alles OK");
                    }
                    catch (SyntaxError se) {
                        JOptionPane.showMessageDialog(frame, "Syntax Fehler (OID " + se.getTingID() + " Zeile " + se.getRow() + "): " + se.getMessage());
                    }
                }
            });
        } else {
            compile.setEnabled(false);
        }
        row.add(compile);
        JButton savePattern = new JButton(this.getIcon(8));
        savePattern.setToolTipText("Code in Datei speichern");
        savePattern.setMargin(new Insets(0, 0, 0, 0));
        if ((entry.isCode() || entry.isMP3() || entry.isTTS()) && !unknownID) {
            savePattern.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    JFileChooser fc = new JFileChooser();
                    fc.setFileFilter(new FileNameExtensionFilter("Ting Pattern (*.png)", "png"));
                    if (fc.showSaveDialog(frame) == 0) {
                        try {
                            String file = fc.getSelectedFile().getCanonicalPath();
                            if (!file.toLowerCase().endsWith(".png")) {
                                file = file + ".png";
                            }
                            FileOutputStream out = new FileOutputStream(file);
                            int w = 30;
                            int h = 30;
                            Codes.drawPng(Translator.ting2code(entry.getTingID()), w, h, out);
                            out.close();
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(frame, "Das Ting Pattern konnte nicht gespeichert werden");
                            log.error("unable to save code", e);
                        }
                    }
                }
            });
        } else {
            savePattern.setEnabled(false);
        }
        row.add(savePattern);
        JButton copyPattern = new JButton(this.getIcon(9));
        copyPattern.setToolTipText("Code in die Zwischenablage kopieren");
        copyPattern.setMargin(new Insets(0, 0, 0, 0));
        if ((entry.isCode() || entry.isMP3() || entry.isTTS()) && !unknownID) {
            copyPattern.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    BufferedImage image = Codes.generateCodeImage(Translator.ting2code(entry.getTingID()), 30, 30);
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new ImageSelection(image), null);
                }
            });
        } else {
            copyPattern.setEnabled(false);
        }
        row.add(copyPattern);
        JButton saveMP3 = new JButton(this.getIcon(10));
        saveMP3.setToolTipText("MP3 speichern");
        saveMP3.setMargin(new Insets(0, 0, 0, 0));
        if (entry.isMP3() || entry.isTTS()) {
            saveMP3.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (entry.getMP3() == null) {
                        JOptionPane.showMessageDialog(frame, "kein MP3 zum speichern vorhanden");
                        return;
                    }
                    JFileChooser fc = new JFileChooser();
                    fc.setFileFilter(new FileNameExtensionFilter("MP3 (*.mp3)", IndexListEntry.MP3));
                    if (fc.showSaveDialog(frame) == 0) {
                        InputStream is = null;
                        OutputStream os = null;
                        try {
                            int length;
                            String file = fc.getSelectedFile().getCanonicalPath();
                            if (!file.toLowerCase().endsWith(".mp3")) {
                                file = file + ".mp3";
                            }
                            is = new FileInputStream(entry.getMP3());
                            os = new FileOutputStream(file);
                            byte[] buffer = new byte[1024];
                            while ((length = is.read(buffer)) > 0) {
                                os.write(buffer, 0, length);
                            }
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(frame, "MP3 konnte nicht gespeichert werden");
                            log.error("unable to save mp3", e);
                        }
                        finally {
                            try {
                                if (is != null) {
                                    is.close();
                                }
                            }
                            catch (IOException ex) {}
                            try {
                                if (os != null) {
                                    os.close();
                                }
                            }
                            catch (IOException ex) {}
                        }
                    }
                }
            });
        } else {
            saveMP3.setEnabled(false);
        }
        row.add(saveMP3);
        row.add(new JLabel("Code:"));
        row.add(this.codeCheckBox);
        this.codeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                entry.setHasCode(IndexListEntry.this.codeCheckBox.isSelected());
            }
        });
        if (entry.isSub()) {
            this.codeCheckBox.setEnabled(false);
        }
        if (entry.hasCode()) {
            this.codeCheckBox.setSelected(true);
        }
        row.add(new JLabel("Name:"));
        this.name.setPreferredSize(new Dimension(100, 20));
        row.add(this.name);
        this.name.setText(entry.getName());
        this.name.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                entry.setName(IndexListEntry.this.name.getText());
            }
        });
        this.trackInfo.setText(this.getTrackInfo(entry));
        row.add(this.trackInfo);
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)row, "West");
        header.add(p);
        header.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.add((Component)header, "North");
        this.hint.setRows(1);
        if (entry.isCode() || entry.isSub()) {
            this.hint.setText(entry.getScript().toString());
        } else if (entry.isTTS()) {
            this.hint.setText(entry.getTTS().text);
        } else if (entry.isMP3()) {
            this.hint.setText(entry.getHint());
        }
        this.hint.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent de) {
                this.changedUpdate(de);
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
                this.changedUpdate(de);
            }

            @Override
            public void changedUpdate(DocumentEvent de) {
                if (entry.isCode() || entry.isSub()) {
                    entry.getScript().setCode(IndexListEntry.this.hint.getText());
                } else if (entry.isTTS()) {
                    entry.getTTS().text = IndexListEntry.this.hint.getText();
                    entry.getTTS().invalidate(entry);
                } else if (entry.isMP3()) {
                    entry.setHint(IndexListEntry.this.hint.getText());
                }
            }
        });
        this.add((Component)this.hint, "Center");
    }

    public int getOID() {
        return this.entry.getTingID();
    }

    private String getTrackInfo(Entry entry) {
        if (entry.isMP3()) {
            int min = (int)entry.getLength() / 60;
            int sec = (int)entry.getLength() - min;
            String formatedTime = Integer.toString(sec);
            if (sec < 10) {
                formatedTime = "0" + formatedTime;
            }
            formatedTime = Integer.toString(min) + ":" + formatedTime;
            String trackName = "null";
            if (entry.getMP3() != null) {
                trackName = entry.getMP3().getName();
            } else {
                formatedTime = "-";
            }
            return trackName + " (" + formatedTime + ")";
        }
        return " ";
    }

    static class ImageSelection
    implements Transferable {
        private final Image image;

        public ImageSelection(Image image) {
            this.image = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!DataFlavor.imageFlavor.equals(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image;
        }
    }
}

