/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import tingeltangel.core.Book;
import tingeltangel.core.Entry;
import tingeltangel.core.MP3Player;
import tingeltangel.gui.EditorFrame;
import tingeltangel.gui.IDChooser;
import tingeltangel.gui.IndexListEntry;
import tingeltangel.gui.PushBorderLayout;
import tingeltangel.gui.RegisterPanel;
import tingeltangel.gui.StickPanel;
import tingeltangel.tools.Callback;
import tingeltangel.tools.FileEnvironment;
import tingeltangel.tools.Progress;
import tingeltangel.tools.ProgressDialog;

public final class EditorPanel
extends JPanel {
    private JTextField id = new JTextField();
    private JTextField name = new JTextField();
    private JTextField publisher = new JTextField();
    private JTextField author = new JTextField();
    private JTextField version = new JTextField();
    private JTextField url = new JTextField();
    private JTextField magicValue = new JTextField();
    private JTextField date = new JTextField();
    private final JScrollPane jScrollPane;
    private JLabel cover = null;
    private final int ICON_SKIP = 0;
    private final int ICON_STOP = 1;
    private final String[] ICONS = new String[]{"skip.png", "stop.png"};
    JTextField[] TEXT_FIELDS = new JTextField[]{this.id, this.name, this.publisher, this.author, this.version, this.url, this.magicValue, this.date};
    String[] TEXT_FIELD_LABELS = new String[]{"ID", "Name", "Verleger", "Autor", "Version", "URL", "?", "Datum"};
    private static final Logger log = LogManager.getLogger(EditorPanel.class);
    private final JTextField addEntriesCount;
    private final JTextField addEntriesStart;
    private final EditorFrame mainFrame;
    private final JLabel currentTrack = new JLabel();
    private final JPanel list = new JPanel();
    private DocumentListener dl;

    public Book getBook() {
        return this.mainFrame.getBook();
    }

    public JFrame getMainFrame() {
        return this.mainFrame;
    }

    public EditorPanel(final EditorFrame mainFrame) {
        this.mainFrame = mainFrame;
        Book book = mainFrame.getBook();
        JPanel right = new JPanel();
        right.setLayout(new PushBorderLayout());
        JPanel row = new JPanel();
        row.setLayout(new PushBorderLayout());
        this.addEntriesCount = new JTextField(3);
        this.addEntriesCount.setText("1");
        this.addEntriesStart = new JTextField(5);
        this.addEntriesStart.setText("15001");
        row.add((Component)this.addEntriesCount, (Object)PushBorderLayout.LINE_START);
        row.add((Component)new JLabel("Eintr\u00e4ge ab OID"), (Object)PushBorderLayout.LINE_START);
        row.add((Component)this.addEntriesStart, (Object)PushBorderLayout.LINE_START);
        JButton addEntriesButton = new JButton("hinzuf\u00fcgen");
        addEntriesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int i;
                int count;
                int oid;
                String _oid = EditorPanel.this.addEntriesStart.getText().trim();
                String _count = EditorPanel.this.addEntriesCount.getText().trim();
                try {
                    oid = Integer.parseInt(_oid);
                    if (oid < 15001 || oid >= 65536) {
                        JOptionPane.showMessageDialog(mainFrame, "ung\u00fcltige OID angegeben (15001 bis 65535)");
                        return;
                    }
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog(mainFrame, "ung\u00fcltige OID angegeben (15001 bis 65535)");
                    return;
                }
                try {
                    count = Integer.parseInt(_count);
                    if (count < 1 || count >= 1000) {
                        JOptionPane.showMessageDialog(mainFrame, "ung\u00fcltige Anzahl angegeben (1-999)");
                        return;
                    }
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog(mainFrame, "ung\u00fcltige Anzahl angegeben (1-999)");
                    return;
                }
                int lastOid = oid + count - 1;
                if (lastOid >= 65536) {
                    JOptionPane.showMessageDialog(mainFrame, "ung\u00fcltiges OID Interval angegeben (max 65535)");
                    return;
                }
                for (i = oid; i <= lastOid; ++i) {
                    if (!mainFrame.getBook().entryForTingIDExists(i)) continue;
                    JOptionPane.showMessageDialog(mainFrame, "OID " + i + " schon belegt");
                    return;
                }
                for (i = oid; i <= lastOid; ++i) {
                    mainFrame.getBook().addEntry(i);
                    int rowNr = EditorPanel.this.getPositionInIndex(i);
                    EditorPanel.this.list.add((Component)new IndexListEntry(mainFrame.getBook().getEntryByOID(i), EditorPanel.this), rowNr);
                }
                new Thread(){

                    @Override
                    public void run() {
                        EditorPanel.this.list.revalidate();
                        EditorPanel.this.list.repaint();
                    }
                }.start();
            }
        });
        row.add((Component)addEntriesButton, (Object)PushBorderLayout.LINE_START);
        right.add((Component)row, (Object)PushBorderLayout.PAGE_START);
        right.add(PushBorderLayout.pad(10), (Object)PushBorderLayout.PAGE_START);
        row = new JPanel();
        row.setLayout(new PushBorderLayout());
        JButton skip = new JButton(this.getIcon(0));
        skip.setToolTipText("MP3 \u00fcberspringen");
        skip.setMargin(new Insets(0, 0, 0, 0));
        skip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MP3Player.getPlayer().stop();
            }
        });
        row.add((Component)skip, (Object)PushBorderLayout.LINE_START);
        row.add(PushBorderLayout.pad(5), (Object)PushBorderLayout.LINE_START);
        JButton stop = new JButton(this.getIcon(1));
        stop.setToolTipText("Ausgabe abbrechen");
        stop.setMargin(new Insets(0, 0, 0, 0));
        stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                EditorPanel.this.stopTrack();
            }
        });
        row.add((Component)stop, (Object)PushBorderLayout.LINE_START);
        row.add(PushBorderLayout.pad(5), (Object)PushBorderLayout.LINE_START);
        row.add((Component)new JLabel("Track:"), (Object)PushBorderLayout.LINE_START);
        row.add(PushBorderLayout.pad(5), (Object)PushBorderLayout.LINE_START);
        row.add((Component)this.currentTrack, (Object)PushBorderLayout.LINE_START);
        right.add((Component)row, (Object)PushBorderLayout.PAGE_START);
        right.add(PushBorderLayout.pad(10), (Object)PushBorderLayout.PAGE_START);
        row = new JPanel();
        JPanel labels = new JPanel();
        labels.setLayout(new GridLayout(this.TEXT_FIELD_LABELS.length, 1));
        for (int i = 0; i < this.TEXT_FIELD_LABELS.length; ++i) {
            labels.add(new JLabel(this.TEXT_FIELD_LABELS[i] + ":"));
        }
        JPanel fields = new JPanel();
        fields.setLayout(new GridLayout(this.TEXT_FIELDS.length, 1));
        for (int i = 0; i < this.TEXT_FIELDS.length; ++i) {
            fields.add(this.TEXT_FIELDS[i]);
        }
        row.setLayout(new BorderLayout());
        row.add((Component)labels, "West");
        row.add((Component)fields, "Center");
        row.add((Component)new JLabel("Bucheigenschaften"), "North");
        right.add((Component)row, (Object)PushBorderLayout.PAGE_START);
        right.add(PushBorderLayout.pad(10), (Object)PushBorderLayout.PAGE_START);
        this.cover = new JLabel("Cover kann nicht geladen werden");
        try {
            File coverImage = book.getCover();
            this.cover = coverImage.exists() ? new JLabel(new ImageIcon(ImageIO.read(coverImage))) : new JLabel(new ImageIcon(ImageIO.read(this.getClass().getResource("/noCover.png"))));
        }
        catch (IOException ioe) {
            // empty catch block
        }
        this.cover.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                EditorPanel.this.loadCover();
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        right.add((Component)this.cover, (Object)PushBorderLayout.PAGE_START);
        right.add(PushBorderLayout.pad(10), (Object)PushBorderLayout.PAGE_START);
        right.add((Component)new JLabel("Stift"), (Object)PushBorderLayout.PAGE_START);
        right.add((Component)new StickPanel(mainFrame), (Object)PushBorderLayout.PAGE_START);
        right.add(PushBorderLayout.pad(10), (Object)PushBorderLayout.PAGE_START);
        right.add((Component)new JLabel("Register"), (Object)PushBorderLayout.PAGE_START);
        RegisterPanel registerPanel = new RegisterPanel(mainFrame);
        this.getBook().addRegisterListener(registerPanel);
        right.add((Component)registerPanel, (Object)PushBorderLayout.CENTER);
        this.list.setLayout(new BoxLayout(this.list, 1));
        this.setLayout(new BorderLayout());
        this.jScrollPane = new JScrollPane(this.list);
        this.jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.add((Component)this.jScrollPane, "Center");
        this.add((Component)right, "East");
        this.updateList(null);
        this.id.setText(Integer.toString(book.getID()));
        this.name.setText(book.getName());
        this.publisher.setText(book.getPublisher());
        this.author.setText(book.getAuthor());
        this.version.setText(Integer.toString(book.getVersion()));
        this.url.setText(book.getUrl());
        this.magicValue.setText(Long.toString(book.getMagicValue()));
        this.date.setText(new SimpleDateFormat("dd.MM.yyyy").format(new Date(book.getDate() * 1000L)));
        this.id.setEditable(false);
        this.date.setEditable(false);
        this.id.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                IDChooser ic = new IDChooser((Frame)mainFrame, new Callback<Integer>(){

                    @Override
                    public void callback(final Integer id) {
                        String _id = Integer.toString(id);
                        while (_id.length() < 5) {
                            _id = "0" + _id;
                        }
                        if (new File(FileEnvironment.getBooksDirectory(), _id).exists()) {
                            JOptionPane.showMessageDialog(mainFrame, "Dieses Buch existiert schon");
                            return;
                        }
                        Progress pr = new Progress(mainFrame, "\u00e4ndere mid"){

                            @Override
                            public void action(ProgressDialog progressDialog) {
                                try {
                                    Book book = mainFrame.getBook();
                                    int oldID = book.getID();
                                    book.setID(id);
                                    book.save();
                                    progressDialog.restart("kopiere mp3s");
                                    File[] audios = FileEnvironment.getAudioDirectory(oldID).listFiles(new FilenameFilter(){

                                        @Override
                                        public boolean accept(File dir, String name) {
                                            return name.toLowerCase().endsWith(".mp3");
                                        }
                                    });
                                    progressDialog.setMax(audios.length);
                                    File destAudioDir = FileEnvironment.getAudioDirectory(id);
                                    for (int i = 0; i < audios.length; ++i) {
                                        progressDialog.setVal(i);
                                        FileEnvironment.copy(audios[i], new File(destAudioDir, audios[i].getName()));
                                    }
                                    book.clear();
                                    book.setID(id);
                                    Book.loadXML(FileEnvironment.getXML(id), book, progressDialog);
                                    progressDialog.restart("aktualisiere Liste");
                                    EditorPanel.this.refresh();
                                    EditorPanel.this.updateList(progressDialog);
                                    book.resetChangeMade();
                                    mainFrame.setBookOpened();
                                    book.deleteBook(oldID);
                                }
                                catch (Exception ioe) {
                                    ioe.printStackTrace();
                                    JOptionPane.showMessageDialog(mainFrame, "Es ist ein Fehler aufgetreten: " + ioe.getMessage());
                                }
                            }
                        };
                    }
                });
            }
        });
        this.dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                EditorPanel.this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EditorPanel.this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                EditorPanel.this.update();
            }
        };
        this.enableListeners(true);
    }

    public void stopTrack() {
        String tid = this.currentTrack.getText();
        if (tid != null && !tid.isEmpty()) {
            Entry entry = this.mainFrame.getBook().getEntryByOID(Integer.parseInt(tid));
            if (entry.isCode()) {
                entry.getScript().kill();
            }
            if (entry.isMP3() || entry.isTTS() || entry.isCode()) {
                MP3Player.getPlayer().stop();
            }
        }
    }

    public int getScrollX() {
        return this.jScrollPane.getViewport().getViewPosition().x;
    }

    public int getScrollY() {
        return this.jScrollPane.getViewport().getViewPosition().y;
    }

    private ImageIcon getIcon(int res) {
        try {
            return new ImageIcon(ImageIO.read(this.getClass().getResource("/icons/" + this.ICONS[res])));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public int getPositionInIndex(int oid) {
        int rowNr = -1;
        for (int i = 0; i < this.list.getComponentCount(); ++i) {
            int ioid = ((IndexListEntry)this.list.getComponent(i)).getOID();
            if (ioid <= oid) continue;
            rowNr = i;
            break;
        }
        if (rowNr < 0) {
            return this.list.getComponentCount();
        }
        return rowNr;
    }

    public int getPositionInIndex(IndexListEntry entry) {
        int rowNr = -1;
        for (int i = 0; i < this.list.getComponentCount(); ++i) {
            if (this.list.getComponent(i) != entry) continue;
            rowNr = i;
            break;
        }
        if (rowNr < 0) {
            throw new Error();
        }
        return rowNr;
    }

    JPanel getListPanel() {
        return this.list;
    }

    private void enableListeners(boolean enable) {
        for (int i = 0; i < this.TEXT_FIELDS.length; ++i) {
            if (enable) {
                this.TEXT_FIELDS[i].getDocument().addDocumentListener(this.dl);
                continue;
            }
            this.TEXT_FIELDS[i].getDocument().removeDocumentListener(this.dl);
        }
    }

    public void refresh() {
        this.enableListeners(false);
        Book book = this.mainFrame.getBook();
        this.id.setText(Integer.toString(book.getID()));
        this.name.setText(book.getName());
        this.publisher.setText(book.getPublisher());
        this.author.setText(book.getAuthor());
        this.version.setText(Integer.toString(book.getVersion()));
        this.url.setText(book.getUrl());
        this.magicValue.setText(Long.toString(book.getMagicValue()));
        this.date.setText(new SimpleDateFormat("dd.MM.yyyy").format(new Date(book.getDate() * 1000L)));
        try {
            File coverImage = book.getCover();
            if (coverImage.exists()) {
                this.cover.setIcon(new ImageIcon(ImageIO.read(coverImage)));
            } else {
                this.cover.setIcon(new ImageIcon(ImageIO.read(this.getClass().getResource("/noCover.png"))));
            }
        }
        catch (IOException ioe) {
            this.cover.setText("Cover kann nicht geladen werden");
        }
        this.enableListeners(true);
    }

    public void update() {
        Book book = this.mainFrame.getBook();
        book.setName(this.name.getText());
        book.setPublisher(this.publisher.getText());
        book.setAuthor(this.author.getText());
        try {
            book.setVersion(Integer.parseInt(this.version.getText()));
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        book.setURL(this.url.getText());
        try {
            book.setMagicValue(Long.parseLong(this.magicValue.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void updateList(ProgressDialog progress) {
        Book book = this.mainFrame.getBook();
        this.list.removeAll();
        if (progress != null) {
            progress.setMax(book.getSize());
        }
        for (int i = 0; i < book.getSize(); ++i) {
            if (progress != null) {
                progress.setVal(i);
            }
            this.list.add(new IndexListEntry(book.getEntry(i), this));
        }
        if (progress != null) {
            progress.done();
        }
        Dimension size = this.mainFrame.getSize();
        this.mainFrame.pack();
        this.mainFrame.setSize(size);
    }

    void setCurrentTrack(Entry entry) {
        if (entry == null) {
            this.currentTrack.setText(null);
        } else {
            this.currentTrack.setText(Integer.toString(entry.getTingID()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadCover() {
        block10: {
            JFileChooser fc = new JFileChooser();
            fc.setFileFilter(new FileNameExtensionFilter("PNG Coverbild (140px \u00d7 193px) (*.png)", "png"));
            if (fc.showOpenDialog(this) == 0) {
                try {
                    File file = fc.getSelectedFile();
                    if (file.exists()) {
                        FileInputStream input = null;
                        OutputStream output = null;
                        try {
                            int bytesRead;
                            input = new FileInputStream(file);
                            output = new FileOutputStream(this.mainFrame.getBook().getCover());
                            byte[] buf = new byte[1024];
                            while ((bytesRead = ((InputStream)input).read(buf)) > 0) {
                                output.write(buf, 0, bytesRead);
                            }
                            break block10;
                        }
                        finally {
                            if (input != null) {
                                ((InputStream)input).close();
                            }
                            if (output != null) {
                                output.close();
                            }
                        }
                    }
                    JOptionPane.showMessageDialog(this, "Das Cover konnte nicht gefunden werden");
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "Das Cover konnte nicht geladen werden");
                    log.error("unable to load cover", e);
                }
            }
        }
        this.refresh();
    }
}

