/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.cli_ng;

import java.io.File;
import java.util.HashMap;
import tingeltangel.cli_ng.CLI;
import tingeltangel.cli_ng.CliCmd;
import tingeltangel.core.Book;
import tingeltangel.core.Importer;
import tingeltangel.core.Repository;
import tingeltangel.tools.FileEnvironment;

class ImportFromRepository
extends CliCmd {
    ImportFromRepository() {
    }

    @Override
    public String getName() {
        return "import-from-repository";
    }

    @Override
    public String getDescription() {
        return "import-from-repository <mid>";
    }

    @Override
    public int execute(String[] args) {
        try {
            int mid;
            if (args.length != 1) {
                return this.error("falsche Anzahl von Parametern");
            }
            try {
                mid = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                return this.error("keine Zahl (1-9999) als Parameter angegeben");
            }
            if (mid < 1 || mid > 9999) {
                return this.error("ung\u00fcltige MID angegeben (1-9999)");
            }
            String _mid = Integer.toString(mid);
            while (_mid.length() < 5) {
                _mid = "0" + _mid;
            }
            if (new File(FileEnvironment.getBooksDirectory(), _mid).exists()) {
                return this.error("Dieses Buch existiert schon");
            }
            if (!Repository.exists(mid)) {
                return this.error("Das Buch wurde nicht gefunden");
            }
            Book book = CLI.getBook();
            book.setID(mid);
            book.clear();
            File ouf = Repository.getBookOuf(mid);
            HashMap<String, String> txt = Repository.getBookTxt(mid);
            File src = Repository.getBookSrc(mid);
            File png = Repository.getBookPng(mid);
            Importer.importBook(ouf, txt, src, png, book, null);
        }
        catch (Exception ex) {
            return this.error("das Buch konnte nicht gelesen werden", ex);
        }
        return this.ok();
    }
}

