/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.cli.cmds;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tingeltangel.cli.CliCommand;
import tingeltangel.cli.CliSwitch;
import tingeltangel.core.Repository;
import tingeltangel.core.Stick;

public class UpdateStick
extends CliCommand {
    @Override
    public String getName() {
        return "update-stick";
    }

    @Override
    public String getDescription() {
        return "aktualisiert einen Ting-Stift";
    }

    @Override
    public Map<String, CliSwitch> getSwitches() {
        return new HashMap<String, CliSwitch>();
    }

    @Override
    public void execute(Map<String, String> args) throws Exception {
        Stick stick = Stick.getStick();
        if (stick == null) {
            System.err.println("no stick found");
            System.exit(1);
        }
        HashSet<Integer> _tbds = stick.getTBD();
        LinkedList<Integer> _books = stick.getBooks();
        _tbds.addAll(_books);
        HashSet<Integer> remove = new HashSet<Integer>();
        remove.addAll(_tbds);
        for (int mid : _tbds) {
            if (mid <= 0 || mid > 9999) continue;
            System.out.println("repository: update mid " + mid);
            try {
                if (!Repository.txtExists(mid)) {
                    Repository.search(mid);
                }
                Repository.update(mid, null);
                int repositoryVersion = -1;
                try {
                    repositoryVersion = Integer.parseInt(Repository.getBookTxt(mid).get("Book Version"));
                }
                catch (Exception e) {
                    System.err.println("update von " + mid + " fehlgeschlagen:");
                    e.printStackTrace(System.err);
                }
                if (repositoryVersion >= 0) {
                    int stickVersion = stick.getBookVersion(mid);
                    if (stickVersion >= 0) {
                        if (repositoryVersion > stickVersion) {
                            System.err.println("auf den stift kopieren...");
                            stick.copyFromRepositoryToStick(mid);
                            remove.remove(mid);
                        }
                    } else {
                        System.err.println("zugriff auf den stift " + mid + " fehlgeschlagen");
                    }
                }
                System.out.println("repository: update mid " + mid + " fertig");
            }
            catch (FileNotFoundException fnfe) {
                System.err.println("ignoriere buch " + mid);
            }
        }
        Iterator<Integer> mids = remove.iterator();
        String tbd = "";
        while (mids.hasNext()) {
            String mid = Integer.toString(mids.next());
            while (mid.length() < 5) {
                mid = "0" + mid;
            }
            mid = mid + "\r\n";
            tbd = tbd + mid;
        }
        FileOutputStream out = new FileOutputStream(stick.getTBDFile());
        ((OutputStream)out).write(tbd.getBytes());
        out.flush();
        ((OutputStream)out).close();
        System.out.println("stick update ist fertig");
        System.exit(0);
    }

    public static void main(String[] args) {
        try {
            new UpdateStick().execute(null);
        }
        catch (Exception ex) {
            Logger.getLogger(UpdateStick.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

