/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import tingeltangel.tools.OS;

public class FileEnvironment {
    private static boolean test = false;

    public static void test() {
        test = true;
    }

    public static File getHomeDirectory() {
        return new File(System.getProperty("user.home"));
    }

    public static File getBooksDirectory() {
        if (test) {
            return FileEnvironment.getWorkingDirectory("books-test");
        }
        return FileEnvironment.getWorkingDirectory("books");
    }

    public static File getBookDirectory(int id) {
        String _id = Integer.toString(id);
        while (_id.length() < 5) {
            _id = "0" + _id;
        }
        File bd = new File(FileEnvironment.getBooksDirectory(), _id);
        if (bd.exists()) {
            if (!bd.isDirectory()) {
                throw new Error(bd.getAbsolutePath() + " exists but is not a directory");
            }
        } else if (!bd.mkdirs()) {
            throw new Error("can't create directory " + bd.getAbsolutePath());
        }
        return bd;
    }

    public static File getRepositoryDirectory() {
        return FileEnvironment.getWorkingDirectory("repository");
    }

    public static File getAudioDirectory(int id) {
        return FileEnvironment.getBookSubDirectory(id, "audio");
    }

    public static File getDistDirectory(int id) {
        return FileEnvironment.getBookSubDirectory(id, "dist");
    }

    public static File getBinDirectory(int id) {
        return FileEnvironment.getBookSubDirectory(id, "bin");
    }

    public static File getCodesDirectory(int id) {
        return FileEnvironment.getBookSubDirectory(id, "codes");
    }

    public static File getPagesDirectory(int id) {
        return FileEnvironment.getBookSubDirectory(id, "pages");
    }

    public static File getBinObjectFile(int mid, int oid) {
        return new File(FileEnvironment.getBinDirectory(mid), Integer.toString(oid) + ".bin");
    }

    private static File getBookSubDirectory(int id, String subDirectory) {
        File codes = new File(FileEnvironment.getBookDirectory(id), subDirectory);
        if (codes.exists()) {
            if (!codes.isDirectory()) {
                throw new Error(codes.getAbsolutePath() + " exists but is not a directory");
            }
        } else if (!codes.mkdirs()) {
            throw new Error("can't create directory " + codes.getAbsolutePath());
        }
        return codes;
    }

    public static File getXML(int id) {
        return new File(FileEnvironment.getBookDirectory(id), "book.xml");
    }

    private static File getWorkingDirectory(String subDirectory) {
        File wd = new File(FileEnvironment.getWorkingDirectoryRoot(), subDirectory);
        if (wd.exists()) {
            if (!wd.isDirectory()) {
                throw new Error(wd.getAbsolutePath() + " exists but is not a directory");
            }
        } else if (!wd.mkdirs()) {
            throw new Error("can't create directory " + wd.getAbsolutePath());
        }
        return wd;
    }

    public static File getWorkingDirectoryRoot() {
        File wd = null;
        if (OS.isWindows()) {
            String myDocuments = null;
            try {
                Process p = Runtime.getRuntime().exec("reg query \"HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders\" /v personal");
                p.waitFor();
                InputStream in = p.getInputStream();
                byte[] b = new byte[in.available()];
                in.read(b);
                in.close();
                myDocuments = new String(b);
                myDocuments = myDocuments.split("\\s\\s+")[4];
            }
            catch (Exception e) {
                myDocuments = ".";
            }
            wd = new File(myDocuments, "tingeltangel");
        } else {
            wd = new File(FileEnvironment.getHomeDirectory(), ".tingeltangel");
        }
        if (wd.exists()) {
            if (!wd.isDirectory()) {
                throw new Error(wd.getAbsolutePath() + " exists but is not a directory");
            }
        } else if (!wd.mkdirs()) {
            throw new Error("can't create directory " + wd.getAbsolutePath());
        }
        return wd;
    }

    public static void copy(File source, File destination) throws IOException {
        FileChannel sourceChannel = null;
        FileOutputStream fout = null;
        try {
            sourceChannel = new FileInputStream(source).getChannel();
            fout = new FileOutputStream(destination);
            FileChannel destChannel = fout.getChannel();
            destChannel.transferFrom(sourceChannel, 0L, sourceChannel.size());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            if (sourceChannel != null) {
                sourceChannel.close();
            }
            if (fout != null) {
                fout.close();
            }
        }
    }
}

