/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.core.scripting;

import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import tingeltangel.core.scripting.Command;
import tingeltangel.core.scripting.Emulator;

public class Instance {
    private final Command command;
    private int label = -1;
    private int firstArgument = 0;
    private int secondArgument = 0;
    public static final int NO_ACTION = 0;
    public static final int JUMP = 1;

    public Instance(Command command) {
        this.command = command;
    }

    public int execute(Emulator emulator) {
        Method method = this.command.getMethod();
        try {
            if (this.command.firstArgumentIsLabel()) {
                if (((Boolean)method.invoke(null, emulator, this.firstArgument, this.secondArgument)).booleanValue()) {
                    return 1;
                }
                return 0;
            }
            method.invoke(null, emulator, this.firstArgument, this.secondArgument);
            return 0;
        }
        catch (IllegalAccessException ex) {
            throw new Error(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new Error(ex);
        }
        catch (InvocationTargetException ex) {
            throw new Error(ex);
        }
    }

    public int getFirstArgument() {
        if (this.command.getNumberOfArguments() < 1) {
            throw new Error();
        }
        return this.firstArgument;
    }

    public int getSecondArgument() {
        if (this.command.getNumberOfArguments() < 2) {
            throw new Error();
        }
        return this.secondArgument;
    }

    private int removeRegister(String s) {
        if (s.startsWith("v") || s.startsWith("V")) {
            s = s.substring(1);
        } else if (s.startsWith("0x")) {
            return Integer.parseInt(s.substring(2), 16);
        }
        return Integer.parseInt(s);
    }

    public void setFirstArgument(String argument) {
        if (this.command.getNumberOfArguments() < 1) {
            throw new Error();
        }
        this.firstArgument = this.removeRegister(argument);
    }

    public void setSecondArgument(String argument) {
        if (this.command.getNumberOfArguments() < 2) {
            throw new Error();
        }
        this.secondArgument = this.removeRegister(argument);
    }

    public String toString(Emulator emulator) {
        String s = this.command.getAsm();
        if (this.command.getNumberOfArguments() > 0) {
            s = this.command.firstArgumentIsRegister() ? s + " v" + this.getFirstArgument() + "(" + emulator.getRegister(this.getFirstArgument()) + ")" : (this.command.firstArgumentIsLabel() ? s + " " + this.getLabel() : s + " " + this.getFirstArgument());
        }
        if (this.command.getNumberOfArguments() > 1) {
            s = this.command.secondArgumentIsRegister() ? s + " v" + this.getSecondArgument() + "(" + emulator.getRegister(this.getSecondArgument()) + ")" : s + " " + this.getSecondArgument();
        }
        return s;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setLabel(int label) {
        this.label = label;
    }

    public int getLabel() {
        return this.label;
    }

    public void compile(DataOutputStream out) throws IOException {
        out.writeShort(this.command.getCode());
        if (this.command.firstArgumentIsLabel()) {
            out.writeShort(this.label);
        } else {
            if (this.command.getNumberOfArguments() > 0) {
                out.writeShort(this.firstArgument);
            }
            if (this.command.getNumberOfArguments() > 1) {
                out.writeShort(this.secondArgument);
            }
        }
    }
}

