/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.core;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import tingeltangel.core.Translator;

public class Codes {
    private static final int[] PNG_DOT_SIZE = new int[]{1, 2};
    private static final int[] PNG_DELTA_SIZE = new int[]{1, 2};
    private static final int[] PNG_DELTA_X_SIZE = new int[]{1, 2};
    private static final int[] PNG_BLOCK_SIZE = new int[]{6, 12};
    private static final float[] PNG_PIXEL_PER_MM = new float[]{23.62205f, 47.24409f};
    public static final int DPI600 = 0;
    public static final int DPI1200 = 1;
    private static final int[] A4_WIDTH = new int[]{4880, 9760};
    private static final int[] A4_HEIGHT = new int[]{6680, 13360};
    private static int resolution = 1;

    public static void setResolution(int resolution) {
        Codes.resolution = resolution;
    }

    public static int getResolution() {
        return resolution;
    }

    private static int[] getDotPosFromInt(int i) {
        int[] f = new int[2];
        switch (i) {
            case 0: {
                f[0] = 1;
                f[1] = -1;
                return f;
            }
            case 1: {
                f[0] = -1;
                f[1] = -1;
                return f;
            }
            case 2: {
                f[0] = -1;
                f[1] = 1;
                return f;
            }
            case 3: {
                f[0] = 1;
                f[1] = 1;
                return f;
            }
        }
        throw new Error();
    }

    private static int getPari(int w7, int w6, int w5, int w4, int w3, int w2, int w1, int w0) {
        int c1 = ((w1 ^ w4 ^ w6 ^ w7) & 1) << 1;
        int c2 = (w0 ^ w2 ^ w3 ^ w5) & 1;
        return c1 | c2;
    }

    private static int[][][] getPatternFromInt(int i) {
        int w0 = i & 3;
        int w1 = i >> 2 & 3;
        int w2 = i >> 4 & 3;
        int w3 = i >> 6 & 3;
        int w4 = i >> 8 & 3;
        int w5 = i >> 10 & 3;
        int w6 = i >> 12 & 3;
        int w7 = i >> 14 & 3;
        int[][][] pattern = new int[][][]{new int[][]{{0, 0}, {0, 0}, {0, 0}, {0, 0}}, new int[][]{{0, 0}, Codes.getDotPosFromInt(Codes.getPari(w7, w6, w5, w4, w3, w2, w1, w0)), Codes.getDotPosFromInt(w7), Codes.getDotPosFromInt(w6)}, new int[][]{{1, 0}, Codes.getDotPosFromInt(w5), Codes.getDotPosFromInt(w4), Codes.getDotPosFromInt(w3)}, new int[][]{{0, 0}, Codes.getDotPosFromInt(w2), Codes.getDotPosFromInt(w1), Codes.getDotPosFromInt(w0)}};
        return pattern;
    }

    private static void drawPattern(int code, int x, int y, int width, int height, Graphics2D graphics) {
        int[][][] pattern = Codes.getPatternFromInt(code);
        for (int ix = 0; ix < width; ++ix) {
            for (int iy = 0; iy < height; ++iy) {
                for (int dx = 0; dx < 4; ++dx) {
                    int mx = ix * 4 * PNG_BLOCK_SIZE[resolution] + dx * PNG_BLOCK_SIZE[resolution] + PNG_BLOCK_SIZE[resolution] / 2;
                    for (int dy = 0; dy < 4; ++dy) {
                        int py;
                        int px;
                        int my = iy * 4 * PNG_BLOCK_SIZE[resolution] + dy * PNG_BLOCK_SIZE[resolution] + PNG_BLOCK_SIZE[resolution] / 2;
                        if (pattern[dy][dx][1] == 0 && pattern[dy][dx][0] > 0) {
                            px = mx + pattern[dy][dx][0] * PNG_DELTA_X_SIZE[resolution];
                            py = my;
                        } else {
                            px = mx + pattern[dy][dx][0] * PNG_DELTA_SIZE[resolution];
                            py = my - pattern[dy][dx][1] * PNG_DELTA_SIZE[resolution];
                        }
                        graphics.fillRect(px + x, py + y, PNG_DOT_SIZE[resolution], PNG_DOT_SIZE[resolution]);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePng(BufferedImage image, OutputStream out) throws IOException {
        Iterator<ImageWriter> iw = ImageIO.getImageWritersByFormatName("PNG");
        while (iw.hasNext()) {
            ImageWriter writer = iw.next();
            ImageWriteParam writeParam = writer.getDefaultWriteParam();
            ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
            IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
            if (metadata.isReadOnly() || !metadata.isStandardMetadataFormatSupported()) continue;
            double dotsPerMilli = PNG_PIXEL_PER_MM[resolution];
            IIOMetadataNode horiz = new IIOMetadataNode("HorizontalPixelSize");
            horiz.setAttribute("value", Double.toString(dotsPerMilli));
            IIOMetadataNode vert = new IIOMetadataNode("VerticalPixelSize");
            vert.setAttribute("value", Double.toString(dotsPerMilli));
            IIOMetadataNode dim = new IIOMetadataNode("Dimension");
            dim.appendChild(horiz);
            dim.appendChild(vert);
            IIOMetadataNode root = new IIOMetadataNode("javax_imageio_1.0");
            root.appendChild(dim);
            metadata.mergeTree("javax_imageio_1.0", root);
            ImageOutputStream stream = ImageIO.createImageOutputStream(out);
            try {
                writer.setOutput(stream);
                writer.write(metadata, new IIOImage(image, null, metadata), writeParam);
                break;
            }
            finally {
                stream.close();
            }
        }
    }

    public static BufferedImage generateCodeImage(int code, int width, int height) {
        width = (int)((float)width * PNG_PIXEL_PER_MM[resolution]);
        height = (int)((float)height * PNG_PIXEL_PER_MM[resolution]);
        int imageWidth = (width /= 4 * PNG_BLOCK_SIZE[resolution]) * 4 * PNG_BLOCK_SIZE[resolution];
        int imageHeight = (height /= 4 * PNG_BLOCK_SIZE[resolution]) * 4 * PNG_BLOCK_SIZE[resolution];
        BufferedImage image = new BufferedImage(imageWidth, imageHeight, 2);
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, imageWidth, imageHeight);
        graphics.setColor(Color.black);
        Codes.drawPattern(code, 0, 0, width, height, graphics);
        return image;
    }

    public static void drawPng(int code, int width, int height, OutputStream out) throws IOException {
        Codes.writePng(Codes.generateCodeImage(code, width, height), out);
    }

    public static void drawPagePNG(int[] tingCodes, int patternWidthInMM, int patternHeightInMM, OutputStream out) throws IOException {
        int patternWidth = (int)((float)patternWidthInMM * PNG_PIXEL_PER_MM[resolution] / (float)(4 * PNG_BLOCK_SIZE[resolution])) * 4 * PNG_BLOCK_SIZE[resolution];
        int patternHeight = (int)((float)patternHeightInMM * PNG_PIXEL_PER_MM[resolution] / (float)(4 * PNG_BLOCK_SIZE[resolution])) * 4 * PNG_BLOCK_SIZE[resolution];
        int space = (int)(PNG_PIXEL_PER_MM[resolution] * 4.0f);
        int textSpace = (int)(PNG_PIXEL_PER_MM[resolution] * 2.0f);
        int cx = (A4_WIDTH[resolution] - space) / (patternWidth + space);
        int cy = (A4_HEIGHT[resolution] - space) / (patternHeight + space + textSpace);
        BufferedImage image = new BufferedImage(A4_WIDTH[resolution], A4_HEIGHT[resolution], 2);
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, A4_WIDTH[resolution], A4_HEIGHT[resolution]);
        graphics.setColor(Color.black);
        graphics.setFont(graphics.getFont().deriveFont(35.0f));
        int p = 0;
        for (int y = 0; y < cy; ++y) {
            for (int x = 0; x < cx; ++x) {
                int tc;
                if (p >= tingCodes.length || (tc = Translator.ting2code(tingCodes[p++])) < 0) continue;
                int px = x * (patternWidth + space) + space;
                int py = y * (patternHeight + space + textSpace) + space;
                int pw = patternWidth / (PNG_BLOCK_SIZE[resolution] * 4);
                int ph = patternHeight / (PNG_BLOCK_SIZE[resolution] * 4);
                Codes.drawPattern(tingCodes[p - 1], px, py, pw, ph, graphics);
                graphics.drawString(Integer.toString(tingCodes[p - 1]), px, py + patternHeight + textSpace);
            }
        }
        Codes.writePng(image, out);
    }

    public static void drawPagePNG(int start, OutputStream out) throws IOException {
        BufferedImage image = new BufferedImage(A4_WIDTH[resolution], A4_HEIGHT[resolution], 2);
        int f = 1;
        if (resolution == 1) {
            f = 2;
        }
        int cx = 25;
        int cy = 40;
        int dx = 350;
        int dy = 210;
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, A4_WIDTH[resolution], A4_HEIGHT[resolution]);
        graphics.setColor(Color.black);
        graphics.setFont(graphics.getFont().deriveFont(35.0f));
        graphics.drawString("Ting IDs ab " + Integer.toString(start), (5 + dx) * f, 150 * f);
        graphics.setFont(graphics.getFont().deriveFont(25.0f));
        for (int y = 0; y < cy; ++y) {
            for (int x = 0; x < cx; ++x) {
                int tc;
                if (start >= 65536 || (tc = Translator.ting2code(start++)) < 0) continue;
                Codes.drawPattern(tc, (x * 170 + dx) * f, (y * 155 + dy) * f, 4 * f, 4 * f, graphics);
                graphics.drawString(Integer.toString(start - 1), (x * 170 + 5 + dx) * f, (y * 155 + 130 + dy) * f);
            }
        }
        Codes.writePng(image, out);
    }
}

