/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.cli.cmds;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Map;
import tingeltangel.cli.CliCommand;
import tingeltangel.cli.CliSwitch;
import tingeltangel.core.Book;
import tingeltangel.core.ReadYamlFile;

public class Assemble
extends CliCommand {
    @Override
    public String getName() {
        return "assemble";
    }

    @Override
    public String getDescription() {
        return "Erstellt aus einer yaml-Datei eine ouf-Datei.";
    }

    @Override
    public Map<String, CliSwitch> getSwitches() {
        CliSwitch[] list = new CliSwitch[]{new CliSwitch(){

            @Override
            public String getName() {
                return "i";
            }

            @Override
            public String getDescription() {
                return "setzt den Namen der Eingabedatei";
            }

            @Override
            public boolean hasArgument() {
                return true;
            }

            @Override
            public boolean isOptional() {
                return false;
            }

            @Override
            public String getLabel() {
                return "Eingabedatei";
            }

            @Override
            public String getDefault() {
                return null;
            }

            @Override
            public boolean acceptValue(String value) {
                return !value.isEmpty();
            }
        }};
        return this.list2map(list);
    }

    @Override
    public void execute(Map<String, String> args) throws Exception {
        File inputFile = new File(args.get("i"));
        if (inputFile.canRead()) {
            ReadYamlFile ryf = new ReadYamlFile();
            Book book = ryf.read(inputFile, null);
            book.export(new File("."), null);
            File scriptcodesFile = new File(inputFile.getName().replace(".yaml", ".codes.yaml"));
            PrintStream out = new PrintStream(new FileOutputStream(scriptcodesFile));
            out.println("scriptcodes:");
            for (Integer oid : ryf.getUsedOidAndIdentifiers().keySet()) {
                String identifier = ryf.getUsedOidAndIdentifiers().get(oid);
                if (identifier == null) continue;
                out.println("   " + identifier + ": " + oid);
            }
            out.close();
        } else {
            System.err.println("Fehler beim Lesen der Eingabedatei.");
        }
    }
}

