/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel;

import java.io.IOException;
import javax.swing.SwingUtilities;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import tingeltangel.cli_ng.CLI;
import tingeltangel.core.Codes;
import tingeltangel.core.Properties;
import tingeltangel.core.Repository;
import tingeltangel.gui.EditorFrame;
import tingeltangel.gui.ManagerFrame;

public class Tingeltangel {
    public static int MAIN_FRAME_POS_X = 50;
    public static int MAIN_FRAME_POS_Y = 50;
    public static int MAIN_FRAME_WIDTH = 1200;
    public static int MAIN_FRAME_HEIGHT = 700;
    public static String MAIN_FRAME_TITLE = "Tingeltangel";
    public static String MAIN_FRAME_VERSION = " v0.3";
    public static final String BASE_URL = "http://system.ting.eu/book-files";
    public static final String DEFAULT_AREA_CODE = "en";
    private static final Logger log = LogManager.getLogger(Tingeltangel.class);

    public static void main(String[] args) throws Exception {
        log.info("Starting Tingeltangel" + MAIN_FRAME_VERSION);
        log.info("\tos.name     : " + System.getProperty("os.name"));
        log.info("\tos.version  : " + System.getProperty("os.version"));
        log.info("\tos.arch     : " + System.getProperty("os.arch"));
        log.info("\tjava.version: " + System.getProperty("java.version"));
        log.info("\tjava.vendor : " + System.getProperty("java.vendor"));
        boolean startEditor = false;
        boolean startManager = false;
        if (args.length > 0 && args[0].toLowerCase().equals("gui-editor")) {
            startEditor = true;
        }
        if (args.length > 0 && args[0].toLowerCase().equals("gui-manager")) {
            startManager = true;
        }
        if (Properties.getStringProperty("resolution").equals("1200")) {
            Codes.setResolution(1);
        } else {
            Codes.setResolution(0);
        }
        final boolean _startEditor = startEditor;
        if (startManager || startEditor) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (Repository.getIDs().length == 0) {
                        try {
                            Repository.initialUpdate(new Thread(){

                                @Override
                                public void run() {
                                    Tingeltangel.startGUI(_startEditor);
                                }
                            });
                        }
                        catch (IOException ex) {
                            log.warn("initial update failed", ex);
                            Tingeltangel.startGUI(_startEditor);
                        }
                    } else {
                        Tingeltangel.startGUI(_startEditor);
                    }
                }
            });
        } else if (args.length > 0 && args[0].toLowerCase().equals("cli")) {
            CLI.init();
            CLI.run();
        } else if (args.length == 0) {
            CLI.init();
            CLI.run();
        } else if (!tingeltangel.cli.CLI.cli(args)) {
            log.warn("starting cli failed");
        }
    }

    private static void startGUI(boolean startEditor) {
        if (startEditor) {
            new EditorFrame();
        } else {
            new ManagerFrame();
        }
    }
}

