/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEventListener;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;
import org.apache.logging.log4j.core.config.xml.XmlConfigurationFactory;
import org.apache.logging.log4j.core.net.server.LogEventBridge;
import org.apache.logging.log4j.core.util.Assert;

public abstract class AbstractSocketServer<T extends InputStream>
extends LogEventListener
implements Runnable {
    protected static final int MAX_PORT = 65534;
    private volatile boolean active = true;
    protected final LogEventBridge<T> logEventInput;
    protected final Logger logger;

    public AbstractSocketServer(int port, LogEventBridge<T> logEventInput) {
        this.logger = LogManager.getLogger(this.getClass().getName() + '.' + port);
        this.logEventInput = Assert.requireNonNull(logEventInput, "LogEventInput");
    }

    protected boolean isActive() {
        return this.active;
    }

    protected void setActive(boolean isActive) {
        this.active = isActive;
    }

    public Thread startNewThread() {
        Thread thread = new Thread(this);
        thread.start();
        return thread;
    }

    protected static class ServerConfigurationFactory
    extends XmlConfigurationFactory {
        private final String path;

        public ServerConfigurationFactory(String path) {
            this.path = path;
        }

        @Override
        public Configuration getConfiguration(String name, URI configLocation) {
            if (this.path != null && this.path.length() > 0) {
                File file = null;
                ConfigurationSource source = null;
                try {
                    file = new File(this.path);
                    FileInputStream is = new FileInputStream(file);
                    source = new ConfigurationSource((InputStream)is, file);
                }
                catch (FileNotFoundException ex) {
                    // empty catch block
                }
                if (source == null) {
                    try {
                        URL url = new URL(this.path);
                        source = new ConfigurationSource(url.openStream(), url);
                    }
                    catch (MalformedURLException mue) {
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                try {
                    if (source != null) {
                        return new XmlConfiguration(source);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                System.err.println("Unable to process configuration at " + this.path + ", using default.");
            }
            return super.getConfiguration(name, configLocation);
        }
    }
}

