/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.wimmelbuch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import tingeltangel.core.Book;
import tingeltangel.core.Entry;
import tingeltangel.core.ForeignImporter;
import tingeltangel.core.Script;
import tingeltangel.core.TTSEntry;
import tingeltangel.tools.FileEnvironment;
import tingeltangel.tools.Permutate;
import tingeltangel.wimmelbuch.Constraint;
import tingeltangel.wimmelbuch.Event;
import tingeltangel.wimmelbuch.Item;

public class Wimmelbuch
implements ForeignImporter {
    private final HashSet<Event> events = new HashSet();
    private final HashSet<Item> items = new HashSet();
    private final HashSet<Constraint> constraints = new HashSet();
    static final int MAX_QUEUE_SIZE = 6;

    private void addItem(Item item) {
        this.items.add(item);
    }

    private void addEvent(Event event) {
        this.events.add(event);
    }

    private void generate(Book book, boolean useLocking, int startOID) throws Exception {
        Entry entry;
        int tid;
        this.constraints.clear();
        Iterator<Event> iEvents = this.events.iterator();
        int audioCounter = 0;
        while (iEvents.hasNext()) {
            Event event = iEvents.next();
            this.constraints.addAll(event.getAllConstraints());
            event.setAudioTrack(audioCounter++);
            for (Item item : event.getItems()) {
                item.addEvent(event);
            }
        }
        Iterator<Constraint> iConstraints = this.constraints.iterator();
        int registerCounter = 0;
        int bitCounter = 0;
        while (iConstraints.hasNext()) {
            Constraint constraint = iConstraints.next();
            constraint.setRegister(registerCounter);
            constraint.setBit(bitCounter);
            if (++bitCounter != 16) continue;
            bitCounter = 0;
            ++registerCounter;
        }
        Iterator<Item> iItems = this.items.iterator();
        while (iItems.hasNext()) {
            iItems.next().setAudioTrack(audioCounter++);
        }
        for (Item item : this.items) {
            tid = item.getAudioTrack() + startOID;
            book.addEntry(tid);
            entry = book.getEntryByOID(tid);
            entry.setTTS(new TTSEntry(item.getTTS()));
        }
        for (Event event : this.events) {
            tid = event.getAudioTrack() + startOID;
            book.addEntry(tid);
            entry = book.getEntryByOID(tid);
            entry.setTTS(new TTSEntry(event.getTTS()));
        }
        int[] reg_item_queue = new int[6];
        for (int i = 0; i < 6; ++i) {
            reg_item_queue[i] = i;
        }
        int reg_i = 6;
        int usedRegisters = 7;
        for (Item item : this.items) {
            int i;
            StringBuilder sb = new StringBuilder();
            sb.append("// wimmelbuch item ").append(item.getName()).append("\n");
            if (useLocking) {
                sb.append("lock\n");
            }
            for (i = 0; i < reg_item_queue.length; ++i) {
                sb.append("cmp v95,v").append(reg_item_queue[i]).append("\n");
                sb.append("je queue_remove_").append(i).append("\n");
            }
            sb.append("jmp insert\n");
            for (i = 0; i < reg_item_queue.length; ++i) {
                sb.append(":queue_remove_").append(i).append("\n");
                for (int k = i + 1; k < reg_item_queue.length; ++k) {
                    sb.append("set v").append(reg_item_queue[k - 1]).append(",v").append(reg_item_queue[k]).append("\n");
                }
                sb.append("set v").append(reg_item_queue[reg_item_queue.length - 1]).append(",0\n");
                sb.append("jmp insert\n");
            }
            sb.append(":insert\n");
            for (int k = reg_item_queue.length - 1; k > 0; --k) {
                sb.append("set v").append(reg_item_queue[k]).append(",v").append(reg_item_queue[k - 1]).append("\n");
            }
            sb.append("set v").append(reg_item_queue[0]).append(",v95\n");
            iEvents = item.getEvents().iterator();
            while (iEvents.hasNext()) {
                sb.append("// event\n");
                Event event = iEvents.next();
                Item[][] eventItems = new Item[1][event.getItems().size()];
                Iterator<Item> iEventItems = event.getItems().iterator();
                for (int c = 0; c < eventItems[0].length; ++c) {
                    eventItems[0][c] = iEventItems.next();
                }
                if (event.getMode() == 1) {
                    eventItems = this.permutations(eventItems[0]);
                    LinkedList<Item[]> il = new LinkedList<Item[]>();
                    for (int p = 0; p < eventItems.length; ++p) {
                        if (eventItems[p][0] != item) continue;
                        il.add(eventItems[p]);
                    }
                    eventItems = (Item[][])il.toArray((T[])new Item[0][eventItems[0].length]);
                }
                for (int p = 0; p < eventItems.length; ++p) {
                    for (int i2 = 0; i2 < eventItems[p].length; ++i2) {
                        sb.append("cmp v").append(reg_item_queue[i2]).append(",").append(eventItems[p][i2].getID()).append("\n");
                        sb.append("jne not_match_").append(event.getAudioTrack()).append("_").append(p).append("\n");
                    }
                    sb.append("jmp match_").append(event.getAudioTrack()).append("\n");
                    sb.append(":not_match_").append(event.getAudioTrack()).append("_").append(p).append("\n");
                }
                sb.append("jmp not_match_").append(event.getAudioTrack()).append("\n");
                sb.append(":match_").append(event.getAudioTrack()).append("\n");
                for (Constraint c : event.getSetConstraints()) {
                    sb.append("getbit v").append(reg_i).append(",v").append(c.getRegister() + usedRegisters).append(",v").append(c.getBit()).append("\n");
                    sb.append("cmp v").append(reg_i).append(",0\n");
                    sb.append("je not_match_").append(event.getAudioTrack()).append("\n");
                }
                for (Constraint c : event.getUnsetConstraints()) {
                    sb.append("getbit v").append(reg_i).append(",v").append(c.getRegister() + usedRegisters).append(",v").append(c.getBit()).append("\n");
                    sb.append("cmp v").append(reg_i).append(",1\n");
                    sb.append("je not_match_").append(event.getAudioTrack()).append("\n");
                }
                for (Constraint c : event.getResultingSetConstraints()) {
                    sb.append("setbit v").append(c.getRegister() + usedRegisters).append(",v").append(c.getBit()).append("\n");
                }
                for (Constraint c : event.getResultingUnsetConstraints()) {
                    sb.append("unsetbit v").append(c.getRegister() + usedRegisters).append(",v").append(c.getBit()).append("\n");
                }
                sb.append("playoid ").append(event.getAudioTrack() + startOID).append("\n");
                if (event.clearQueueAfterEvent()) {
                    for (int i3 = 0; i3 < reg_item_queue.length; ++i3) {
                        sb.append("set v").append(reg_item_queue[i3]).append(",0\n");
                    }
                }
                if (useLocking) {
                    sb.append("unlock\n");
                }
                sb.append("end\n");
                sb.append(":not_match_").append(event.getAudioTrack()).append("\n");
            }
            sb.append("playoid ").append(item.getAudioTrack() + startOID).append("\n");
            if (useLocking) {
                sb.append("unlock\n");
            }
            sb.append("end\n");
            book.addEntry(item.getID());
            Entry entry2 = book.getEntryByOID(item.getID());
            entry2.setScript(new Script(sb.toString(), entry2));
            entry2.setHasCode(true);
            entry2.setName(item.getName());
        }
    }

    private int fak(int n) {
        if (n == 1) {
            return 1;
        }
        return n * this.fak(n - 1);
    }

    private Item[][] permutations(Item[] itemA) throws Exception {
        if (itemA.length == 0) {
            throw new Exception("event with no item found");
        }
        Item[][] r4 = new Item[this.fak(itemA.length)][itemA.length];
        Iterator<int[]> i = Permutate.perms(itemA.length);
        int p = 0;
        while (i.hasNext()) {
            int[] a = i.next();
            for (int q = 0; q < a.length; ++q) {
                r4[p][q] = itemA[a[q]];
            }
            ++p;
        }
        return r4;
    }

    @Override
    public void importBook(Book book, File file) throws Exception {
        int p;
        String row;
        File audioDir = FileEnvironment.getAudioDirectory(book.getID());
        if (audioDir.exists()) {
            File[] tracks = audioDir.listFiles();
            for (int i = 0; i < tracks.length; ++i) {
                if (!tracks[i].isFile()) continue;
                tracks[i].delete();
            }
        }
        BufferedReader in = new BufferedReader(new FileReader(file));
        int n = 0;
        int mid = 0;
        String name = "unknown";
        String publisher = "unknown";
        String author = "unknown";
        int version = 1;
        String url = "";
        boolean use_locking = true;
        int start_generated_oids = 20000;
        LinkedList<String> itemDefs = new LinkedList<String>();
        LinkedList<String> eventDefs = new LinkedList<String>();
        while ((row = in.readLine()) != null) {
            ++n;
            if ((row = row.trim()).isEmpty() || row.startsWith("//")) continue;
            int p2 = row.indexOf(":");
            String cmd = row.substring(0, p2).trim().toLowerCase();
            String args = row.substring(p2 + 1).trim();
            if (cmd.equals("mid")) {
                mid = Integer.parseInt(args);
                continue;
            }
            if (cmd.equals("name")) {
                name = args;
                continue;
            }
            if (cmd.equals("publisher")) {
                publisher = args;
                continue;
            }
            if (cmd.equals("author")) {
                author = args;
                continue;
            }
            if (cmd.equals("version")) {
                version = Integer.parseInt(args);
                continue;
            }
            if (cmd.equals("url")) {
                url = args;
                continue;
            }
            if (cmd.equals("use-locking")) {
                use_locking = Boolean.parseBoolean(args);
                continue;
            }
            if (cmd.equals("start-generated-oids")) {
                start_generated_oids = Integer.parseInt(args);
                continue;
            }
            if (cmd.equals("item")) {
                itemDefs.add(args);
                continue;
            }
            if (cmd.equals("event")) {
                eventDefs.add(args);
                continue;
            }
            throw new Exception("unknown argument: " + cmd + " on row " + n);
        }
        in.close();
        if (mid <= 0 || mid >= 10000) {
            throw new Exception("bad mid given");
        }
        book.clear();
        book.setID(mid);
        book.setName(name);
        book.setPublisher(publisher);
        book.setAuthor(author);
        book.setVersion(version);
        book.setURL(url);
        HashMap<String, Item> _items = new HashMap<String, Item>();
        HashMap<String, Constraint> _constr = new HashMap<String, Constraint>();
        for (String ide : itemDefs) {
            p = ide.indexOf(":");
            int oid = Integer.parseInt(ide.substring(0, p).trim());
            ide = ide.substring(p + 1).trim();
            p = ide.indexOf(":");
            String iName = ide.substring(0, p).trim().toLowerCase();
            String tts = ide.substring(p + 1).trim();
            Item item = new Item(oid, iName, tts);
            _items.put(iName, item);
            this.addItem(item);
        }
        for (String ide : eventDefs) {
            Constraint c;
            boolean not;
            String ins;
            int i;
            p = ide.indexOf(":");
            String queue = ide.substring(0, p).trim().toLowerCase();
            ide = ide.substring(p + 1).trim();
            p = ide.indexOf(":");
            String constr = ide.substring(0, p).trim().toLowerCase();
            ide = ide.substring(p + 1).trim();
            p = ide.indexOf(":");
            String resConstr = ide.substring(0, p).trim().toLowerCase();
            String tts = ide.substring(p + 1).trim();
            boolean permutate = false;
            if (queue.startsWith("*")) {
                permutate = true;
                queue = queue.substring(1).trim();
            }
            Event event = new Event(tts);
            String[] q = queue.split(",");
            for (i = 0; i < q.length; ++i) {
                ins = q[i].trim();
                if (ins.isEmpty()) continue;
                event.addItem((Item)_items.get(q[i].trim()));
                if (permutate) {
                    event.setMode(1);
                    continue;
                }
                event.setMode(0);
            }
            q = constr.split(",");
            for (i = 0; i < q.length; ++i) {
                ins = q[i].trim();
                if (ins.isEmpty()) continue;
                not = false;
                if (ins.startsWith("!")) {
                    not = true;
                    ins = ins.substring(1).trim();
                }
                if (!_constr.containsKey(ins)) {
                    _constr.put(ins, new Constraint());
                }
                c = (Constraint)_constr.get(ins);
                if (!not) {
                    event.addSetConstraint(c);
                    continue;
                }
                event.addUnsetConstraint(c);
            }
            q = resConstr.split(",");
            for (i = 0; i < q.length; ++i) {
                ins = q[i].trim();
                if (ins.isEmpty()) continue;
                if (ins.equals("clear")) {
                    event.setClearQueueAfterEvent();
                    continue;
                }
                not = false;
                if (ins.startsWith("!")) {
                    not = true;
                    ins = ins.substring(1).trim();
                }
                if (!_constr.containsKey(ins)) {
                    _constr.put(ins, new Constraint());
                }
                c = (Constraint)_constr.get(ins);
                if (!not) {
                    event.addResultingSetConstraint(c);
                    continue;
                }
                event.addResultingUnsetConstraint(c);
            }
            this.addEvent(event);
        }
        this.generate(book, use_locking, start_generated_oids);
        book.save();
    }
}

