/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.cli_ng;

import java.io.File;
import java.io.IOException;
import tingeltangel.cli_ng.CLI;
import tingeltangel.cli_ng.CliCmd;
import tingeltangel.tools.FileEnvironment;

class ExportMp3
extends CliCmd {
    ExportMp3() {
    }

    @Override
    String getName() {
        return "export-mp3 <oid> <mp3 file>";
    }

    @Override
    String getDescription() {
        return "export-mp3 <oid>";
    }

    @Override
    int execute(String[] args) {
        int oid;
        if (args.length != 2) {
            return this.error("falsche Anzahl von Parametern");
        }
        try {
            oid = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            return this.error("OID keine Zahl zw. 15001 und 65535");
        }
        File mp3File = new File(args[1]);
        if (!mp3File.canWrite()) {
            return this.error("angebebene MP3-Datei ist nicht lesbar");
        }
        if (!CLI.bookOpened()) {
            return this.error("kein Buch ge\u00f6ffnet");
        }
        if (!CLI.getBook().entryForTingIDExists(oid)) {
            return this.error("OID nicht gefunden");
        }
        if (!CLI.getBook().getEntryByOID(oid).isMP3()) {
            return this.error("OID ist nicht vom Typ MP3");
        }
        File audioFile = CLI.getBook().getEntryByOID(oid).getMP3();
        if (audioFile == null) {
            return this.error("OID enth\u00e4lt kein MP3");
        }
        try {
            FileEnvironment.copy(audioFile, mp3File);
        }
        catch (IOException ex) {
            return this.error("MP3 konnte nicht extrahiert werden", ex);
        }
        return this.ok();
    }
}

