/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.cli.cmds;

import java.io.File;
import java.util.Map;
import tingeltangel.cli.CliCommand;
import tingeltangel.cli.CliSwitch;
import tingeltangel.core.Importer;

public class ExportTrack
extends CliCommand {
    @Override
    public String getName() {
        return "export-track";
    }

    @Override
    public String getDescription() {
        return "exportiert einen einzelnen Track als MP3 oder Bin\u00e4rdatei";
    }

    @Override
    public Map<String, CliSwitch> getSwitches() {
        CliSwitch[] list = new CliSwitch[]{new CliSwitch(){

            @Override
            public String getName() {
                return "t";
            }

            @Override
            public String getLabel() {
                return "OID";
            }

            @Override
            public String getDescription() {
                return "Track ID (OID)";
            }

            @Override
            public boolean isOptional() {
                return false;
            }

            @Override
            public boolean hasArgument() {
                return true;
            }

            @Override
            public String getDefault() {
                return null;
            }

            @Override
            public boolean acceptValue(String value) {
                int id = Integer.parseInt(value);
                return id > 15000;
            }
        }, new CliSwitch(){

            @Override
            public String getName() {
                return "b";
            }

            @Override
            public String getLabel() {
                return "Book";
            }

            @Override
            public String getDescription() {
                return "ouf-Datei";
            }

            @Override
            public boolean isOptional() {
                return false;
            }

            @Override
            public boolean hasArgument() {
                return true;
            }

            @Override
            public String getDefault() {
                return null;
            }

            @Override
            public boolean acceptValue(String value) {
                File f = new File(value);
                return f.canRead() && f.isFile();
            }
        }, new CliSwitch(){

            @Override
            public String getName() {
                return "o";
            }

            @Override
            public String getLabel() {
                return "Ausgabedatei";
            }

            @Override
            public String getDescription() {
                return "Ausgabedatei";
            }

            @Override
            public boolean isOptional() {
                return false;
            }

            @Override
            public boolean hasArgument() {
                return true;
            }

            @Override
            public String getDefault() {
                return null;
            }

            @Override
            public boolean acceptValue(String value) {
                File file = new File(value);
                if (!file.getParentFile().isDirectory()) {
                    return false;
                }
                return !file.exists() || file.canWrite();
            }
        }};
        return this.list2map(list);
    }

    @Override
    public void execute(Map<String, String> args) throws Exception {
        File ouf = new File(args.get("b"));
        int oid = Integer.parseInt(args.get("t"));
        File file = new File(args.get("o"));
        Importer.extractTrack(ouf, oid, file);
    }
}

