/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import tingeltangel.Tingeltangel;
import tingeltangel.core.Repository;
import tingeltangel.core.Stick;
import tingeltangel.gui.PushBorderLayout;
import tingeltangel.tools.Callback;
import tingeltangel.tools.Progress;
import tingeltangel.tools.ProgressDialog;

public class ManagerFrame
extends JFrame {
    private static final Logger log = LogManager.getLogger(ManagerFrame.class);
    private final JPanel centerPanel = new JPanel();
    private final JLabel statusLabel = new JLabel("kein Stift gefunden");
    private boolean online = false;

    public ManagerFrame() {
        super(Tingeltangel.MAIN_FRAME_TITLE + Tingeltangel.MAIN_FRAME_VERSION);
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.setBounds(Tingeltangel.MAIN_FRAME_POS_X, Tingeltangel.MAIN_FRAME_POS_Y, Tingeltangel.MAIN_FRAME_WIDTH + this.getInsets().left + this.getInsets().right, Tingeltangel.MAIN_FRAME_HEIGHT + this.getInsets().top + this.getInsets().bottom);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.setContentPane(this.getPanel());
        this.centerPanel.setLayout(new PushBorderLayout());
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    Stick stick = Stick.getStick();
                    if (ManagerFrame.this.online && stick == null) {
                        ManagerFrame.this.online = false;
                        ManagerFrame.this.statusLabel.setText("keinen Stift gefunden");
                        ManagerFrame.this.centerPanel.removeAll();
                    } else if (!ManagerFrame.this.online && stick != null) {
                        ManagerFrame.this.online = true;
                        ManagerFrame.this.goOnline();
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        scheduler.scheduleAtFixedRate(task, 3L, 3L, TimeUnit.SECONDS);
        this.setVisible(true);
    }

    private void updateList() throws IOException {
        Stick stick = Stick.getStick();
        Iterator ids = stick.getBooks().iterator();
        this.centerPanel.removeAll();
        boolean first = true;
        while (ids.hasNext()) {
            int id = (Integer)ids.next();
            if (first) {
                first = false;
            } else {
                this.centerPanel.add(PushBorderLayout.pad(10), (Object)PushBorderLayout.PAGE_START);
            }
            this.centerPanel.add((Component)this.getBookPanel(id), (Object)PushBorderLayout.PAGE_START);
        }
        this.validate();
        this.repaint();
    }

    private void goOnline() {
        this.statusLabel.setText("Stift gefunden");
        try {
            this.updateList();
        }
        catch (IOException ioe) {
            log.warn("Stick konnte nicht ge\u00f6ffnet werden", ioe);
            JOptionPane.showMessageDialog(this, "Stick konnte nicht ge\u00f6ffnet werden");
        }
    }

    private JPanel getBookPanel(final int mid) throws IOException {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        HashMap<String, String> bookTxt = Repository.getBookTxt(mid);
        File coverImage = Repository.getBookPng(mid);
        try {
            if (coverImage != null && coverImage.exists()) {
                panel.add((Component)new JLabel(new ImageIcon(ImageIO.read(coverImage))), "West");
            } else {
                panel.add((Component)new JLabel(new ImageIcon(ImageIO.read(this.getClass().getResource("/noCover.png")))), "West");
            }
        }
        catch (IOException ioe) {
            log.warn("unable to load cover (mid=" + mid + ")", ioe);
        }
        JPanel actionPanel = new JPanel();
        actionPanel.setLayout(new PushBorderLayout());
        actionPanel.add(PushBorderLayout.pad(10), (Object)PushBorderLayout.PAGE_START);
        this.addButton(actionPanel, "aktualisieren", new Callback<Object>(){

            @Override
            public void callback(Object t) {
                if (!Repository.txtExists(mid)) {
                    Repository.search(mid);
                }
                if (!Repository.txtExists(mid)) {
                    log.warn("book " + mid + " not found in repository");
                    JOptionPane.showMessageDialog(ManagerFrame.this, "Das Buch wurde im Repository nicht gefunden");
                } else {
                    Progress progress = new Progress(ManagerFrame.this, "Buch aktualisieren"){

                        @Override
                        public void action(ProgressDialog progressDialog) {
                            try {
                                Repository.update(mid, progressDialog);
                                Stick.getStick().copyFromRepositoryToStick(mid);
                                ManagerFrame.this.updateList();
                            }
                            catch (IOException ioe) {
                                log.warn("book " + mid + " update failed", ioe);
                                JOptionPane.showMessageDialog(ManagerFrame.this, "Das Buch konnte nicht aktualisiert werden");
                            }
                        }
                    };
                }
            }
        });
        actionPanel.add(PushBorderLayout.pad(10), (Object)PushBorderLayout.PAGE_START);
        this.addButton(actionPanel, "l\u00f6schen", new Callback<Object>(){

            @Override
            public void callback(Object t) {
                try {
                    Stick.getStick().delete(mid);
                    ManagerFrame.this.updateList();
                }
                catch (IOException ioe) {
                    log.warn("book " + mid + " delete failed", ioe);
                    JOptionPane.showMessageDialog(ManagerFrame.this, "Das Buch konnte nicht gel\u00f6scht werden werden");
                }
            }
        });
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new PushBorderLayout());
        infoPanel.add(PushBorderLayout.pad(10), (Object)PushBorderLayout.LINE_START);
        infoPanel.add((Component)actionPanel, (Object)PushBorderLayout.LINE_START);
        infoPanel.add(PushBorderLayout.pad(10), (Object)PushBorderLayout.LINE_START);
        if (bookTxt == null) {
            infoPanel.add((Component)new JLabel("keine Informationen vorhanden"), (Object)PushBorderLayout.PAGE_START);
        } else {
            JLabel title = new JLabel(bookTxt.get("Name"));
            Font f = title.getFont();
            title.setFont(f.deriveFont(f.getSize2D() + 5.0f));
            infoPanel.add((Component)title, (Object)PushBorderLayout.PAGE_START);
            infoPanel.add((Component)new JLabel("Autor: " + bookTxt.get("Author")), (Object)PushBorderLayout.PAGE_START);
            infoPanel.add((Component)new JLabel("Verlag: " + bookTxt.get("Publisher")), (Object)PushBorderLayout.PAGE_START);
            infoPanel.add((Component)new JLabel("URL: " + bookTxt.get("URL")), (Object)PushBorderLayout.PAGE_START);
            infoPanel.add((Component)new JLabel("Version: " + bookTxt.get("Book Version")), (Object)PushBorderLayout.PAGE_START);
        }
        panel.add((Component)infoPanel, "Center");
        return panel;
    }

    private JPanel getPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.statusLabel, "North");
        panel.add((Component)new JScrollPane(this.centerPanel), "Center");
        panel.add((Component)this.getRightPanel(), "East");
        return panel;
    }

    private JPanel getRightPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new PushBorderLayout());
        this.addButton(panel, "Stift aktualisieren", new Callback<Object>(){

            @Override
            public void callback(Object t) {
                Stick stick;
                try {
                    stick = Stick.getStick();
                    if (stick == null) {
                        log.warn("no stick found");
                        JOptionPane.showMessageDialog(ManagerFrame.this, "kein Stift gefunden");
                        return;
                    }
                }
                catch (IOException ioe) {
                    log.warn("failed to access stick", ioe);
                    JOptionPane.showMessageDialog(ManagerFrame.this, "Auf den Stift kann nicht zugegriffen werden");
                    return;
                }
                final Stick _stick = stick;
                Progress pr = new Progress(ManagerFrame.this, "Stift aktualisieren"){

                    @Override
                    public void action(ProgressDialog progressDialog) {
                        if (_stick.update(ManagerFrame.this, progressDialog)) {
                            try {
                                ManagerFrame.this.updateList();
                            }
                            catch (IOException ioe) {
                                log.warn("failed to update book list", ioe);
                            }
                            JOptionPane.showMessageDialog(ManagerFrame.this, "Aktualisierung erfolgreich");
                        } else {
                            JOptionPane.showMessageDialog(ManagerFrame.this, "Aktualisierung fehlgeschlagen");
                        }
                    }
                };
            }
        });
        this.addButton(panel, "Neue B\u00fccher suchen", new Callback<Object>(){

            @Override
            public void callback(Object t) {
                Progress pr = new Progress(ManagerFrame.this, "neue B\u00fccher suchen"){

                    @Override
                    public void action(ProgressDialog progressDialog) {
                        Repository.search(progressDialog);
                        JOptionPane.showMessageDialog(ManagerFrame.this, "Update erfolgreich");
                    }
                };
            }
        });
        this.addButton(panel, "Repository aktualisieren", new Callback<Object>(){

            @Override
            public void callback(Object t) {
                Progress pr = new Progress(ManagerFrame.this, "Repository aktualisieren"){

                    @Override
                    public void action(ProgressDialog progressDialog) {
                        try {
                            Repository.update(progressDialog);
                            JOptionPane.showMessageDialog(ManagerFrame.this, "Aktualisierung erfolgreich");
                        }
                        catch (IOException ex) {
                            log.warn("Repository.update error", ex);
                            JOptionPane.showMessageDialog(ManagerFrame.this, "Es ist ein Fehler aufgetreten");
                        }
                    }
                };
            }
        });
        return panel;
    }

    private void addButton(JPanel panel, String label, final Callback<Object> callback) {
        JButton button = new JButton(label);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                callback.callback(null);
            }
        });
        panel.add((Component)button, (Object)PushBorderLayout.PAGE_START);
    }
}

