/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.core.scripting;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class Constants {
    private final HashMap<String, String> constants = new HashMap();
    private final LinkedList<String> keys = new LinkedList();

    public String get(String name) {
        return this.constants.get(name);
    }

    public void set(String name, String value) {
        if (!this.constants.containsKey(name)) {
            this.keys.add(name);
        }
        this.constants.put(name, value);
    }

    public void setUsedKeys(Set<String> usedKeys) {
        for (String key : usedKeys) {
            if (this.constants.containsKey(key)) continue;
            this.set(key, "");
        }
    }

    public void unset(String name) {
        this.constants.remove(name);
    }

    public Set<String> getNames() {
        return this.constants.keySet();
    }

    public static Constants loadFromString(String def) {
        Constants v = new Constants();
        String[] defs = def.split(";");
        for (int i = 0; i < defs.length; ++i) {
            int p = defs[i].indexOf("=");
            v.set(defs[i].substring(0, p), defs[i].substring(p + 1));
        }
        return v;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        Iterator<String> keys = this.constants.keySet().iterator();
        while (keys.hasNext()) {
            if (s.length() > 0) {
                s.append(";");
            }
            String key = keys.next();
            s.append(key).append("=").append(this.constants.get(key));
        }
        return s.toString();
    }

    public String getNameAt(int i) {
        return this.keys.get(i);
    }

    public void changeName(int i, String newName) {
        String oldName = this.getNameAt(i);
        this.keys.set(i, newName);
        String value = this.get(oldName);
        this.unset(oldName);
        this.constants.put(newName, value);
    }
}

