/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.cli.cmds;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import tingeltangel.cli.CliCommand;
import tingeltangel.cli.CliSwitch;
import tingeltangel.core.Book;
import tingeltangel.core.Codes;
import tingeltangel.core.ReadYamlFile;
import tingeltangel.core.Translator;

public class OidCode
extends CliCommand {
    @Override
    public String getName() {
        return "oid-code";
    }

    @Override
    public String getDescription() {
        return "Erstellt zu einer yaml-Datei passende OID-Codes.";
    }

    @Override
    public Map<String, CliSwitch> getSwitches() {
        CliSwitch[] list = new CliSwitch[]{new CliSwitch(){

            @Override
            public String getName() {
                return "i";
            }

            @Override
            public String getDescription() {
                return "setzt den Namen der Eingabedatei";
            }

            @Override
            public boolean hasArgument() {
                return true;
            }

            @Override
            public boolean isOptional() {
                return false;
            }

            @Override
            public String getLabel() {
                return "Eingabedatei";
            }

            @Override
            public String getDefault() {
                return null;
            }

            @Override
            public boolean acceptValue(String value) {
                return !value.isEmpty();
            }
        }};
        return this.list2map(list);
    }

    @Override
    public void execute(Map<String, String> args) throws Exception {
        File inputFile = new File(args.get("i"));
        if (inputFile.canRead()) {
            Codes.setResolution(1);
            ReadYamlFile ryf = new ReadYamlFile();
            Book book = ryf.read(inputFile, null);
            this.generateImage(book.getID(), book, "START");
            for (Integer oid : ryf.getUsedOidAndIdentifiers().keySet()) {
                String identifier = ryf.getUsedOidAndIdentifiers().get(oid);
                if (identifier == null) {
                    this.generateImage(oid, book, oid.toString());
                    continue;
                }
                this.generateImage(oid, book, identifier);
            }
        } else {
            System.err.println("Fehler beim Lesen der Eingabedatei.");
        }
    }

    private void generateImage(int oid, Book book, String name) throws IOException {
        int codeID = Translator.ting2code(oid);
        String filename = "oid-" + book.getID() + "-" + name + ".png";
        System.out.println("Writing " + filename + "...");
        FileOutputStream out = new FileOutputStream(filename);
        Codes.drawPng(codeID, 102, 102, out);
        ((OutputStream)out).close();
    }
}

