/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.cli_ng;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import tingeltangel.cli_ng.CLI;
import tingeltangel.cli_ng.CliCmd;
import tingeltangel.core.Book;
import tingeltangel.core.Stick;
import tingeltangel.core.scripting.SyntaxError;
import tingeltangel.tools.FileEnvironment;

class Deploy
extends CliCmd {
    Deploy() {
    }

    @Override
    String getName() {
        return "deploy";
    }

    @Override
    String getDescription() {
        return "deploy";
    }

    @Override
    int execute(String[] args) {
        try {
            Stick stick = Stick.getStick();
            if (stick == null) {
                return this.error("kein Stift gefunden");
            }
            if (!CLI.bookOpened()) {
                return this.error("kein Buch ge\u00f6ffnet");
            }
            Book book = CLI.getBook();
            book.generateTTS(null);
            book.export(FileEnvironment.getDistDirectory(book.getID()), null);
            File dest = stick.getBookDir();
            if (!dest.getAbsolutePath().contains("$ting")) {
                dest = new File(stick.getBookDir(), "$ting");
            }
            File[] files = FileEnvironment.getDistDirectory(book.getID()).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return (name = name.toLowerCase()).endsWith(".ouf") || name.endsWith(".src") || name.endsWith(".png") || name.endsWith(".txt");
                }
            });
            for (int i = 0; i < files.length; ++i) {
                FileEnvironment.copy(files[i], new File(dest, files[i].getName()));
            }
        }
        catch (IOException e) {
            return this.error("Buch konnte nicht deployed werden", e);
        }
        catch (SyntaxError e) {
            return this.error("Buch konnte nicht deployed werden", e);
        }
        return this.ok();
    }
}

