/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.cli_ng;

import java.io.IOException;
import java.util.HashMap;
import tingeltangel.cli_ng.CliCmd;
import tingeltangel.core.Stick;

class StickDebug
extends CliCmd {
    StickDebug() {
    }

    @Override
    String getName() {
        return "stick-debug";
    }

    @Override
    String getDescription() {
        return "stick-debug on|off|state";
    }

    @Override
    int execute(String[] args) {
        if (args.length != 1) {
            return this.error("Falsche Anzahl von Parametern");
        }
        Stick stick = null;
        try {
            stick = Stick.getStick();
            if (stick == null) {
                return this.error("Kein Stift gefunden");
            }
        }
        catch (IOException e) {
            return this.error("Fehler beim erkennen des Stifts", e);
        }
        if (args[0].toLowerCase().trim().equals("state")) {
            try {
                HashMap<String, String> settings = stick.getSettings();
                String debug = settings.get("testpen").toLowerCase().trim();
                if (debug.equals("yes")) {
                    System.out.println("debug modus ist aktiv");
                }
                if (debug.equals("no")) {
                    System.out.println("debug modus ist inaktiv");
                }
                return this.error("Debugmodus ermittelt werden");
            }
            catch (IOException e) {
                return this.error("Debugmodus ermittelt werden", e);
            }
        } else {
            String debug = null;
            if (args[0].toLowerCase().trim().equals("on")) {
                debug = "yes";
            } else if (args[0].toLowerCase().trim().equals("off")) {
                debug = "no";
            } else {
                return this.error("Syntax Fehler");
            }
            try {
                HashMap<String, String> settings = stick.getSettings();
                settings.put("testpen", debug);
                stick.setSettings(settings);
            }
            catch (IOException e) {
                return this.error("Debugmodus konnte nicht eingestellt werden", e);
            }
        }
        return this.ok();
    }
}

