/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.cli.cmds;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Map;
import tingeltangel.cli.CliCommand;
import tingeltangel.cli.CliSwitch;
import tingeltangel.core.Codes;
import tingeltangel.core.Translator;

public class GenerateCode
extends CliCommand {
    @Override
    public String getName() {
        return "generate-code";
    }

    @Override
    public String getDescription() {
        return "Erzeugt ein png von der gegebenen Ting-ID";
    }

    @Override
    public Map<String, CliSwitch> getSwitches() {
        CliSwitch[] list = new CliSwitch[]{new CliSwitch(){

            @Override
            public String getName() {
                return "r";
            }

            @Override
            public String getDescription() {
                return "setzt die Ausgabeaufl\u00f6sung. 600 f\u00fcr 600dpi oder 1200 f\u00fcr 1200dpi.";
            }

            @Override
            public boolean hasArgument() {
                return true;
            }

            @Override
            public boolean isOptional() {
                return true;
            }

            @Override
            public String getLabel() {
                return "Aufl\u00f6sung";
            }

            @Override
            public String getDefault() {
                return "1200";
            }

            @Override
            public boolean acceptValue(String value) {
                return value.equals("1200") || value.equals("600");
            }
        }, new CliSwitch(){

            @Override
            public String getName() {
                return "o";
            }

            @Override
            public String getDescription() {
                return "setzt den Namen der Ausgabedatei (default: <Ting-ID>.png)";
            }

            @Override
            public boolean hasArgument() {
                return true;
            }

            @Override
            public boolean isOptional() {
                return true;
            }

            @Override
            public String getLabel() {
                return "Ausgabedatei";
            }

            @Override
            public String getDefault() {
                return null;
            }

            @Override
            public boolean acceptValue(String value) {
                return !value.isEmpty();
            }
        }, new CliSwitch(){

            @Override
            public String getName() {
                return "t";
            }

            @Override
            public String getDescription() {
                return "die Ting-ID";
            }

            @Override
            public boolean isOptional() {
                return false;
            }

            @Override
            public boolean hasArgument() {
                return true;
            }

            @Override
            public String getLabel() {
                return "Ting-ID";
            }

            @Override
            public String getDefault() {
                return null;
            }

            @Override
            public boolean acceptValue(String value) {
                try {
                    int v = Integer.parseInt(value);
                    if (v < 0 || v > 65535) {
                        return false;
                    }
                    return Translator.ting2code(v) >= 0;
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
            }
        }, new CliSwitch(){

            @Override
            public String getName() {
                return "w";
            }

            @Override
            public String getDescription() {
                return "Breite im mm";
            }

            @Override
            public boolean isOptional() {
                return true;
            }

            @Override
            public boolean hasArgument() {
                return true;
            }

            @Override
            public String getLabel() {
                return "Breite";
            }

            @Override
            public String getDefault() {
                return "100";
            }

            @Override
            public boolean acceptValue(String value) {
                try {
                    int v = Integer.parseInt(value);
                    return v >= 10 && v <= 500;
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
            }
        }, new CliSwitch(){

            @Override
            public String getName() {
                return "h";
            }

            @Override
            public String getDescription() {
                return "H\u00f6he im mm";
            }

            @Override
            public boolean isOptional() {
                return true;
            }

            @Override
            public boolean hasArgument() {
                return true;
            }

            @Override
            public String getLabel() {
                return "H\u00f6he";
            }

            @Override
            public String getDefault() {
                return "100";
            }

            @Override
            public boolean acceptValue(String value) {
                try {
                    int v = Integer.parseInt(value);
                    return v >= 10 && v <= 500;
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
            }
        }};
        return this.list2map(list);
    }

    @Override
    public void execute(Map<String, String> args) throws Exception {
        if (!args.containsKey("o")) {
            args.put("o", args.get("t") + ".png");
        }
        String tingID = args.get("t");
        String resolution = args.get("r");
        String outputFile = args.get("o");
        int codeID = Translator.ting2code(Integer.parseInt(tingID));
        if ("600".equals(resolution)) {
            Codes.setResolution(0);
        } else {
            Codes.setResolution(1);
        }
        int width = Integer.parseInt(args.get("w"));
        int height = Integer.parseInt(args.get("h"));
        FileOutputStream out = new FileOutputStream(outputFile);
        Codes.drawPng(codeID, width, height, out);
        ((OutputStream)out).close();
    }
}

