/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.core.scripting;

import java.util.HashMap;
import java.util.Map;
import tingeltangel.core.scripting.Command;
import tingeltangel.core.scripting.Commands;
import tingeltangel.core.scripting.SyntaxError;

public class Disassembler {
    Map<Integer, Integer> labels = new HashMap<Integer, Integer>();
    int labelCount = 1;
    StringBuffer sb = new StringBuffer();
    int offset = 0;
    byte[] b;

    private void disassembleCommandRegisterRegister(String command) {
        this.sb.append(command);
        this.sb.append(" v");
        int register1 = ((this.b[this.offset + 2] & 0xFF) << 8) + (this.b[this.offset + 3] & 0xFF);
        int register2 = ((this.b[this.offset + 4] & 0xFF) << 8) + (this.b[this.offset + 5] & 0xFF);
        this.sb.append(register1);
        this.sb.append(",v");
        this.sb.append(register2);
        this.sb.append('\n');
        this.offset += 6;
    }

    private void disassembleCommandRegister(String command) {
        this.sb.append(command);
        this.sb.append(" v");
        int register1 = ((this.b[this.offset + 2] & 0xFF) << 8) + (this.b[this.offset + 3] & 0xFF);
        this.sb.append(register1);
        this.sb.append('\n');
        this.offset += 4;
    }

    private void disassembleCommandRegisterValue(String command) {
        this.sb.append(command);
        this.sb.append(" v");
        int register = ((this.b[this.offset + 2] & 0xFF) << 8) + (this.b[this.offset + 3] & 0xFF);
        int value = ((this.b[this.offset + 4] & 0xFF) << 8) + (this.b[this.offset + 5] & 0xFF);
        this.sb.append(register);
        this.sb.append(",");
        this.sb.append(value);
        this.sb.append('\n');
        this.offset += 6;
    }

    private void disassembleJump(String command) {
        this.sb.append(command);
        this.sb.append(" ");
        int label = ((this.b[this.offset + 2] & 0xFF) << 8) + (this.b[this.offset + 3] & 0xFF);
        this.sb.append('l');
        this.sb.append(this.labels.get(label));
        this.sb.append('\n');
        this.offset += 4;
    }

    public String disassemble(byte[] b) throws SyntaxError {
        this.b = b;
        if (b[0] == 0 && b[1] == 0 && b[2] == 0 && b[3] == 0) {
            throw new SyntaxError("Script stats with 0x00000000. That's an invalid script.");
        }
        while (this.offset < b.length) {
            if (this.offset == b.length - 1) {
                if (b[this.offset] != 0) {
                    throw new SyntaxError("Last byte must be 0x00.");
                }
                ++this.offset;
                continue;
            }
            int opcode = (b[this.offset] & 0xFF) << 8 | b[this.offset + 1] & 0xFF;
            Command command = Commands.getCommand(opcode);
            if (command == null) {
                String msb = Integer.toHexString(b[this.offset] & 0xFF);
                String lsb = Integer.toHexString(b[this.offset + 1] & 0xFF);
                throw new SyntaxError("unknown byte code 0x" + (msb.length() == 1 ? Character.valueOf('0') : "") + msb + " 0x" + (lsb.length() == 1 ? Character.valueOf('0') : "") + lsb + "@ 0x" + Integer.toHexString(this.offset));
            }
            if (command.firstArgumentIsLabel()) {
                int label = (b[this.offset + 2] & 0xFF) << 8 | b[this.offset + 3] & 0xFF;
                if (!this.labels.containsKey(label)) {
                    this.labels.put(label, this.labelCount++);
                }
                this.offset += 4;
                continue;
            }
            this.offset += (command.getNumberOfArguments() + 1) * 2;
        }
        this.offset = 0;
        while (this.offset < b.length) {
            int register;
            int value;
            if (this.labels.containsKey(this.offset)) {
                this.sb.append("\n:l");
                this.sb.append(this.labels.get(this.offset));
                this.sb.append('\n');
            }
            if (this.offset == b.length - 1) {
                if (b[this.offset] != 0) {
                    throw new RuntimeException("Last byte must be 0x00.");
                }
                ++this.offset;
                continue;
            }
            if (b[this.offset] == 0 && b[this.offset + 1] == 0) {
                this.sb.append("end\n");
                this.offset += 2;
                continue;
            }
            if (b[this.offset] == 1 && b[this.offset + 1] == 0) {
                this.sb.append("clearver\n");
                this.offset += 2;
                continue;
            }
            if (b[this.offset] == 2 && b[this.offset + 1] == 1) {
                this.disassembleCommandRegisterValue("set");
                continue;
            }
            if (b[this.offset] == 2 && b[this.offset + 1] == 2) {
                this.disassembleCommandRegisterRegister("set");
                continue;
            }
            if (b[this.offset] == 3 && b[this.offset + 1] == 1) {
                this.disassembleCommandRegisterValue("cmp");
                continue;
            }
            if (b[this.offset] == 3 && b[this.offset + 1] == 2) {
                this.disassembleCommandRegisterRegister("cmp");
                continue;
            }
            if (b[this.offset] == 4 && b[this.offset + 1] == 1) {
                this.disassembleCommandRegisterValue("and");
                continue;
            }
            if (b[this.offset] == 4 && b[this.offset + 1] == 2) {
                this.disassembleCommandRegisterRegister("and");
                continue;
            }
            if (b[this.offset] == 5 && b[this.offset + 1] == 1) {
                this.disassembleCommandRegisterRegister("or");
                continue;
            }
            if (b[this.offset] == 5 && b[this.offset + 1] == 2) {
                this.disassembleCommandRegisterRegister("or");
                continue;
            }
            if (b[this.offset] == 6 && b[this.offset + 1] == 2) {
                this.sb.append("not v");
                int register1 = ((b[this.offset + 2] & 0xFF) << 8) + (b[this.offset + 3] & 0xFF);
                this.sb.append(register1);
                this.sb.append('\n');
                this.offset += 6;
                continue;
            }
            if (b[this.offset] == 8 && b[this.offset + 1] == 0) {
                this.disassembleJump("jmp");
                continue;
            }
            if (b[this.offset] == 9 && b[this.offset + 1] == 0) {
                this.disassembleJump("je");
                continue;
            }
            if (b[this.offset] == 10 && b[this.offset + 1] == 0) {
                this.disassembleJump("jne");
                continue;
            }
            if (b[this.offset] == 11 && b[this.offset + 1] == 0) {
                this.disassembleJump("jg");
                continue;
            }
            if (b[this.offset] == 12 && b[this.offset + 1] == 0) {
                this.disassembleJump("jge");
                continue;
            }
            if (b[this.offset] == 13 && b[this.offset + 1] == 0) {
                this.disassembleJump("jb");
                continue;
            }
            if (b[this.offset] == 14 && b[this.offset + 1] == 0) {
                this.disassembleJump("jbe");
                continue;
            }
            if (b[this.offset] == 15 && b[this.offset + 1] == 1) {
                this.disassembleCommandRegisterValue("add");
                continue;
            }
            if (b[this.offset] == 15 && b[this.offset + 1] == 2) {
                this.disassembleCommandRegisterRegister("add");
                continue;
            }
            if (b[this.offset] == 16 && b[this.offset + 1] == 1) {
                this.disassembleCommandRegisterValue("sub");
                continue;
            }
            if (b[this.offset] == 16 && b[this.offset + 1] == 2) {
                this.disassembleCommandRegisterRegister("sub");
                continue;
            }
            if (b[this.offset] == 20 && b[this.offset + 1] == 0) {
                this.sb.append("return\n");
                this.offset += 2;
                continue;
            }
            if (b[this.offset] == 21 && b[this.offset + 1] == 1) {
                this.sb.append("callid ");
                value = ((b[this.offset + 2] & 0xFF) << 8) + (b[this.offset + 3] & 0xFF);
                this.sb.append(value);
                this.sb.append('\n');
                this.offset += 4;
                continue;
            }
            if (b[this.offset] == 22 && b[this.offset + 1] == 1) {
                this.sb.append("playoid ");
                int oid = ((b[this.offset + 2] & 0xFF) << 8) + (b[this.offset + 3] & 0xFF);
                this.sb.append(oid);
                this.sb.append('\n');
                this.offset += 4;
                continue;
            }
            if (b[this.offset] == 22 && b[this.offset + 1] == 2) {
                this.sb.append("playoid v");
                register = ((b[this.offset + 2] & 0xFF) << 8) + (b[this.offset + 3] & 0xFF);
                this.sb.append(register);
                this.sb.append('\n');
                this.offset += 4;
                continue;
            }
            if (b[this.offset] == 23 && b[this.offset + 1] == 1) {
                this.sb.append("pause ");
                value = ((b[this.offset + 2] & 0xFF) << 8) + (b[this.offset + 3] & 0xFF);
                this.sb.append(value);
                this.sb.append('\n');
                this.offset += 4;
                continue;
            }
            if (b[this.offset] == 23 && b[this.offset + 1] == 2) {
                this.sb.append("pause v");
                register = ((b[this.offset + 2] & 0xFF) << 8) + (b[this.offset + 3] & 0xFF);
                this.sb.append(register);
                this.sb.append('\n');
                this.offset += 4;
                continue;
            }
            String msb = Integer.toHexString(b[this.offset]);
            String lsb = Integer.toHexString(b[this.offset + 1]);
            throw new SyntaxError("unknown byte code 0x" + (msb.length() == 1 ? Character.valueOf('0') : "") + msb + " 0x" + (lsb.length() == 1 ? Character.valueOf('0') : "") + lsb);
        }
        return this.sb.toString();
    }
}

