/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.cli_ng;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import tingeltangel.Tingeltangel;
import tingeltangel.cli_ng.BookInfo;
import tingeltangel.cli_ng.ChangeMid;
import tingeltangel.cli_ng.CleanupRepository;
import tingeltangel.cli_ng.CliCmd;
import tingeltangel.cli_ng.CodeRawToTing;
import tingeltangel.cli_ng.CodeTingToRaw;
import tingeltangel.cli_ng.DeleteBook;
import tingeltangel.cli_ng.DeleteEntry;
import tingeltangel.cli_ng.Deploy;
import tingeltangel.cli_ng.Exit;
import tingeltangel.cli_ng.ExportMp3;
import tingeltangel.cli_ng.ExportMp3s;
import tingeltangel.cli_ng.FindNiceMid;
import tingeltangel.cli_ng.GenerateBook;
import tingeltangel.cli_ng.GenerateBooklet;
import tingeltangel.cli_ng.GenerateCodes;
import tingeltangel.cli_ng.GetEntryMp3Hint;
import tingeltangel.cli_ng.GetEntryMp3Length;
import tingeltangel.cli_ng.GetEntryMp3Name;
import tingeltangel.cli_ng.GetEntryScript;
import tingeltangel.cli_ng.GetEntryTts;
import tingeltangel.cli_ng.GetEntryType;
import tingeltangel.cli_ng.GetMeta;
import tingeltangel.cli_ng.GetMid;
import tingeltangel.cli_ng.Help;
import tingeltangel.cli_ng.ImportFromRepository;
import tingeltangel.cli_ng.ImportManual;
import tingeltangel.cli_ng.LoadBook;
import tingeltangel.cli_ng.NewBook;
import tingeltangel.cli_ng.Play;
import tingeltangel.cli_ng.SaveBook;
import tingeltangel.cli_ng.SearchForNewBooksInRepository;
import tingeltangel.cli_ng.SetEntryMp3;
import tingeltangel.cli_ng.SetEntryMp3Hint;
import tingeltangel.cli_ng.SetEntryScript;
import tingeltangel.cli_ng.SetEntrySubScript;
import tingeltangel.cli_ng.SetEntryTts;
import tingeltangel.cli_ng.SetMeta;
import tingeltangel.cli_ng.ShowBooks;
import tingeltangel.cli_ng.ShowBooksInRepository;
import tingeltangel.cli_ng.StickActivateBook;
import tingeltangel.cli_ng.StickDebug;
import tingeltangel.cli_ng.TtsGetVariant;
import tingeltangel.cli_ng.TtsGetVariants;
import tingeltangel.cli_ng.TtsGetVoice;
import tingeltangel.cli_ng.TtsGetVoices;
import tingeltangel.cli_ng.TtsSetVariant;
import tingeltangel.cli_ng.TtsSetVoice;
import tingeltangel.cli_ng.UpdateRepositoryBooks;
import tingeltangel.core.Book;
import tingeltangel.core.scripting.SyntaxError;

public class CLI {
    private static final CliCmd[] COMMANDS = new CliCmd[]{new NewBook(), new LoadBook(), new BookInfo(), new ImportFromRepository(), new ImportManual(), new GenerateBooklet(), new ShowBooks(), new FindNiceMid(), new SaveBook(), new GenerateBook(), new ExportMp3s(), new GenerateCodes(), new Exit(), new Help(), new DeleteBook(), new SearchForNewBooksInRepository(), new UpdateRepositoryBooks(), new CleanupRepository(), new ShowBooksInRepository(), new TtsGetVoices(), new TtsGetVoice(), new TtsSetVoice(), new TtsGetVariants(), new TtsGetVariant(), new TtsSetVariant(), new CodeRawToTing(), new CodeTingToRaw(), new SetEntryMp3(), new SetEntryMp3Hint(), new SetEntryScript(), new SetEntrySubScript(), new SetEntryTts(), new DeleteEntry(), new ExportMp3(), new GetEntryType(), new GetEntryMp3Name(), new GetEntryMp3Length(), new GetEntryMp3Hint(), new GetEntryTts(), new GetEntryScript(), new Deploy(), new GetMid(), new ChangeMid(), new GetMeta(), new SetMeta(), new Play(), new StickDebug(), new StickActivateBook()};
    private static final HashMap<String, CliCmd> cmds = new HashMap();
    private static final Book book = new Book(15000);

    static Book getBook() {
        return book;
    }

    static void showCommands() {
        for (int i = 0; i < COMMANDS.length; ++i) {
            System.out.println(COMMANDS[i].getDescription());
        }
    }

    static boolean bookOpened() {
        return book.getID() == 15000;
    }

    public static void run() {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        PrintWriter out = new PrintWriter(System.out);
        out.println("Tingeltangel CLI " + Tingeltangel.MAIN_FRAME_VERSION);
        out.flush();
        for (int i = 0; i < COMMANDS.length; ++i) {
            CliCmd cmd = COMMANDS[i];
            cmds.put(cmd.getName(), cmd);
        }
        System.out.print(">");
        try {
            String row;
            while ((row = in.readLine()) != null) {
                if (!(row = row.trim()).isEmpty() && !row.startsWith("//")) {
                    String cmd;
                    int p = row.indexOf(" ");
                    String argstr = "";
                    if (p < 0) {
                        cmd = row.toLowerCase();
                    } else {
                        cmd = row.substring(0, p).toLowerCase();
                        argstr = row.substring(p + 1).trim();
                    }
                    String[] args = new String[]{};
                    try {
                        CliCmd cliCmd;
                        if (!argstr.isEmpty()) {
                            args = CLI.argssplit(argstr);
                        }
                        if ((cliCmd = cmds.get(cmd)) == null) {
                            System.err.println("unbekannter Befehl");
                        } else {
                            cliCmd.execute(args);
                        }
                    }
                    catch (SyntaxError e) {
                        System.err.println(e.getMessage());
                    }
                }
                System.out.print(">");
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private static String[] argssplit(String x) throws SyntaxError {
        LinkedList<String> args = new LinkedList<String>();
        while (!x.isEmpty()) {
            int p;
            if (x.startsWith("\"")) {
                p = (x = x.substring(1)).indexOf("\"");
                if (p == -1) {
                    throw new SyntaxError("missing \"");
                }
                args.add(x.substring(0, p));
                x = x.substring(p + 1).trim();
                continue;
            }
            p = x.indexOf(" ");
            if (p == -1) {
                args.add(x);
                x = "";
                continue;
            }
            args.add(x.substring(0, p));
            x = x.substring(p).trim();
        }
        return args.toArray(new String[0]);
    }
}

