/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.properties;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Order;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.AppenderRefComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.FilterComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ScriptComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ScriptFileComponentBuilder;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.properties.PropertiesConfiguration;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="PropertiesConfigurationFactory", category="ConfigurationFactory")
@Order(value=8)
public class PropertiesConfigurationFactory
extends ConfigurationFactory {
    private static final String ADVERTISER_KEY = "advertiser";
    private static final String STATUS_KEY = "status";
    private static final String SHUTDOWN_HOOK = "shutdownHook";
    private static final String VERBOSE = "verbose";
    private static final String PACKAGES = "packages";
    private static final String CONFIG_NAME = "name";
    private static final String MONITOR_INTERVAL = "monitorInterval";
    private static final String CONFIG_TYPE = "type";

    @Override
    protected String[] getSupportedTypes() {
        return new String[]{".properties"};
    }

    @Override
    public PropertiesConfiguration getConfiguration(ConfigurationSource source) {
        String loggerProp;
        String appenderProp;
        String filterProp;
        Properties levelProps;
        InputStream configStream = source.getInputStream();
        Properties properties = new Properties();
        try {
            properties.load(configStream);
        }
        catch (IOException ioe) {
            throw new ConfigurationException("Unable to load " + source.toString(), ioe);
        }
        ConfigurationBuilder<PropertiesConfiguration> builder = PropertiesConfigurationFactory.newConfigurationBuilder(PropertiesConfiguration.class);
        String value = properties.getProperty(STATUS_KEY);
        if (value != null) {
            builder.setStatusLevel(Level.toLevel(value, Level.ERROR));
        } else {
            builder.setStatusLevel(Level.ERROR);
        }
        value = properties.getProperty(SHUTDOWN_HOOK);
        if (value != null) {
            builder.setShutdownHook(value);
        }
        if ((value = properties.getProperty(VERBOSE)) != null) {
            builder.setVerbosity(value);
        }
        if ((value = properties.getProperty(PACKAGES)) != null) {
            builder.setPackages(value);
        }
        if ((value = properties.getProperty(CONFIG_NAME)) != null) {
            builder.setConfigurationName(value);
        }
        if ((value = properties.getProperty(MONITOR_INTERVAL)) != null) {
            builder.setMonitorInterval(value);
        }
        if ((value = properties.getProperty(ADVERTISER_KEY)) != null) {
            builder.setAdvertiser(value);
        }
        Properties props = PropertiesUtil.extractSubset(properties, "property");
        for (String key : props.stringPropertyNames()) {
            builder.addProperty(key, props.getProperty(key));
        }
        String scriptProp = properties.getProperty("scripts");
        if (scriptProp != null) {
            String[] scriptNames;
            for (String scriptName : scriptNames = scriptProp.split(",")) {
                String name = scriptName.trim();
                Properties scriptProps = PropertiesUtil.extractSubset(properties, "script." + name);
                String type = scriptProps.getProperty(CONFIG_TYPE);
                if (type == null) {
                    throw new ConfigurationException("No type provided for script - must be Script or ScriptFile");
                }
                scriptProps.remove(CONFIG_TYPE);
                if (type.equalsIgnoreCase("script")) {
                    builder.add(this.createScript(builder, name, scriptProps));
                    continue;
                }
                builder.add(this.createScriptFile(builder, name, scriptProps));
            }
        }
        if ((levelProps = PropertiesUtil.extractSubset(properties, "customLevel")).size() > 0) {
            for (String key : levelProps.stringPropertyNames()) {
                builder.add(builder.newCustomLevel(key, Integer.parseInt(props.getProperty(key))));
            }
        }
        if ((filterProp = properties.getProperty("filters")) != null) {
            String[] filterNames;
            for (String filterName : filterNames = filterProp.split(",")) {
                String name = filterName.trim();
                builder.add(this.createFilter(builder, name, PropertiesUtil.extractSubset(properties, "filter." + name)));
            }
        }
        if ((appenderProp = properties.getProperty("appenders")) != null) {
            String[] appenderNames;
            for (String appenderName : appenderNames = appenderProp.split(",")) {
                String name = appenderName.trim();
                builder.add(this.createAppender(builder, name, PropertiesUtil.extractSubset(properties, "appender." + name)));
            }
        }
        if ((loggerProp = properties.getProperty("loggers")) != null) {
            String[] loggerNames;
            for (String loggerName : loggerNames = loggerProp.split(",")) {
                String name = loggerName.trim();
                if (name.equals("root")) continue;
                builder.add(this.createLogger(builder, name, PropertiesUtil.extractSubset(properties, "logger." + name)));
            }
        }
        if ((props = PropertiesUtil.extractSubset(properties, "rootLogger")).size() > 0) {
            builder.add(this.createRootLogger(builder, props));
        }
        return (PropertiesConfiguration)builder.build();
    }

    private ScriptComponentBuilder createScript(ConfigurationBuilder<PropertiesConfiguration> builder, String key, Properties properties) {
        String text;
        String language;
        String name = properties.getProperty(CONFIG_NAME);
        if (name != null) {
            properties.remove(CONFIG_NAME);
        }
        if ((language = properties.getProperty("language")) != null) {
            properties.remove("language");
        }
        if ((text = properties.getProperty("text")) != null) {
            properties.remove("text");
        }
        ScriptComponentBuilder scriptBuilder = builder.newScript(name, language, text);
        this.processRemainingProperties(scriptBuilder, key, properties);
        return scriptBuilder;
    }

    private ScriptFileComponentBuilder createScriptFile(ConfigurationBuilder<PropertiesConfiguration> builder, String key, Properties properties) {
        String path;
        String name = properties.getProperty(CONFIG_NAME);
        if (name != null) {
            properties.remove(CONFIG_NAME);
        }
        if ((path = properties.getProperty("path")) != null) {
            properties.remove("path");
        }
        ScriptFileComponentBuilder scriptFileBuilder = builder.newScriptFile(name, path);
        this.processRemainingProperties(scriptFileBuilder, key, properties);
        return scriptFileBuilder;
    }

    private AppenderComponentBuilder createAppender(ConfigurationBuilder<PropertiesConfiguration> builder, String key, Properties properties) {
        Properties layoutProps;
        String name = properties.getProperty(CONFIG_NAME);
        if (Strings.isEmpty(name)) {
            throw new ConfigurationException("No name attribute provided for Appender " + key);
        }
        properties.remove(CONFIG_NAME);
        String type = properties.getProperty(CONFIG_TYPE);
        if (Strings.isEmpty(type)) {
            throw new ConfigurationException("No type attribute provided for Appender " + key);
        }
        properties.remove(CONFIG_TYPE);
        AppenderComponentBuilder appenderBuilder = builder.newAppender(name, type);
        String filters = properties.getProperty("filters");
        if (filters != null) {
            String[] filterNames;
            properties.remove("filters");
            for (String filterName : filterNames = filters.split(",")) {
                filterName = filterName.trim();
                Properties filterProps = PropertiesUtil.extractSubset(properties, "filter." + filterName);
                appenderBuilder.add(this.createFilter(builder, filterName, filterProps));
            }
        }
        if ((layoutProps = PropertiesUtil.extractSubset(properties, "layout")).size() > 0) {
            appenderBuilder.add(this.createLayout(builder, name, layoutProps));
        }
        this.processRemainingProperties(appenderBuilder, name, properties);
        return appenderBuilder;
    }

    private FilterComponentBuilder createFilter(ConfigurationBuilder<PropertiesConfiguration> builder, String key, Properties properties) {
        String onMisMatch;
        String type = properties.getProperty(CONFIG_TYPE);
        if (Strings.isEmpty(type)) {
            throw new ConfigurationException("No type attribute provided for Appender " + key);
        }
        properties.remove(CONFIG_TYPE);
        String onMatch = properties.getProperty("onMatch");
        if (onMatch != null) {
            properties.remove("onMatch");
        }
        if ((onMisMatch = properties.getProperty("onMisMatch")) != null) {
            properties.remove("onMisMatch");
        }
        FilterComponentBuilder filterBuilder = builder.newFilter(type, onMatch, onMisMatch);
        this.processRemainingProperties(filterBuilder, key, properties);
        return filterBuilder;
    }

    private AppenderRefComponentBuilder createAppenderRef(ConfigurationBuilder<PropertiesConfiguration> builder, String key, Properties properties) {
        String filters;
        String ref = properties.getProperty("ref");
        if (Strings.isEmpty(ref)) {
            throw new ConfigurationException("No ref attribute provided for AppenderRef " + key);
        }
        properties.remove("ref");
        AppenderRefComponentBuilder appenderRefBuilder = builder.newAppenderRef(ref);
        String level = properties.getProperty("level");
        if (!Strings.isEmpty(level)) {
            appenderRefBuilder.addAttribute("level", level);
        }
        if ((filters = properties.getProperty("filters")) != null) {
            String[] filterNames;
            properties.remove("filters");
            for (String filterName : filterNames = filters.split(",")) {
                filterName = filterName.trim();
                Properties filterProps = PropertiesUtil.extractSubset(properties, "filter." + filterName);
                appenderRefBuilder.add(this.createFilter(builder, filterName, filterProps));
            }
        }
        return appenderRefBuilder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LoggerComponentBuilder createLogger(ConfigurationBuilder<PropertiesConfiguration> builder, String key, Properties properties) {
        String additivity;
        String filters;
        LoggerComponentBuilder loggerBuilder;
        String type;
        String name = properties.getProperty(CONFIG_NAME);
        if (Strings.isEmpty(name)) {
            throw new ConfigurationException("No name attribute provided for Logger " + key);
        }
        properties.remove(CONFIG_NAME);
        String level = properties.getProperty("level");
        if (level != null) {
            properties.remove("level");
        }
        if ((type = properties.getProperty(CONFIG_TYPE)) != null) {
            if (!type.equalsIgnoreCase("asyncLogger")) throw new ConfigurationException("Unknown Logger type " + type + " for Logger " + name);
            loggerBuilder = builder.newAsyncLogger(name, level);
        } else {
            loggerBuilder = builder.newLogger(name, level);
        }
        String appenderRefs = properties.getProperty("appenderRefs");
        if (appenderRefs != null) {
            String[] refNames;
            properties.remove("appenderRefs");
            for (String appenderRef : refNames = appenderRefs.split(",")) {
                appenderRef = appenderRef.trim();
                Properties refProps = PropertiesUtil.extractSubset(properties, "appenderRef." + appenderRef);
                loggerBuilder.add(this.createAppenderRef(builder, appenderRef, refProps));
            }
        }
        if ((filters = properties.getProperty("filters")) != null) {
            String[] filterNames;
            properties.remove("filters");
            for (String filterName : filterNames = filters.split(",")) {
                filterName = filterName.trim();
                Properties filterProps = PropertiesUtil.extractSubset(properties, "filter." + filterName);
                loggerBuilder.add(this.createFilter(builder, filterName, filterProps));
            }
        }
        if (Strings.isEmpty(additivity = properties.getProperty("additivity"))) return loggerBuilder;
        loggerBuilder.addAttribute("additivity", additivity);
        return loggerBuilder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RootLoggerComponentBuilder createRootLogger(ConfigurationBuilder<PropertiesConfiguration> builder, Properties properties) {
        String[] filterNames;
        String filters;
        RootLoggerComponentBuilder loggerBuilder;
        String type;
        String level = properties.getProperty("level");
        if (level != null) {
            properties.remove("level");
        }
        if ((type = properties.getProperty(CONFIG_TYPE)) != null) {
            if (!type.equalsIgnoreCase("asyncRoot")) throw new ConfigurationException("Unknown Logger type for root logger" + type);
            loggerBuilder = builder.newAsyncRootLogger(level);
        } else {
            loggerBuilder = builder.newRootLogger(level);
        }
        String appenderRefs = properties.getProperty("appenderRefs");
        if (appenderRefs != null) {
            String[] refNames;
            properties.remove("appenderRefs");
            for (String appenderRef : refNames = appenderRefs.split(",")) {
                appenderRef = appenderRef.trim();
                Properties refProps = PropertiesUtil.extractSubset(properties, "appenderRef." + appenderRef);
                loggerBuilder.add(this.createAppenderRef(builder, appenderRef, refProps));
            }
        }
        if ((filters = properties.getProperty("filters")) == null) return loggerBuilder;
        properties.remove("filters");
        for (String filterName : filterNames = filters.split(",")) {
            filterName = filterName.trim();
            Properties filterProps = PropertiesUtil.extractSubset(properties, "filter." + filterName);
            loggerBuilder.add(this.createFilter(builder, filterName, filterProps));
        }
        return loggerBuilder;
    }

    private LayoutComponentBuilder createLayout(ConfigurationBuilder<PropertiesConfiguration> builder, String appenderName, Properties properties) {
        String type = properties.getProperty(CONFIG_TYPE);
        if (Strings.isEmpty(type)) {
            throw new ConfigurationException("No type attribute provided for Layout on Appender " + appenderName);
        }
        properties.remove(CONFIG_TYPE);
        LayoutComponentBuilder layoutBuilder = builder.newLayout(type);
        this.processRemainingProperties(layoutBuilder, appenderName, properties);
        return layoutBuilder;
    }

    private <B extends ComponentBuilder<B>> ComponentBuilder<B> createComponent(ComponentBuilder<?> parent, String key, Properties properties) {
        String type;
        String name = properties.getProperty(CONFIG_NAME);
        if (name != null) {
            properties.remove(CONFIG_NAME);
        }
        if (Strings.isEmpty(type = properties.getProperty(CONFIG_TYPE))) {
            throw new ConfigurationException("No type attribute provided for component " + key);
        }
        properties.remove(CONFIG_TYPE);
        ComponentBuilder componentBuilder = parent.getBuilder().newComponent(name, type);
        this.processRemainingProperties(componentBuilder, name, properties);
        return componentBuilder;
    }

    private void processRemainingProperties(ComponentBuilder<?> builder, String name, Properties properties) {
        while (properties.size() > 0) {
            String propertyName = properties.stringPropertyNames().iterator().next();
            int index = propertyName.indexOf(46);
            if (index > 0) {
                String prefix = propertyName.substring(0, index);
                Properties componentProperties = PropertiesUtil.extractSubset(properties, prefix);
                builder.addComponent(this.createComponent(builder, prefix, componentProperties));
                continue;
            }
            builder.addAttribute(propertyName, properties.getProperty(propertyName));
            properties.remove(propertyName);
        }
    }
}

