/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.core;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Random;

public class Translator {
    private static final String ID_TRANS_FILE = "/id_trans.data";
    private static final int[] code2ting = new int[65537];
    private static final int[] ting2code = new int[65537];
    private static final int min_object_code = 15001;
    private static final int max_object_code;
    public static final int MAX_MID = 9999;
    private static final Random rnd;

    public static int getMinObjectCode() {
        return 15001;
    }

    public static int getMaxObjectCode() {
        return max_object_code;
    }

    public static int code2ting(int c) {
        return code2ting[c];
    }

    public static int ting2code(int t) {
        return ting2code[t];
    }

    public static boolean isKnownTingID(int t) {
        return ting2code[t] >= 0;
    }

    public static int getRandomBookCode() {
        int min = 8001;
        int max = 8500;
        max = Math.min(Translator.getMaxTingCodeFrom(min), max);
        return rnd.nextInt(max - min + 1) + min;
    }

    public static void main(String[] args) {
        int c = 0;
        System.out.println("^ Ting-ID ^ Code-ID ^ Ting-ID ^ Code-ID ^ Ting-ID ^ Code-ID ^ Ting-ID ^ Code-ID ^ Ting-ID ^ Code-ID ^");
        for (int i = 0; i < 65536; ++i) {
            if (ting2code[i] < 0) continue;
            System.out.print("| " + i + " | " + ting2code[i] + " ");
            if (++c != 5) continue;
            c = 0;
            System.out.println("|");
        }
    }

    public static int getMaxTingCodeFrom(int start) {
        while (start < 65536) {
            if (ting2code[start] == -1) {
                return start - 1;
            }
            ++start;
        }
        return 65535;
    }

    static {
        rnd = new Random();
        for (int i = 0; i < code2ting.length; ++i) {
            Translator.code2ting[i] = -1;
            Translator.ting2code[i] = -1;
        }
        int r = 0;
        int codeId = -1;
        int lastLowerTingId = -1;
        int lastHigherTingId = -1;
        int lastCurrentCodeId = -1;
        try {
            String row;
            BufferedReader in = new BufferedReader(new InputStreamReader(Translator.class.getResourceAsStream(ID_TRANS_FILE)));
            while ((row = in.readLine()) != null) {
                ++r;
                if ((row = row.trim()).isEmpty() || row.startsWith("#")) continue;
                if (row.startsWith("set ")) {
                    int p = (row = row.substring("set ".length()).trim()).indexOf(" ");
                    if (p == -1) {
                        throw new Error("error in '/id_trans.data' on line " + r);
                    }
                    codeId = Integer.parseInt(row.substring(0, p).trim());
                    if ((p = (row = row.substring(p).trim()).indexOf(" ")) == -1) {
                        throw new Error("error in '/id_trans.data' on line " + r);
                    }
                    lastLowerTingId = Integer.parseInt(row.substring(0, p).trim());
                    lastHigherTingId = Integer.parseInt(row.substring(p + 1).trim()) - 1;
                    continue;
                }
                int currentCodeId = Integer.parseInt(row);
                if (lastCurrentCodeId >= currentCodeId) {
                    throw new Error();
                }
                lastCurrentCodeId = currentCodeId;
                for (int i = codeId; i < currentCodeId; ++i) {
                    Translator.code2ting[i] = ++lastHigherTingId;
                }
                Translator.code2ting[currentCodeId] = ++lastLowerTingId;
                codeId = currentCodeId + 1;
            }
            for (int c = 0; c < 65536; ++c) {
                if (code2ting[c] == -1) continue;
                if (ting2code[code2ting[c]] == -1) {
                    Translator.ting2code[Translator.code2ting[c]] = c;
                    continue;
                }
                throw new Error();
            }
            int moc = 0;
            for (int t = 15001; t <= 65536; ++t) {
                if (ting2code[t] != -1) continue;
                moc = t - 1;
                break;
            }
            max_object_code = moc;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

