/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.core;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import tingeltangel.core.Codes;
import tingeltangel.core.Entry;
import tingeltangel.core.IndexTableCalculator;
import tingeltangel.core.Script;
import tingeltangel.core.SortedIntList;
import tingeltangel.core.TTSEntry;
import tingeltangel.core.Translator;
import tingeltangel.core.Tupel;
import tingeltangel.core.scripting.Constants;
import tingeltangel.core.scripting.Emulator;
import tingeltangel.core.scripting.RegisterListener;
import tingeltangel.core.scripting.SyntaxError;
import tingeltangel.tools.FileEnvironment;
import tingeltangel.tools.OS;
import tingeltangel.tools.ProgressDialog;

public class Book {
    private static final long DEFAULT_MAGIC_VALUE = 11L;
    private SortedIntList indexIDs = new SortedIntList();
    private HashMap<Integer, Entry> indexEntries = new HashMap();
    private Constants constants = new Constants();
    private boolean changed = false;
    private int id;
    private String name;
    private String publisher;
    private String author;
    private int version;
    private String url;
    private long date = new Date().getTime() / 1000L;
    private long magicValue = 11L;
    private final Emulator emulator;
    private static final Logger log = LogManager.getLogger(Book.class);
    protected static final char[] hexArray = "0123456789abcdef".toCharArray();

    public final void clear() {
        this.name = "My Book";
        this.publisher = "Me";
        this.author = "Me";
        this.version = 1;
        this.url = "";
        this.indexIDs = new SortedIntList();
        this.indexEntries = new HashMap();
        this.changed = false;
        this.date = new Date().getTime() / 1000L;
        this.constants = new Constants();
        this.magicValue = 11L;
    }

    public File getCover() {
        return new File(FileEnvironment.getBookDirectory(this.id), "cover.png");
    }

    public void generateTestBooklet(PrintWriter out) {
        LinkedList<Tupel<Integer, String>> booklet = new LinkedList<Tupel<Integer, String>>();
        Iterator<Integer> ids = this.indexIDs.iterator();
        while (ids.hasNext()) {
            int tid = ids.next();
            Entry entry = this.indexEntries.get(tid);
            String txt = null;
            if (entry.isMP3()) {
                txt = "MP3: " + entry.getHint();
            } else if (entry.isCode()) {
                txt = "Skript: " + entry.getScript().toString();
            } else if (entry.isTTS()) {
                txt = entry.getTTS().text;
            }
            if (txt == null) continue;
            if (txt.length() > 100) {
                txt = txt.substring(0, 100) + " ...";
            }
            booklet.add(new Tupel<Integer, String>(tid, txt));
        }
        Codes.setResolution(0);
        Codes.drawBooklet(this.name, this.id, booklet, out);
    }

    public long getMagicValue() {
        return this.magicValue;
    }

    public long getDate() {
        return this.date;
    }

    public void setMagicValue(long magicValue) {
        this.magicValue = magicValue;
    }

    public void setDate(long date) {
        this.date = date;
    }

    public Emulator getEmulator() {
        return this.emulator;
    }

    public boolean unsaved() {
        return this.changed;
    }

    void changeMade() {
        this.changed = true;
    }

    public void resetChangeMade() {
        this.changed = false;
    }

    public String getName() {
        return this.name;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getUrl() {
        return this.url;
    }

    public int getVersion() {
        return this.version;
    }

    public void setName(String name) {
        this.name = name;
        this.changeMade();
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
        this.changeMade();
    }

    public void setAuthor(String author) {
        this.author = author;
        this.changeMade();
    }

    public void setVersion(int version) {
        this.version = version;
        this.changeMade();
    }

    public void setID(int id) {
        this.id = id;
    }

    public void setURL(String url) {
        this.url = url;
        this.changeMade();
    }

    public Book(int id) {
        this.id = id;
        this.clear();
        this.emulator = new Emulator(this);
    }

    public void addEntry(int tingID) {
        if (tingID < 15000 || tingID > 65536) {
            throw new Error("TingID=" + tingID + " out of range");
        }
        if (!this.indexIDs.containsKey(tingID)) {
            this.indexIDs.add(tingID);
            this.indexEntries.put(tingID, new Entry(this, tingID));
        }
        this.changeMade();
    }

    public Entry getEntry(int i) {
        return this.indexEntries.get(this.indexIDs.get(i));
    }

    public Entry getEntryByOID(int oid) {
        return this.indexEntries.get(oid);
    }

    public boolean entryForTingIDExists(int tingID) {
        return this.indexEntries.get(tingID) != null;
    }

    public int getID() {
        return this.id;
    }

    public int getSize() {
        return this.indexIDs.size();
    }

    public int getLastID() {
        if (this.indexIDs.size() == 0) {
            return 15000;
        }
        int lastFound = -1;
        Iterator<Integer> i = this.indexIDs.iterator();
        while (i.hasNext()) {
            lastFound = i.next();
            Entry entry = this.indexEntries.get(lastFound);
        }
        if (lastFound == -1) {
            return 15000;
        }
        return lastFound;
    }

    void removeEntry(int row) {
        int tingID = this.indexIDs.get(row);
        this.indexIDs.remove(row);
        this.indexEntries.remove(tingID);
        this.changeMade();
    }

    private static String encodeAttribute(String v) {
        return v.replace("&", "&amp;").replace("\"", "&quot;");
    }

    private static String encodeValue(String v) {
        return v.replace("&", "&amp;").replace("<", "&gt;");
    }

    public static SortedSet<Integer> getBookMIDs() {
        TreeSet<Integer> books = new TreeSet<Integer>();
        File[] bookFiles = FileEnvironment.getBooksDirectory().listFiles();
        for (int i = 0; i < bookFiles.length; ++i) {
            if (!bookFiles[i].isDirectory()) continue;
            try {
                int id = Integer.parseInt(bookFiles[i].getName());
                if (id == 15000) continue;
                books.add(id);
                continue;
            }
            catch (NumberFormatException nfe) {
                log.warn("unable to parse book id", nfe);
            }
        }
        return books;
    }

    public void save() throws IOException {
        PrintWriter xml = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(FileEnvironment.getXML(this.id)), "UTF-8"));
        xml.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        xml.println("<book");
        xml.println("\t\tformat=\"2\"");
        xml.println("\t\tid=\"" + this.id + "\"");
        xml.println("\t\tversion=\"" + this.version + "\"");
        xml.println("\t\tdate=\"" + this.date + "\"");
        xml.println("\t\ttitle=\"" + Book.encodeAttribute(this.name) + "\"");
        xml.println("\t\tpublisher=\"" + Book.encodeAttribute(this.publisher) + "\"");
        xml.println("\t\tauthor=\"" + Book.encodeAttribute(this.author) + "\"");
        xml.println("\t\turl=\"" + Book.encodeAttribute(this.url) + "\"");
        xml.println("\t\tmagic=\"" + this.magicValue + "\"");
        xml.println(">");
        xml.println("\t<entries>");
        Iterator<Integer> iterator = this.indexIDs.iterator();
        while (iterator.hasNext()) {
            Entry entry = this.indexEntries.get(iterator.next());
            String type = "script";
            if (entry.isSub()) {
                type = "sub";
            } else if (entry.isMP3()) {
                type = "mp3";
            } else if (entry.isTTS()) {
                type = "tts";
            }
            xml.print("\t\t<entry id=\"" + entry.getTingID() + "\" type=\"" + type + "\"");
            if (entry.isMP3()) {
                String mp3name = "";
                if (entry.getMP3() != null) {
                    mp3name = entry.getMP3().getName();
                }
                xml.print(" mp3=\"" + Book.encodeAttribute(mp3name) + "\"");
            }
            xml.println(">");
            if (entry.isCode() || entry.isSub()) {
                xml.println("\t\t\t<code>" + Book.encodeValue(entry.getScript().toString()) + "</code>");
            } else if (entry.isTTS()) {
                TTSEntry tts = entry.getTTS();
                String arguments = " voice=\"" + tts.voice + "\"";
                arguments = arguments + " variant=\"" + tts.variant + "\"";
                arguments = arguments + " amplitude=\"" + tts.amplitude + "\"";
                arguments = arguments + " pitch=\"" + tts.pitch + "\"";
                arguments = arguments + " speed=\"" + tts.speed + "\"";
                xml.println("\t\t\t<tts" + arguments + ">" + Book.encodeValue(tts.text) + "</tts>");
            }
            xml.println("\t\t\t<hint>" + Book.encodeValue(entry.getHint()) + "</hint>");
            xml.println("\t\t</entry>");
        }
        xml.println("\t</entries>");
        xml.println("\t<registers>");
        for (int i = 0; i <= this.emulator.getMaxRegister(); ++i) {
            if (this.emulator.getHint(i).trim().isEmpty()) continue;
            xml.println("\t\t<register id=\"" + i + "\">");
            xml.println("\t\t\t<hint>" + Book.encodeValue(this.emulator.getHint(i)) + "</hint>");
            xml.println("\t\t</register>");
        }
        xml.println("\t</registers>");
        xml.println("\t<constants>" + this.constants.toString() + "</constants>");
        xml.println("</book>");
        xml.close();
        HashSet<String> filenames = new HashSet<String>();
        File audioDir = FileEnvironment.getAudioDirectory(this.id);
        File[] files = audioDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            filenames.add(files[i].getName());
        }
        iterator = this.indexIDs.iterator();
        while (iterator.hasNext()) {
            Entry entry = this.indexEntries.get(iterator.next());
            if (!entry.isMP3() && !entry.isTTS() || entry.getMP3() == null || !entry.getMP3().exists()) continue;
            filenames.remove(entry.getMP3().getName());
        }
        Iterator toDelete = filenames.iterator();
        while (toDelete.hasNext()) {
            new File(audioDir, (String)toDelete.next()).delete();
        }
        this.changed = false;
    }

    public static String getLabel(File xmlFile) throws IOException {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(xmlFile);
            doc.getDocumentElement().normalize();
            Element bookElement = doc.getDocumentElement();
            int format = Integer.parseInt(bookElement.getAttribute("format"));
            if (format > 2) {
                throw new IOException("unknown file format");
            }
            String id = bookElement.getAttribute("id");
            while (id.length() < 5) {
                id = "0" + id;
            }
            return id + ": " + bookElement.getAttribute("title") + " (" + bookElement.getAttribute("author") + ")";
        }
        catch (SAXException ex) {
            throw new IOException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new Error();
        }
        catch (NumberFormatException ex) {
            throw new IOException(ex);
        }
    }

    private static String getTagContent(Node node) {
        NodeList childNodes = node.getChildNodes();
        String content = "";
        if (childNodes.getLength() > 0) {
            content = childNodes.item(0).getNodeValue();
        }
        return content;
    }

    public static void loadXML(File file, Book book, ProgressDialog progress) throws IOException {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(file);
            doc.getDocumentElement().normalize();
            Element bookElement = doc.getDocumentElement();
            int format = Integer.parseInt(bookElement.getAttribute("format"));
            if (format > 2) {
                throw new IOException("unknown file format");
            }
            if (book.getID() != Integer.parseInt(bookElement.getAttribute("id"))) {
                throw new IOException("book id missmatch");
            }
            book.version = Integer.parseInt(bookElement.getAttribute("version"));
            book.date = Integer.parseInt(bookElement.getAttribute("date"));
            book.magicValue = Integer.parseInt(bookElement.getAttribute("magic"));
            book.name = bookElement.getAttribute("title");
            book.publisher = bookElement.getAttribute("publisher");
            book.author = bookElement.getAttribute("author");
            book.url = bookElement.getAttribute("url");
            NodeList entries = doc.getElementsByTagName("entry");
            if (progress != null) {
                progress.setMax(entries.getLength());
            }
            for (int i = 0; i < entries.getLength(); ++i) {
                Node entryNode = entries.item(i);
                if (progress != null) {
                    progress.setVal(i);
                }
                if (entryNode.getNodeType() != 1) continue;
                Element eElement = (Element)entryNode;
                int tingID = Integer.parseInt(eElement.getAttribute("id"));
                String type = eElement.getAttribute("type");
                String mp3 = eElement.getAttribute("mp3");
                Entry entry = new Entry(book, tingID);
                if (type.equals("mp3")) {
                    File f = new File(FileEnvironment.getAudioDirectory(book.getID()), mp3);
                    if (f.exists() && f.isFile()) {
                        entry.setMP3(f);
                    } else {
                        entry.setMP3();
                    }
                } else if (type.equals("script") || type.equals("sub")) {
                    String code = Book.getTagContent(eElement.getElementsByTagName("code").item(0));
                    Script script = new Script(code, entry);
                    entry.setScript(script);
                    if (type.equals("sub")) {
                        entry.setSub();
                    }
                } else if (type.equals("tts")) {
                    Element ttsElement = (Element)eElement.getElementsByTagName("tts").item(0);
                    String ttsText = Book.getTagContent(ttsElement);
                    TTSEntry ttsEntry = new TTSEntry(ttsText);
                    ttsEntry.voice = ttsElement.getAttribute("voice");
                    ttsEntry.variant = ttsElement.getAttribute("variant");
                    ttsEntry.amplitude = Integer.parseInt(ttsElement.getAttribute("amplitude"));
                    ttsEntry.speed = Integer.parseInt(ttsElement.getAttribute("speed"));
                    ttsEntry.pitch = Integer.parseInt(ttsElement.getAttribute("pitch"));
                    ttsEntry.voice = OS.isWindows() ? ttsEntry.voice.replace('/', '\\') : ttsEntry.voice.replace('\\', '/');
                    entry.setTTS(ttsEntry);
                } else {
                    throw new IOException("unknown type: " + type);
                }
                entry.setHint(Book.getTagContent(eElement.getElementsByTagName("hint").item(0)));
                book.addEntry(entry.getTingID());
                book.indexEntries.put(entry.getTingID(), entry);
            }
            if (progress != null) {
                progress.done();
            }
            NodeList registers = doc.getElementsByTagName("register");
            for (int i = 0; i < registers.getLength(); ++i) {
                Node registerNode = registers.item(i);
                if (registerNode.getNodeType() != 1) continue;
                Element registerElement = (Element)registerNode;
                int rID = Integer.parseInt(registerElement.getAttribute("id"));
                String hint = Book.getTagContent(registerElement.getElementsByTagName("hint").item(0));
                book.emulator.setHint(rID, hint);
            }
        }
        catch (SAXException ex) {
            throw new IOException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new Error();
        }
        catch (NumberFormatException ex) {
            throw new IOException(ex);
        }
    }

    public Constants getConstants() {
        return this.constants;
    }

    private String md5(File file) throws IOException {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            FileInputStream is = new FileInputStream(file);
            DigestInputStream dis = new DigestInputStream(is, md);
            byte[] buffer = new byte[4096];
            while (dis.read(buffer) >= 0) {
            }
            byte[] bytes = md.digest();
            char[] hexChars = new char[bytes.length * 2];
            for (int j = 0; j < bytes.length; ++j) {
                int v = bytes[j] & 0xFF;
                hexChars[j * 2] = hexArray[v >>> 4];
                hexChars[j * 2 + 1] = hexArray[v & 0xF];
            }
            return new String(hexChars);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
    }

    private static int getNextAddress(int x) {
        x += 256 - (x & 0xFF);
        while (x % 512 != 0) {
            x += 256;
        }
        return x;
    }

    private void generateOufFile(DataOutputStream out, ProgressDialog progress) throws IOException, SyntaxError {
        int startOfIndexTable = 104;
        int lastID = this.getLastID();
        int size = lastID - 15000;
        out.writeInt(startOfIndexTable);
        out.writeInt(2);
        out.writeInt(15001);
        out.writeInt(lastID);
        out.writeInt(size);
        out.writeInt(this.id);
        out.writeInt((int)this.magicValue);
        out.writeInt((int)this.date);
        out.writeInt(0);
        out.writeInt(65535);
        for (int i = 40; i < startOfIndexTable; ++i) {
            out.writeByte(0);
        }
        int pos = startOfIndexTable + 12 * size;
        for (int i = 0; i < size; ++i) {
            Entry entry = this.getEntryByOID(i + 15001);
            if (entry == null) {
                out.writeInt(0);
                out.writeInt(0);
                out.writeInt(0);
                continue;
            }
            pos = Book.getNextAddress(pos);
            int code = IndexTableCalculator.getCodeFromPositionInFile(pos, i);
            int _size = entry.getSize();
            out.writeInt(code);
            out.writeInt(Math.max(_size, 0));
            log.debug(i + 15001 + " @0x" + Integer.toHexString(pos) + " code=0x" + Integer.toHexString(code) + " size=" + _size);
            if (entry.isMP3() || entry.isTTS()) {
                out.writeInt(1);
                entry.getMP3();
            } else {
                out.writeInt(2);
            }
            pos += Math.max(entry.getSize(), 0);
        }
        if (progress != null) {
            progress.setMax(size);
        }
        pos = startOfIndexTable + 12 * size;
        byte[] buffer = new byte[4096];
        for (int t = 0; t < size; ++t) {
            Entry e;
            if (progress != null) {
                progress.setVal(t);
            }
            if ((e = this.getEntryByOID(t + 15001)) == null) continue;
            int pad = Book.getNextAddress(pos) - pos;
            pos += pad;
            for (int i = 0; i < pad; ++i) {
                out.write(0);
            }
            if (e.isMP3() || e.isTTS()) {
                int b;
                if (e.getMP3() == null) continue;
                FileInputStream in = new FileInputStream(e.getMP3());
                while ((b = ((InputStream)in).read(buffer)) >= 0) {
                    out.write(buffer, 0, b);
                    pos += b;
                }
                ((InputStream)in).close();
                continue;
            }
            byte[] bin = e.getScript().compile();
            out.write(bin);
            pos += bin.length;
        }
        out.close();
    }

    public HashSet<Integer> getAllUsedRegisters() throws IOException, SyntaxError {
        Iterator<Integer> ids = this.indexIDs.iterator();
        HashSet<Integer> registers = new HashSet<Integer>();
        while (ids.hasNext()) {
            Entry entry = this.indexEntries.get(ids.next());
            if (!entry.isCode() && !entry.isSub()) continue;
            registers.addAll(entry.getScript().getAllUsedRegisters());
        }
        return registers;
    }

    public void generateTTS(ProgressDialog progress) throws IOException {
        Iterator<Integer> ids = this.indexIDs.iterator();
        progress.setMax(this.indexIDs.size());
        int c = 0;
        try {
            while (ids.hasNext()) {
                Entry entry = this.indexEntries.get(ids.next());
                if (entry.isTTS()) {
                    entry.getTTS().generateTTS(entry);
                }
                progress.setVal(c++);
            }
        }
        catch (IOException ioe) {
            progress.done();
            throw ioe;
        }
        progress.done();
    }

    public void epsExport(File dir, ProgressDialog progress) throws IOException, IllegalArgumentException {
        this.epsExport(dir, 100, progress);
    }

    public void epsExport(File dir, int size, ProgressDialog progress) throws IOException, IllegalArgumentException {
        int bookSize = this.getLastID() - 15000;
        if (this.id > 15000) {
            throw new IllegalArgumentException("maximale Buch ID: 15000");
        }
        if (this.id < 0) {
            throw new IllegalArgumentException("minimale Buch ID: 0");
        }
        if (Translator.ting2code(this.id) < 0) {
            throw new IllegalArgumentException("die Code-ID zur Buch ID " + this.id + " ist zur Zeit noch unbekannt");
        }
        if (15000 + bookSize > Translator.getMaxObjectCode()) {
            throw new IllegalArgumentException("zu viele OIDs. Maximale zur Zeit unterst\u00fczte OIS: " + Translator.getMaxObjectCode());
        }
        PrintWriter out = new PrintWriter(new FileWriter(new File(dir, "activation.eps")));
        Codes.drawEps(Translator.ting2code(this.id), size, size, out);
        out.close();
        if (progress != null) {
            progress.setMax(bookSize);
        }
        for (int i = 0; i < bookSize; ++i) {
            if (progress != null) {
                progress.setVal(i);
            }
            out = new PrintWriter(new FileWriter(new File(dir, i + 15001 + ".eps")));
            Codes.drawEps(Translator.ting2code(i + 15001), 100, 100, out);
            out.close();
        }
    }

    public void pngExport(File dir, ProgressDialog progress) throws IOException, IllegalArgumentException {
        this.pngExport(dir, 100, progress);
    }

    public void pngExport(File dir, int size, ProgressDialog progress) throws IOException, IllegalArgumentException {
        int bookSize = this.getLastID() - 15000;
        if (this.id > 15000) {
            throw new IllegalArgumentException("maximale Buch ID: 15000");
        }
        if (this.id < 0) {
            throw new IllegalArgumentException("minimale Buch ID: 0");
        }
        if (Translator.ting2code(this.id) < 0) {
            throw new IllegalArgumentException("die Code-ID zur Buch ID " + this.id + " ist zur Zeit noch unbekannt");
        }
        if (15000 + bookSize > Translator.getMaxObjectCode()) {
            throw new IllegalArgumentException("zu viele OIDs. Maximale zur Zeit unterst\u00fczte OIS: " + Translator.getMaxObjectCode());
        }
        FileOutputStream out = new FileOutputStream(new File(dir, "activation.png"));
        Codes.drawPng(Translator.ting2code(this.id), size, size, out);
        ((OutputStream)out).close();
        if (progress != null) {
            progress.setMax(bookSize);
        }
        for (int i = 0; i < bookSize; ++i) {
            if (progress != null) {
                progress.setVal(i);
            }
            out = new FileOutputStream(new File(dir, i + 15001 + ".png"));
            Codes.drawPng(Translator.ting2code(i + 15001), 100, 100, out);
            ((OutputStream)out).close();
        }
    }

    public void epsSingleExport(File file, int tingID) throws IOException, IllegalArgumentException {
        if (tingID > 65536) {
            throw new IllegalArgumentException("maximale Ting-ID: 65535");
        }
        if (tingID < 0) {
            throw new IllegalArgumentException("minimale Ting-ID: 0");
        }
        if (Translator.ting2code(tingID) < 0) {
            throw new IllegalArgumentException("der Ting-Code zur Buch ID " + this.id + " ist zur Zeit noch unbekannt");
        }
        PrintWriter out = new PrintWriter(new FileWriter(file));
        Codes.drawEps(Translator.ting2code(tingID), 200, 200, out);
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(File dir, ProgressDialog progress) throws IOException, IllegalArgumentException, SyntaxError {
        int size = this.getLastID() - 15000;
        if (this.name == null || this.name.isEmpty() || this.name.trim().isEmpty()) {
            throw new IllegalArgumentException("Kein Buchname angegeben");
        }
        if (this.publisher == null || this.publisher.isEmpty() || this.publisher.trim().isEmpty()) {
            throw new IllegalArgumentException("Kein Herausgeber angegeben");
        }
        if (this.author == null || this.author.isEmpty() || this.author.trim().isEmpty()) {
            throw new IllegalArgumentException("Kein Autor angegeben");
        }
        if (this.version < 1) {
            throw new IllegalArgumentException("Keine g\u00fcltige Version angegeben");
        }
        if (this.url == null) {
            this.url = "";
        }
        for (int i = 0; i < size; ++i) {
            Entry entry = this.getEntryByOID(i + 15001);
            if (entry == null || !entry.isMP3() || entry.getMP3() == null || entry.getMP3().canRead()) continue;
            throw new IllegalArgumentException("Die Datei '" + entry.getMP3().getAbsolutePath() + "' konnte nicht gelesen werden.");
        }
        String idS = "" + this.id;
        while (idS.length() < 5) {
            idS = "0" + idS;
        }
        File ouf = new File(dir, idS + "_en.ouf");
        File png = new File(dir, idS + "_en.png");
        File src = new File(dir, idS + "_en.src");
        InputStream input = null;
        OutputStream output = null;
        try {
            int bytesRead;
            input = this.getCover().exists() ? new FileInputStream(this.getCover()) : this.getClass().getResourceAsStream("/noCover.png");
            output = new FileOutputStream(png);
            byte[] buf = new byte[1024];
            while ((bytesRead = input.read(buf)) > 0) {
                output.write(buf, 0, bytesRead);
            }
        }
        finally {
            if (input != null) {
                input.close();
            }
            if (output != null) {
                output.close();
            }
        }
        PrintWriter srcOut = new PrintWriter(new FileWriter(src));
        this.generateScriptFile(srcOut);
        srcOut.close();
        DataOutputStream out = new DataOutputStream(new FileOutputStream(ouf));
        this.generateOufFile(out, progress);
        out.close();
        PrintWriter txt = new PrintWriter(new FileWriter(new File(dir, idS + "_en.txt")));
        txt.println("Name: " + this.name.trim());
        txt.println("Publisher: " + this.publisher.trim());
        txt.println("Author: " + this.author.trim());
        txt.println("Book Version: " + this.version);
        txt.println("URL: " + this.url);
        txt.println("ThumbMD5: " + this.md5(png));
        txt.println("FileMD5: " + this.md5(ouf));
        txt.println("ScriptMD5: " + this.md5(src));
        txt.println("Book Area Code: en");
        txt.close();
    }

    public void addRegisterListener(RegisterListener listener) {
        this.emulator.addRegisterListener(listener);
    }

    public void generateScriptFile(File srcFile) throws IOException {
        this.generateScriptFile(new PrintWriter(new FileWriter(srcFile)));
    }

    void generateScriptFile(PrintWriter out) throws IOException {
        Iterator<Integer> ids = this.indexIDs.iterator();
        int pathLength = FileEnvironment.getBookDirectory(this.id).getCanonicalPath().length() + 1;
        while (ids.hasNext()) {
            Entry entry = this.indexEntries.get(ids.next());
            if (entry == null) continue;
            if (entry.isMP3()) {
                out.print("Precode=" + entry.getTingID() + "\r\n");
                out.print("TYPE=1\r\n");
                out.print("[Note]\r\n");
                out.print(entry.getHint() + "\r\n");
                out.print("[Content]\r\n");
                if (entry.getMP3() != null) {
                    out.print(entry.getMP3().getAbsolutePath().substring(pathLength).replace('\\', '/') + "\r\n");
                }
                out.print("\r\n");
                continue;
            }
            if (!entry.isCode() && !entry.isSub()) continue;
            out.print("Precode=" + entry.getTingID() + "\r\n");
            out.print("TYPE=0\r\n");
            out.print("[Note]\r\n");
            out.print(entry.getHint() + "\r\n");
            out.print("[Content]\r\n");
            out.print(entry.getScript().toString().replaceAll("\n", "\r\n"));
            out.print("\r\n");
        }
        out.close();
    }

    public Set<Integer> getIds() {
        return this.indexEntries.keySet();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void importFromScriptFile(InputStream scriptFile) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(scriptFile));
        Entry entry = null;
        int type = -1;
        boolean inNote = false;
        boolean inContent = false;
        String line = in.readLine();
        while (line != null) {
            if (line.startsWith("Precode=")) {
                inContent = false;
                inNote = false;
                int tingID = Integer.parseInt(line.substring(line.indexOf(61) + 1));
                this.addEntry(tingID);
                entry = this.getEntryByOID(tingID);
            } else if (entry != null && line.startsWith("TYPE=")) {
                type = Integer.parseInt(line.substring(line.indexOf(61) + 1));
                if (type == 0) {
                    entry.setScript(new Script("", entry));
                } else {
                    if (type != 1) throw new RuntimeException("Unknown type " + type);
                    entry.setMP3();
                }
            } else if (line.startsWith("[Note]")) {
                inNote = true;
                inContent = false;
            } else if (line.startsWith("[Content]")) {
                inNote = false;
                inContent = true;
            } else if (type == 1 && inContent) {
                if (!line.trim().isEmpty()) {
                    entry.setMP3(new File(FileEnvironment.getAudioDirectory(this.id), line));
                } else {
                    inContent = false;
                }
            } else if (type == 0 && inContent) {
                Script script = entry.getScript();
                script.setCode(script.toString() + line + "\n");
            } else if (inNote) {
                entry.setHint(entry.getHint() + line + "\n");
            }
            line = in.readLine();
        }
    }

    public void removeEntryByTingID(int tingID) {
        this.indexEntries.remove(tingID);
        this.indexIDs.removeByTingID(tingID);
        this.changeMade();
    }

    public boolean deleteBook(int id) {
        if (id == this.id) {
            return false;
        }
        String _id = Integer.toString(id);
        while (_id.length() < 5) {
            _id = "0" + _id;
        }
        File f = new File(FileEnvironment.getBooksDirectory(), _id);
        return this.deleteFile(f);
    }

    private boolean deleteFile(File f) {
        if (f.isDirectory()) {
            File[] childs = f.listFiles();
            for (int i = 0; i < childs.length; ++i) {
                if (this.deleteFile(childs[i])) continue;
                return false;
            }
            return f.delete();
        }
        if (f.isFile()) {
            return f.delete();
        }
        return false;
    }
}

