/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import tingeltangel.core.scripting.Commands;
import tingeltangel.tools.PrefEntry;

public class Preferences {
    private static final Map<String, PrefEntry> prefs = new HashMap<String, PrefEntry>();
    public static final int INTEGER = 1;
    public static final int STRING = 2;
    public static final int BOOL = 3;

    private static int str2type(String type) {
        if (type.equals("bool")) {
            return 3;
        }
        if (type.equals("string")) {
            return 2;
        }
        if (type.equals("integer")) {
            return 1;
        }
        throw new Error("unknown type '" + type + "'");
    }

    public static Set<String> getKeys() {
        return prefs.keySet();
    }

    public static String getDefault(String key) {
        return Preferences.prefs.get((Object)key).defaultValue;
    }

    public static String getDescription(String key) {
        return Preferences.prefs.get((Object)key).description;
    }

    public static int getType(String key) {
        return Preferences.prefs.get((Object)key).type;
    }

    static {
        try {
            String row;
            BufferedReader in = new BufferedReader(new InputStreamReader(Commands.class.getResourceAsStream("/preferences.properties")));
            while ((row = in.readLine()) != null) {
                if ((row = row.trim()).startsWith("#") || row.isEmpty()) continue;
                int p = row.indexOf(61);
                if (p < 0) {
                    throw new Error("missing '=' on line: " + row);
                }
                String key = row.substring(0, p).trim();
                String[] val = row.substring(p + 1).split("\\|");
                PrefEntry e = new PrefEntry();
                e.type = Preferences.str2type(val[0].trim());
                e.defaultValue = val[1].trim();
                e.description = val[2].trim();
                prefs.put(key, e);
            }
            in.close();
        }
        catch (IOException ioe) {
            throw new Error(ioe);
        }
    }
}

